/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.Border;

import de.uni_paderborn.fujaba.fsa.listener.BorderHighlighter;
import de.uni_paderborn.fujaba.fsa.swing.JBoundsPanel;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * UMLClass: 'FSAPanel'
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.52.2.1 $
 */
public class FSAPanel extends FSAContainer
{
   /**
    * Constructor for class FSAPanel
    *
    * @param incr  No description provided
    */
   public FSAPanel (LogicUnparseInterface incr)
   {
      super (incr, null, null);
   }


   /**
    * Constructor for class FSAPanel
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSAPanel (LogicUnparseInterface incr, JComponent parent)
   {
      super (incr, null, parent);
   }


   /**
    * Constructor for class FSAPanel
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAPanel (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Constructor for class FSAPanel
    *
    * @param incr                 No description provided
    * @param propName             No description provided
    * @param parent               No description provided
    * @param transientProperties  No description provided
    */
   public FSAPanel (LogicUnparseInterface incr, String propName, JComponent parent, boolean transientProperties)
   {
      super (incr, propName, parent, transientProperties);
   }


   /**
    * Constructor for class FSAObject
    *
    * @param incr          No description provided
    * @param propName      No description provided
    * @param parent        No description provided
    * @param myJComponent  No description provided
    */
   public FSAPanel (LogicUnparseInterface incr,
                    String propName,
                    JComponent parent,
                    JComponent myJComponent)
   {
      super (incr, propName, parent, myJComponent);
   }


   /**
    * creates a standard JPanel with frame for this FSAFrame UMLMethod: '+ createJComponent
    * () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JPanel panel = new JBoundsPanel();
      panel.setDoubleBuffered (true);
      panel.setBackground (FSAObject.COLOR_BACKGROUND);
      panel.setForeground (FSAObject.COLOR_FOREGROUND);
      return  (panel);
   }


   /**
    * Sets the specified LayoutManager for the associated JPanel.
    *
    * @param layout  The new layout value
    */
   public void setLayout (LayoutManager layout)
   {
      getJComponent().setLayout (layout);
   }


   /**
    * Sets the specified Border for the associated JPanel.
    *
    * @param border  The new border value
    */
   public void setBorder (Border border)
   {
      getJComponent().setBorder (border);
      getJComponent().putClientProperty (BorderHighlighter.OLDBORDER_CLIENTPROPERTY, null);
      getJComponent().putClientProperty (BorderHighlighter.OLDBORDERCOLOR_CLIENTPROPERTY, null);
   }


   /**
    * Gets the specified Border from the associated JPanel.
    *
    * @return   The border value
    */
   public Border getBorder()
   {
      return getJComponent().getBorder();
   }


   /*
    *  Locks are applied to 'higher' level objects (for example UMLClass). But It seems that to prevent the
    *  color from changing to it's original color we require to lock this panel. So that we only revert to
    *  the original colour iff the panel has not been locked. The (un)locking is applied from the class:
    *  fi.uta.action.LockClassAction
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean locked = false;


   /**
    * Sets the lock attribute of the FSAPanel object
    *
    * @param lockValue  The new lock value
    */
   public void setLock (boolean lockValue)
   {
      locked = lockValue;
   }


   /**
    * Get the locked attribute of the FSAPanel object
    *
    * @return   The locked value
    */
   public boolean isLocked()
   {
      return locked;
   }

}

/*
 * $Log: FSAPanel.java,v $
 * Revision 1.52.2.1  2005/05/30 15:31:59  fklar
 * introduced new constructor that takes transientProperties as argument
 *
 */
