/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

import javax.swing.*;
import javax.swing.event.*;


/**
 * Only changes to original Notifier: - ignores visibility of components - endpoint for ancestor
 * listening can be specified
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.13 $
 */
public class AncestorNotifier implements ComponentListener, PropertyChangeListener, Serializable
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static Object KEY =
      new Object()
      {
         public String toString()
         {
            return AncestorNotifier.class.getName() + "::key";
         }
      };

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Container end = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Component firstAncestor;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   EventListenerList listenerList = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComponent root = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Object PROPERTYCHANGE_MULTICAST =
      new Object()
      {
         public String toString()
         {
            return AncestorNotifier.class.getName() + "::propertyChangeMulticast";
         }
      };
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Object COMPONENT_MULTICAST =
      new Object()
      {
         public String toString()
         {
            return AncestorNotifier.class.getName() + "::componentMulticast";
         }
      };


   /**
    * Constructor for class AncestorNotifier
    *
    * @param root  No description provided
    */
   public AncestorNotifier (JComponent root)
   {
      this (root, null);
   }


   /**
    * Constructor for class AncestorNotifier
    *
    * @param root  No description provided
    * @param end   No description provided
    */
   public AncestorNotifier (JComponent root, Container end)
   {
      this.root = root;
      this.end = end;
      addListeners (root, true);
   }


   /**
    * Sets the root attribute of the AncestorNotifier object
    *
    * @param root  The new root value
    */
   public void setRoot (JComponent root)
   {
      if (this.root != root)
      {
         if (this.root != null)
         {
            removeAllListeners();
         }
         this.root = root;
         if (root != null)
         {
            addListeners (root, true);
         }
      }
   }


   /**
    * Get the root attribute of the AncestorNotifier object
    *
    * @return   The root value
    */
   public JComponent getRoot()
   {
      return this.root;
   }


   /**
    * Sets the end attribute of the AncestorNotifier object
    *
    * @param end  The new end value
    */
   public void setEnd (Container end)
   {
      if (end != this.end)
      {
         Container oldEnd = this.end;

         if (oldEnd == null ||  (end != null && SwingUtilities.isDescendingFrom (end, oldEnd)))
         {
            removeListeners (end);
            this.end = end;
         }
         else
         {
            this.end = end;
            addListeners (oldEnd, false);
         }
      }
   }


   /**
    * Get the end attribute of the AncestorNotifier object
    *
    * @return   The end value
    */
   public Container getEnd()
   {
      return this.end;
   }


   /**
    * Access method for an one to n association.
    *
    * @param l  The object added.
    */
   public void addAncestorListener (AncestorListener l)
   {
      if (listenerList == null)
      {
         listenerList = new EventListenerList();
      } // end of if ()

      listenerList.add (AncestorListener.class, l);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param l  No description provided
    */
   public void removeAncestorListener (AncestorListener l)
   {
      if (listenerList != null)
      {
         listenerList.remove (AncestorListener.class, l);
      } // end of if ()
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfAncestorListeners()
   {
      return  (listenerList == null ? 0 : listenerList.getListenerCount());
   }


   /*
    *  Notify all listeners that have registered interest for notification on
    *  this event type. The event instance is lazily created using the
    *  parameters passed into the fire method.
    *
    *  @see EventListenerList
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param source          No description provided
    * @param id              No description provided
    * @param ancestor        No description provided
    * @param ancestorParent  No description provided
    */
   protected void fireAncestorAdded (JComponent source, int id, Container ancestor, Container ancestorParent)
   {
      if (listenerList != null)
      {
         // Guaranteed to return a non-null array
         Object[] listeners = listenerList.getListenerList();
         // Process the listeners last to first, notifying
         // those that are interested in this event
         for (int i = listeners.length - 2; i >= 0; i -= 2)
         {
            if (listeners[i] == AncestorListener.class)
            {
               // Lazily create the event:
               AncestorEvent ancestorEvent = new AncestorEvent (source, id, ancestor, ancestorParent);
                ((AncestorListener) listeners[i + 1]).ancestorAdded (ancestorEvent);
            }
         }
      }
   }


   /*
    *  Notify all listeners that have registered interest for notification on
    *  this event type. The event instance is lazily created using the
    *  parameters passed into the fire method.
    *
    *  @see EventListenerList
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param source          No description provided
    * @param id              No description provided
    * @param ancestor        No description provided
    * @param ancestorParent  No description provided
    */
   protected void fireAncestorRemoved (JComponent source, int id, Container ancestor, Container ancestorParent)
   {
      // Guaranteed to return a non-null array
      if (listenerList != null)
      {
         Object[] listeners = listenerList.getListenerList();
         // Process the listeners last to first, notifying
         // those that are interested in this event
         for (int i = listeners.length - 2; i >= 0; i -= 2)
         {
            if (listeners[i] == AncestorListener.class)
            {
               // Lazily create the event:
               AncestorEvent ancestorEvent = new AncestorEvent (source, id, ancestor, ancestorParent);
                ((AncestorListener) listeners[i + 1]).ancestorRemoved (ancestorEvent);
            }
         }
      }
   }


   /*
    *  Notify all listeners that have registered interest for notification on
    *  this event type. The event instance is lazily created using the
    *  parameters passed into the fire method.
    *
    *  @see EventListenerList
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param source          No description provided
    * @param id              No description provided
    * @param ancestor        No description provided
    * @param ancestorParent  No description provided
    */
   protected void fireAncestorMoved (JComponent source, int id, Container ancestor, Container ancestorParent)
   {
      if (listenerList != null)
      {
         // Guaranteed to return a non-null array
         Object[] listeners = listenerList.getListenerList();
         // Process the listeners last to first, notifying
         // those that are interested in this event
         for (int i = listeners.length - 2; i >= 0; i -= 2)
         {
            if (listeners[i] == AncestorListener.class)
            {
               // Lazily create the event:
               AncestorEvent ancestorEvent = new AncestorEvent (source, id, ancestor, ancestorParent);
                ((AncestorListener) listeners[i + 1]).ancestorMoved (ancestorEvent);
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void removeAllListeners()
   {
      removeListeners (root);
   }


   /**
    * Access method for an one to n association.
    *
    * @param ancestor    The object added.
    * @param addToFirst  The object added.
    */
   void addListeners (Component ancestor, boolean addToFirst)
   {
      Component a;

      firstAncestor = null;
      for (a = ancestor; firstAncestor == null &&  (a != end ||  (addToFirst && a == ancestor)); a = a.getParent())
      {
         if (addToFirst || a != ancestor)
         {
            if (a instanceof JComponent)
            {
               JComponent jAncestor = (JComponent) a;

               addComponentListener (jAncestor);
               addPropertyChangeListener (jAncestor);
            }
            else
            {
               a.addComponentListener (this);
            }
         }
         if (a.getParent() == null)
         {
            firstAncestor = a;
         }
      }
      if (firstAncestor instanceof Window)
      {
         firstAncestor = null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param ancestor  No description provided
    */
   void removeListeners (Component ancestor)
   {
      Component a;
      for (a = ancestor; a != null && a != end; a = a.getParent())
      {
         if (a instanceof JComponent)
         {
            JComponent jAncestor = (JComponent) a;
            removeComponentListener (jAncestor);
            removePropertyChangeListener (jAncestor);
         }
         else
         {
            a.removeComponentListener (this);
         }
         if (a == firstAncestor)
         {
            break;
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentShown (ComponentEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentHidden (ComponentEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentResized (ComponentEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentMoved (ComponentEvent e)
   {
      Component source = e.getComponent();

      fireAncestorMoved (root, AncestorEvent.ANCESTOR_MOVED, (Container) source, source.getParent());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   public void propertyChange (PropertyChangeEvent evt)
   {
      String s = evt.getPropertyName();
      if (s != null &&  (s.equals ("ancestor") || s.equals ("parent")))
      {
         JComponent component = (JComponent) evt.getSource();

         if (evt.getNewValue() != null)
         {
            if (component == firstAncestor)
            {
               addListeners (component, false);
               fireAncestorAdded (root, AncestorEvent.ANCESTOR_ADDED, component, component.getParent());
            }
         }
         else
         {
            boolean needsNotify =  (firstAncestor == null || firstAncestor == end); //???
            Container oldParent = (Container) evt.getOldValue();

            removeListeners (oldParent); //FIXME:Wrong component, Swing notification is top-down

            firstAncestor = component;
            if (needsNotify)
            {
               fireAncestorRemoved (root, AncestorEvent.ANCESTOR_REMOVED, component, oldParent);
            }
         }
      }
   }


   /**
    * Access method for an one to n association.
    *
    * @param target  The object added.
    */
   private void addPropertyChangeListener (JComponent target)
   {
      PropertyChangeMulticast multicast = (PropertyChangeMulticast) target.getClientProperty (PROPERTYCHANGE_MULTICAST);
      if (multicast == null)
      {
         multicast = new PropertyChangeMulticast();
         target.putClientProperty (PROPERTYCHANGE_MULTICAST, multicast);
         target.addPropertyChangeListener ("ancestor", multicast);
         target.addPropertyChangeListener ("parent", multicast);
      }
      multicast.addPropertyChangeListener (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    */
   private void removePropertyChangeListener (JComponent target)
   {
      PropertyChangeMulticast multicast = (PropertyChangeMulticast) target.getClientProperty (PROPERTYCHANGE_MULTICAST);
      if (multicast != null)
      {
         multicast.removePropertyChangeListener (this);
         if (multicast.getSize() == 0)
         {
            target.putClientProperty (PROPERTYCHANGE_MULTICAST, null);
            target.removePropertyChangeListener ("ancestor", multicast);
            target.removePropertyChangeListener ("parent", multicast);
         }
      }
   }


   /**
    * Access method for an one to n association.
    *
    * @param target  The object added.
    */
   private void addComponentListener (JComponent target)
   {
      ComponentMulticast multicast = (ComponentMulticast) target.getClientProperty (COMPONENT_MULTICAST);
      if (multicast == null)
      {
         multicast = new ComponentMulticast();
         target.putClientProperty (COMPONENT_MULTICAST, multicast);
         target.addComponentListener (multicast);
      }
      multicast.addComponentListener (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    */
   private void removeComponentListener (JComponent target)
   {
      ComponentMulticast multicast = (ComponentMulticast) target.getClientProperty (COMPONENT_MULTICAST);
      if (multicast != null)
      {
         multicast.removeComponentListener (this);
         if (multicast.getSize() == 0)
         {
            target.putClientProperty (COMPONENT_MULTICAST, null);
            target.removeComponentListener (multicast);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllListeners();
      root = null;
      if (listenerList != null)
      {
         Object[] listeners = listenerList.getListenerList();

         for (int i = listeners.length - 2; i >= 0; i -= 2)
         {
            listenerList.remove ((Class) listeners[i], (java.util.EventListener) listeners[i + 1]);
         }
         listenerList = null;
      } // end of if ()

      firstAncestor = null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $ $Date: 2004/11/03 10:17:54 $
    */
   private final static class PropertyChangeMulticast implements PropertyChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private PropertyChangeListener[] multicastTargets = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private int size = 0;


      /**
       * Access method for an one to n association.
       *
       * @param listener  The object added.
       */
      public void addPropertyChangeListener (PropertyChangeListener listener)
      {
         ensureCapacity (size + 1);
         multicastTargets[size++] = listener;
      }


      /**
       * Get the size attribute of the PropertyChangeMulticast object
       *
       * @return   The size value
       */
      public int getSize()
      {
         return size;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param listener  No description provided
       */
      public void removePropertyChangeListener (PropertyChangeListener listener)
      {
         for (int i = 0; i < size; i++)
         {
            if (multicastTargets[i] == listener)
            {
               if (i < size - 1)
               {
                  multicastTargets[i] = multicastTargets[size - 1];
               }
               multicastTargets[size - 1] = null;
               size--;
            }
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param minCapacity  No description provided
       */
      private void ensureCapacity (int minCapacity)
      {
         int oldCapacity =  (multicastTargets == null ? 0 : multicastTargets.length);
         if (minCapacity > oldCapacity)
         {
            PropertyChangeListener[] oldData = multicastTargets;
            int newCapacity =  (oldCapacity * 3) / 2 + 1;

            if (newCapacity < minCapacity)
            {
               newCapacity = minCapacity;
            }
            if (newCapacity < 3)
            {
               newCapacity = 3;
            }

            multicastTargets = new PropertyChangeListener[newCapacity];

            if (oldData != null)
            {
               System.arraycopy (oldData, 0, multicastTargets, 0, size);
            }
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param arg0  No description provided
       */
      public void propertyChange (PropertyChangeEvent arg0)
      {
         for (int i = 0; i < size; i++)
         {
            multicastTargets[i].propertyChange (arg0);
         }
      }
   }


   /**
    * since this is only used internally and we only need the componentMoved events, these
    * are the only ones that are multicasted <p>
    *
    * Copy/Pasted for class cast performance reasons
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $ $Date: 2004/11/03 10:17:54 $
    */
   private final static class ComponentMulticast implements ComponentListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private ComponentListener[] multicastTargets = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private int size = 0;


      /**
       * Access method for an one to n association.
       *
       * @param listener  The object added.
       */
      public void addComponentListener (ComponentListener listener)
      {
         ensureCapacity (size + 1);
         multicastTargets[size++] = listener;
      }


      /**
       * Get the size attribute of the ComponentMulticast object
       *
       * @return   The size value
       */
      public int getSize()
      {
         return size;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param listener  No description provided
       */
      public void removeComponentListener (ComponentListener listener)
      {
         for (int i = 0; i < size; i++)
         {
            if (multicastTargets[i] == listener)
            {
               if (i < size - 1)
               {
                  multicastTargets[i] = multicastTargets[size - 1];
               }
               multicastTargets[size - 1] = null;
               size--;
            }
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param minCapacity  No description provided
       */
      private void ensureCapacity (int minCapacity)
      {
         int oldCapacity =  (multicastTargets == null ? 0 : multicastTargets.length);
         if (minCapacity > oldCapacity)
         {
            ComponentListener[] oldData = multicastTargets;
            int newCapacity =  (oldCapacity * 3) / 2 + 1;

            if (newCapacity < minCapacity)
            {
               newCapacity = minCapacity;
            }
            if (newCapacity < 3)
            {
               newCapacity = 3;
            }

            multicastTargets = new ComponentListener[newCapacity];

            if (oldData != null)
            {
               System.arraycopy (oldData, 0, multicastTargets, 0, size);
            }
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void componentHidden (ComponentEvent e)
      {
         /*
          *  for (int i=0;i <size;i++) { multicastTargets[i].componentHidden(e); }
          */
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void componentMoved (ComponentEvent e)
      {
         for (int i = 0; i < size; i++)
         {
            multicastTargets[i].componentMoved (e);
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void componentResized (ComponentEvent e)
      {
         /*
          *  for (int i=0;i <size;i++) {
          *  multicastTargets[i].componentResized(e); }
          */
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void componentShown (ComponentEvent e)
      {
         /*
          *  for (int i=0;i <size;i++) { multicastTargets[i].componentShown(e); }
          */
      }
   }
}

/*
 * $Log: AncestorNotifier.java,v $
 * Revision 1.13  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
