/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class BorderHighlighter implements SelectionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OLDBORDER_CLIENTPROPERTY = BorderHighlighter.class.getName() + "::oldBorder";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OLDBORDERCOLOR_CLIENTPROPERTY = BorderHighlighter.class.getName() + "::oldBorderColor";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Border NOBORDER = new javax.swing.border.EmptyBorder (0, 0, 0, 0);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static BorderHighlighter singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static BorderHighlighter get()
   {
      if (singleton == null)
      {
         singleton = new BorderHighlighter();
      }

      return singleton;
   }


   /**
    * The default constructor is empty.
    */
   private BorderHighlighter() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void selectionChanged (SelectionEvent event)
   {
      JComponent source = (JComponent) event.getSource();

      // restore old border
      Border currentBorder = source.getBorder();
      Border border = getOldBorder (source);
      setOldBorder (source, null);

      if (border != null)
      {
         if (border == NOBORDER)
         {
            border = null;
         }
         source.setBorder (border);

//            log.info("old border: " + border);
//         if (border instanceof CompoundBorder)
//         {
//               source.setLocation(source.getX()+1, source.getY()+1);
//               source.setSize(source.getWidth()-1, source.getHeight()-1);
//         }
      }

      if (border == currentBorder && border instanceof AbstractColorBorder)
      {
         AbstractColorBorder colorBorder = (AbstractColorBorder) border;
         Color color = getOldBorderColor (source);
         if (color != null)
         {
            setOldBorderColor (source, null);
            colorBorder.setBorderColor (color);
         }
      }

      // create new border if needed
      if (event.isSelected())
      {
         Color color = event.isFocused() ? FSAObject.COLOR_FOCUSED : FSAObject.COLOR_SELECTED;
         border = source.getBorder();

         if (border == null)
         {
            setOldBorder (source, NOBORDER);
         }
         else
         {
            setOldBorder (source, border);
         }

         if (border == null)
         {
            source.setBorder (new javax.swing.border.LineBorder (color));
         }
         else if ( (border instanceof javax.swing.border.LineBorder) ||
             ( (border instanceof CompoundBorder) &&  ( ((CompoundBorder) border).getInsideBorder() == null) &&  ( ((CompoundBorder) border).getOutsideBorder() instanceof de.uni_paderborn.fujaba.fsa.swing.border.LineBorder)) ||
             ( (border instanceof CompoundBorder) &&  ( ((CompoundBorder) border).getInsideBorder() instanceof de.uni_paderborn.fujaba.fsa.swing.border.LineBorder) &&  ( ((CompoundBorder) border).getOutsideBorder() == null)))
         {
            border = new de.uni_paderborn.fujaba.fsa.swing.border.LineBorder (color);
            source.setBorder (border);
         }
         else if (border instanceof AbstractColorBorder)
         {
            AbstractColorBorder colorBorder = (AbstractColorBorder) border;
            setOldBorderColor (source, colorBorder.getBorderColor());
            colorBorder.setBorderColor (color);
         }
         else
         {
            Border lineBorder = new javax.swing.border.LineBorder (color);
            border = new CompoundBorder (lineBorder, border);
            source.setBorder (border);

            // log.info("color: " + color);
//            source.setLocation(source.getX()-1, source.getY()-1);
//            source.setSize(source.getWidth()+2, source.getHeight()+2);
            source.setSize (source.getWidth() + 1, source.getHeight() + 1);
         }
      }
      source.repaint();
   }


   /**
    * Sets the oldBorder attribute of the BorderHighlighter object
    *
    * @param comp    The new oldBorder value
    * @param border  The new oldBorder value
    * @return        No description provided
    */
   private boolean setOldBorder (JComponent comp, Border border)
   {
      Object o = comp.getClientProperty (OLDBORDER_CLIENTPROPERTY);
      if (o == null || border == null)
      {
         comp.putClientProperty (OLDBORDER_CLIENTPROPERTY, border);
         return true;
      }
      else if (! (o instanceof Border))
      {
         throw new RuntimeException ("Conflicting Property with name " + OLDBORDER_CLIENTPROPERTY + " found in " + comp);
      }
      return false;
   }


   /**
    * Get the oldBorder attribute of the BorderHighlighter object
    *
    * @param comp  No description provided
    * @return      The oldBorder value
    */
   private Border getOldBorder (JComponent comp)
   {
      Object o = comp.getClientProperty (OLDBORDER_CLIENTPROPERTY);

      if (o == null || o instanceof Border)
      {
         return (Border) o;
      }
      throw new RuntimeException ("Conflicting Property with name " + OLDBORDER_CLIENTPROPERTY + " found in " + comp);
   }


   /**
    * Sets the oldBorderColor attribute of the BorderHighlighter object
    *
    * @param comp  The new oldBorderColor value
    * @param c     The new oldBorderColor value
    * @return      No description provided
    */
   private boolean setOldBorderColor (JComponent comp, Color c)
   {
      Object o = comp.getClientProperty (OLDBORDERCOLOR_CLIENTPROPERTY);
      if (o == null || c == null)
      {
         comp.putClientProperty (OLDBORDERCOLOR_CLIENTPROPERTY, c);
         return true;
      }
      else if (! (o instanceof Color))
      {
         throw new RuntimeException ("Conflicting Property with name " + OLDBORDERCOLOR_CLIENTPROPERTY + " found in " + comp);
      }
      return false;
   }


   /**
    * Get the oldBorderColor attribute of the BorderHighlighter object
    *
    * @param comp  No description provided
    * @return      The oldBorderColor value
    */
   private Color getOldBorderColor (JComponent comp)
   {
      Object o = comp.getClientProperty (OLDBORDERCOLOR_CLIENTPROPERTY);

      if (o == null || o instanceof Color)
      {
         return (Color) o;
      }
      throw new RuntimeException ("Conflicting Property with name " + OLDBORDERCOLOR_CLIENTPROPERTY + " found in " + comp);
   }
}

/*
 * $Log: BorderHighlighter.java,v $
 * Revision 1.16  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
