/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.*;

import de.uni_paderborn.fujaba.basic.FujabaPropertyChangeSupport;
import de.uni_paderborn.fujaba.fsa.update.ListenerHelper;
import de.upb.tools.sdm.Path;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class CascadedPropertyChangeSupport extends FujabaPropertyChangeSupport
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String[] path = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String joinedPath = null;


   /**
    * Constructor for class CascadedPropertyChangeSupport
    *
    * @param path   No description provided
    * @param start  No description provided
    */
   public CascadedPropertyChangeSupport (String path, Object start)
   {
      this (split (path), start);
      this.joinedPath = path;
   }


   /**
    * Constructor for class CascadedPropertyChangeSupport
    *
    * @param path   No description provided
    * @param start  No description provided
    */
   public CascadedPropertyChangeSupport (String[] path, Object start)
   {
      super (start);
      if (start == null || !ListenerHelper.get().isPropertyChangeListenerSupported (start))
      {
         throw new IllegalArgumentException ("Start object must be non-null and must support propertychange-listeners");
      }
      this.path = path;
      initialize();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param str  No description provided
    * @return     No description provided
    */
   private static String[] split (String str)
   {
      if (str == null)
      {
         return new String[0];
      }
      StringTokenizer tokenizer = new StringTokenizer (str, ".");
      String[] result = new String[tokenizer.countTokens()];

      for (int i = 0; tokenizer.hasMoreTokens() && i < result.length; i++)
      {
         String token = tokenizer.nextToken();
         result[i] = token;
      }

      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param path  No description provided
    * @return      No description provided
    */
   private static String join (String[] path)
   {
      return join (path, 0, path.length);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param path  No description provided
    * @param from  No description provided
    * @param to    No description provided
    * @return      No description provided
    */
   static String join (String[] path, int from, int to)
   {
      StringBuffer buffer = new StringBuffer();
      for (int i = from; path != null && i < to; i++)
      {
         buffer.append (path[i]);
         if (i < path.length - 1)
         {
            buffer.append (".");
         }
      }
      return buffer.toString();
   }


   /**
    * Get the path attribute of the CascadedPropertyChangeSupport object
    *
    * @return   The path value
    */
   public String getPath()
   {
      if (joinedPath == null)
      {
         joinedPath = join (path);
      }
      return joinedPath;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void initialize()
   {
      CascadedPCL pcl = new CascadedPCL (path, 0, this);
      Vector start = new Vector();
      start.add (getSource());

      initialize (0, start.iterator(), pcl);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param index  No description provided
    * @param iter   No description provided
    * @param pcl    No description provided
    */
   void initialize (int index, Iterator iter, CascadedPCL pcl)
   {
      CascadedPCL child = null;
      while (iter.hasNext())
      {
         Object source = iter.next();
         ListenerHelper.get().addPropertyChangeListener (source, path[index], pcl);

         if (index < path.length - 1)
         {
            Iterator childIter = new Path (source, path[index]);
            if (childIter.hasNext())
            {
               if (child == null)
               {
                  child = pcl.getChild();
               }

               initialize (index + 1, childIter, child);
            }
         }
      }
   }


   /**
    * Sets the source attribute of the CascadedPropertyChangeSupport object
    *
    * @param source  The new source value
    * @return        No description provided
    */
   public boolean setSource (Object source)
   {
      if (getSource() == null)
      {
         return super.setSource (source);
      }
      else
      {
         throw new UnsupportedOperationException ("Event source cannot be changed");
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.16 $
    */
   private static class CascadedPCL implements PropertyChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private CascadedPCL child = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private CascadedPropertyChangeSupport master = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private String[] path = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private int index = 0;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private String pathString = null;


      /**
       * Constructor for class CascadedPCL
       *
       * @param path    No description provided
       * @param index   No description provided
       * @param master  No description provided
       */
      CascadedPCL (String[] path, int index, CascadedPropertyChangeSupport master)
      {
         this.path = path;
         this.index = index;
         this.master = master;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void propertyChange (PropertyChangeEvent e)
      {
         String name = e.getPropertyName();
         if (this.path[index].equals (name))
         {
            if (this.index != this.path.length - 1)
            {
               Object oldValue = e.getOldValue();
               Object newValue = e.getNewValue();

               if (oldValue != null && child != null)
               {
                  ListenerHelper.get().removePropertyChangeListener (oldValue, this.path[index + 1], child);
               }
               if (newValue != null)
               {
                  ListenerHelper.get().addPropertyChangeListener (newValue, this.path[index + 1], getChild());
               }
            }

            name = master.getPath();
            e = new PropertyChangeEvent (master.getSource(), getPathString(), e.getOldValue(), e.getNewValue());
            master.firePropertyChange (e);
         }
      }


      /**
       * Get the pathString attribute of the CascadedPCL object
       *
       * @return   The pathString value
       */
      private String getPathString()
      {
         if (this.pathString == null)
         {
            this.pathString = CascadedPropertyChangeSupport.join (this.path, 0, this.index + 1);
         }

         return this.pathString;
      }


      /**
       * Get the child attribute of the CascadedPCL object
       *
       * @return   The child value
       */
      CascadedPCL getChild()
      {
         if (child == null)
         {
            child = new CascadedPCL (path, index + 1, master);
         }
         return child;
      }
   }
}

/*
 * $Log: CascadedPropertyChangeSupport.java,v $
 * Revision 1.16  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
