/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.MouseEvent;

import javax.swing.*;


/**
 * A mouse listener to resize diagram elements.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class ComponentBorderListener extends ComponentMouseListener implements AscendDescendMouseHandler.Ascend
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Component theComponent = null;

   /**
    * Attribute to implement the Singleton design pattern. Only one instance is needed of this
    * listener.
    */
   private static ComponentBorderListener listener = null;


   /**
    * The private constructor to implement the Singleton design pattern.
    */
   private ComponentBorderListener() { }


   /**
    * The public method of the Singleton design pattern to get the system wide instance of
    * this listener.
    *
    * @return   No description provided
    */
   public static ComponentBorderListener get()
   {
      if (listener == null)
      {
         listener = new ComponentBorderListener();
      } // end of if ()
      return listener;
   }


   /**
    * Overwrites the default method mousePressed of ComponentMouseListener. A press event initializes
    * the listener for a later dragging.
    *
    * @param event  No description provided
    */
   public void mousePressed (MouseEvent event)
   {
      JComponent comp = (JComponent) event.getSource();
      setOrientation (comp, event);
      if (getOrientation() != UNKNOWN &&
         getOrientation() != INNER)
      {
         theComponent = comp;
         event.consume();
      }
   } // mousePressed


   /**
    * Overwrites the default method mouseReleased of ComponentMouseListener.
    *
    * @param event  No description provided
    */
   public void mouseReleased (MouseEvent event)
   {
      JComponent comp = (JComponent) event.getSource();
      setOrientation (comp, event);
      if (getOrientation() != UNKNOWN &&
         getOrientation() != INNER)
      {
         theComponent = null;
         event.consume();
      }
   } // mouseReleased


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   private void refresh (JComponent comp)
   {
      comp.validate();
   }


   /**
    * Overwrites the default method mouseDragged of ComponentMouseListener. This method resizes
    * the current component when the mouse is dragged at the border of the component.
    *
    * @param event  No description provided
    */
   public void mouseDragged (MouseEvent event)
   {
      JComponent comp = (JComponent) event.getSource();
      if (comp != null &&
         comp == theComponent)
      {
         Point eventPoint = event.getPoint();
         Point point = comp.getLocation();

         // the needed dimensions of the component.
         Dimension rect = comp.getSize();

         int deltaHeight = (int) eventPoint.getY();
         int deltaWidth = (int) eventPoint.getX();
         int newHeight = rect.height;
         int newWidth = rect.width;
         final int orientation = getOrientation();

         if ( (orientation & NORTH) == NORTH)
         {
            newHeight -= deltaHeight;

            deltaHeight = rect.height - newHeight;
            rect.height = newHeight;

            point.y = point.y + deltaHeight;
         }

         if ( (orientation & EAST) == EAST)
         {
            newWidth -= deltaWidth;

            deltaWidth = rect.width - newWidth;

            rect.width = newWidth;
            point.x = point.x + deltaWidth;
         }

         if ( (orientation & WEST) == WEST)
         {
            deltaWidth -= rect.width;
            newWidth += deltaWidth;

            rect.width = newWidth;
         }

         if ( (orientation & SOUTH) == SOUTH)
         {
            deltaHeight -= rect.height;
            newHeight += deltaHeight;

            rect.height = newHeight;
         }

         if (orientation != UNKNOWN &&
            orientation != INNER)
         {
            comp.setLocation (point);
            rect.width = Math.max (rect.width, 10);
            rect.height = Math.max (rect.height, 10);
            comp.setSize (rect);
            comp.setPreferredSize (rect);

            refresh (comp);
            event.consume();
         }
      }
   }
}

/*
 * $Log: ComponentBorderListener.java,v $
 * Revision 1.15  2004/10/22 16:41:35  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
