/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.MouseEvent;

import javax.swing.event.MouseInputAdapter;


/**
 * A Standard listener for other listeners with special functions.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public class ComponentMouseListener extends MouseInputAdapter
{
   /**
    * Internal used constant.
    */
   protected final static int DISTANCE = 2;

   /**
    * Internal used constant.
    */
   protected final static int UNKNOWN = -1;

   /**
    * Flag to show that the mouse is in the north of a component.
    */
   protected final static int NORTH = 1;

   /**
    * Flag to show that the mouse is in the south of a component.
    */
   protected final static int SOUTH = 2;

   /**
    * Flag to show that the mouse is in the east of a component.
    */
   protected final static int EAST = 4;

   /**
    * Flag to show that the mouse is in the west of a component.
    */
   protected final static int WEST = 8;

   /**
    * Flag to show that the mouse is in the component.
    */
   protected final static int INNER = 16;

   /**
    * Holds the last component. This attribute is used by subclasses of this class.
    */
   protected Component lastComponent = null;

   /**
    * Holds the status where the mouse was last seen on the component. The orientation is used
    * by the subclasses of this class.
    */
   private int orientation = UNKNOWN;


   /**
    * Sets the orientation attribute of the ComponentMouseListener object
    *
    * @param orientation  The new orientation value
    * @return             No description provided
    */
   protected boolean setOrientation (int orientation)
   {
      if (this.orientation != orientation)
      {
         this.orientation = orientation;
         return true;
      }

      return false;
   }


   /**
    * Sets the orientation.
    *
    * @param comp   The new orientation value
    * @param event  The new orientation value
    */
   protected void setOrientation (Component comp, MouseEvent event)
   {
      Point point = event.getPoint();
      Rectangle dim = comp.getBounds();

      orientation = UNKNOWN;

      if (Math.abs (point.getY()) <= DISTANCE)
      {
         // upper left corner.
         if (Math.abs (point.getX()) <= DISTANCE)
         {
            orientation = NORTH + EAST;
         } // end of if ()

         // upper right corner.
         else if (Math.abs (dim.width - point.getX()) <= DISTANCE)
         {
            orientation = NORTH + WEST;
         } // end of if ()
         // the mouse pointer is in the north.
         else
         {
            orientation = NORTH;
         } // end of else
      }
      else if (Math.abs (dim.height - point.getY()) <= DISTANCE)
      {
         // lower left corner.
         if (Math.abs (point.getX()) <= DISTANCE)
         {
            orientation = SOUTH + EAST;
         } // end of if ()

         // lower right corner.
         else if (Math.abs (dim.width - point.getX()) <= DISTANCE)
         {
            orientation = SOUTH + WEST;
         } // end of if ()
         // the mouse pointer is in the south.
         else
         {
            orientation = SOUTH;
         } // end of else
      } // end of else
      // left side of the component.
      else if (Math.abs (point.getX()) <= DISTANCE)
      {
         orientation = EAST;
      } // end of if ()
      // left side of the component.
      else if (Math.abs (dim.width - point.getX()) <= DISTANCE)
      {
         orientation = WEST;
      } // end of if ()

      if (orientation == UNKNOWN &&
          (dim.width - point.getX() > 0) &&
          (dim.height - point.getY() > 0))
      {
         orientation = INNER;
      } // end of if ()
   }


   /**
    * Get the orientation attribute of the ComponentMouseListener object
    *
    * @return   The orientation value
    */
   protected int getOrientation()
   {
      return this.orientation;
   }

}

/*
 * $Log: ComponentMouseListener.java,v $
 * Revision 1.13  2004/10/20 17:49:43  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
