/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Calendar;

import javax.swing.*;

import org.apache.log4j.Logger;


/**
 * Standard mouselistener for Components displaying DiagramItems. Handles double clicks on
 * objects. Simply executes the first Popupmenu entry.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class DoubleClickMouseListener extends ComponentMouseListener implements AscendDescendMouseHandler.Descend
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (DoubleClickMouseListener.class);


   /**
    * The default constructor is empty.
    */
   private DoubleClickMouseListener() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static DoubleClickMouseListener singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static DoubleClickMouseListener get()
   {
      if (singleton == null)
      {
         singleton = new DoubleClickMouseListener();
      }

      return singleton;
   }


   /**
    * Overwrites the mouseClicked method of ComponentMouseListener.
    *
    * @param event  No description provided
    */
   public void mouseClicked (MouseEvent event)
   {
      if (event.getClickCount() == 2)
      {
         try
         {
            /*
             *  @todo delete simply executes second context menu item no matter what this does.
             */
            /*
             *  JComponent comp = (JComponent) event.getSource();
             *  FSAObject obj = FSAObject.getFSAObjectFromJComponent (comp);
             *  Object logic = obj.getFSAInterface().getLogic(); // get double clicked object
             *  UserInterfaceManager uiManager = UserInterfaceManager.get();
             *  JPopupMenu menu = uiManager.getFromPopupMenus (logic.getClass().getName());
             *  JMenuItem elem = (JMenuItem) menu.getSubElements()[0]; // get first menu item
             *  ActionListener listener = elem.getActionListeners()[0];
             *  listener.actionPerformed (null); // execute first command
             *  event.consume();
             *  /F2
             */
            // construct and dispatch key pressed and key released event
            // similar to a key stroke on the keyboard
            KeyEvent keyEvent = null;

            EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();

            Calendar cal = Calendar.getInstance();

            long when = cal.getTimeInMillis();

            // key pressed event
            keyEvent = new KeyEvent ((JComponent) event.getSource(), KeyEvent.KEY_PRESSED, when, 0
            /*
             *  no modifier
             */
               , KeyEvent.VK_F2, KeyEvent.CHAR_UNDEFINED);
            queue.postEvent (keyEvent);

            // key released event
            when = cal.getTimeInMillis();
            keyEvent = new KeyEvent ((JComponent) event.getSource(), KeyEvent.KEY_RELEASED, when, 0
            /*
             *  no modifiers
             */
               , KeyEvent.VK_F2, KeyEvent.CHAR_UNDEFINED);
            queue.postEvent (keyEvent);
         }
         catch (Exception e)
         {
            log.error ("Error in DoubleClickMouseListener[]" + e);
         }
      }
   }
}

/*
 * $Log: DoubleClickMouseListener.java,v $
 * Revision 1.12  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
