/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import de.uni_paderborn.fujaba.fsa.swing.EditableComponent;


/**
 * JComboBoxLabelListener.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class EditableComponentListener extends MouseAdapter implements AscendDescendMouseHandler.Descend
{
   /**
    * Inner attribute to implement the Singleton design pattern.
    */
   private static EditableComponentListener listener = null;


   /**
    * Private default constructor to implement the Singleton design pattern.
    */
   private EditableComponentListener() { }


   /**
    * Access method to get the one system wide instance of this listener.
    *
    * @return   No description provided
    */
   public static EditableComponentListener get()
   {
      if (listener == null)
      {
         listener = new EditableComponentListener();
      } // end of if ()
      return listener;
   }


   /**
    * Overwrites the mouseClicked method of InnerElementMouseListener.
    *
    * @param event  No description provided
    */
   public void mouseClicked (MouseEvent event)
   {
      Object component = event.getSource();
      if ( (component instanceof EditableComponent) &&
         event.getClickCount() == 2)
      {
         EditableComponent comp =
            (EditableComponent) component;

         // doubleclick on renderer enables editing
         if (!comp.isEditing() && comp.isEnabled())
         {
            comp.setEditMode();
            event.consume();
         }
      }
   }
}

/*
 * $Log: EditableComponentListener.java,v $
 * Revision 1.12  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
