/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.*;
import java.util.Iterator;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.EditableComponent;


/**
 * handler for some global mouse stuff like hiding of editors in diagrams
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class GlobalMouseHandler extends MouseAdapter
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (GlobalMouseHandler.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static GlobalMouseHandler singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static GlobalMouseHandler get()
   {
      if (singleton == null)
      {
         singleton = new GlobalMouseHandler();
      }

      return singleton;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void recurseMouseEvent (MouseEvent event)
   {
      Component source = event.getComponent();

      if (! (source instanceof JComponent))
      {
         log.error ("GlobalMouseHandler::recurseMouseEvent: Can recurse events only on JComponents" +
            "\n\tSource was " + source);
         return;
      }

      JComponent jSource = (JComponent) source;
      FSAObject object = FSAObject.getFSAObjectFromJComponent (jSource);

      if (object == null)
      {
         log.error ("GlobalMouseHandler::recurseMouseEvent: Cannot recurse events on JComponents without FSAObject" +
            "\n\tSource was " + jSource);
         return;
      }

      int id = event.getID();

      Iterator iter = null;
      Point location = event.getPoint();
      Point offset = null;

      while (iter == null || !iter.hasNext())
      {
         offset = object.getLocation (offset);
         location.x += offset.x;
         location.y += offset.y;

         object = object.getParent();

         if (object == null)
         {
            break;
         }

         if (id == MouseEvent.MOUSE_MOVED || id == MouseEvent.MOUSE_DRAGGED)
         {
            iter = object.iteratorOfMouseMotionListeners();
         }
         else
         {
            iter = object.iteratorOfMouseListeners();
         }
      }

      if (iter != null && iter.hasNext())
      {
         JComponent newSource = object.getJComponent();
         if (newSource != null)
         {
            MouseEvent newEvent = new MouseEvent (newSource, id, event.getWhen(), event.getModifiers(),
               location.x, location.y, event.getClickCount(), event.isPopupTrigger());

            if (id == MouseEvent.MOUSE_MOVED || id == MouseEvent.MOUSE_DRAGGED)
            {
               while (iter.hasNext())
               {
                  MouseMotionListener listener = (MouseMotionListener) iter.next();
                  switch (id)
                  {
                     case MouseEvent.MOUSE_MOVED:
                        listener.mouseMoved (newEvent);
                        break;
                     case MouseEvent.MOUSE_DRAGGED:
                        listener.mouseDragged (newEvent);
                        break;
                  }
               }
            }
            else
            {
               while (iter.hasNext())
               {
                  MouseListener listener = (MouseListener) iter.next();
                  switch (id)
                  {
                     case MouseEvent.MOUSE_PRESSED:
                        listener.mousePressed (newEvent);
                        break;
                     case MouseEvent.MOUSE_RELEASED:
                        listener.mouseReleased (newEvent);
                        break;
                     case MouseEvent.MOUSE_CLICKED:
                        listener.mouseClicked (newEvent);
                        break;
                     case MouseEvent.MOUSE_EXITED:
                        listener.mouseExited (newEvent);
                        break;
                     case MouseEvent.MOUSE_ENTERED:
                        listener.mouseEntered (newEvent);
                        break;
                  }
               }
            }
            if (newEvent.isConsumed())
            {
               event.consume();
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mousePressed (MouseEvent e)
   {
      handleGlobalActions (e);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseReleased (MouseEvent e)
   {
      handleGlobalActions (e);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseClicked (MouseEvent e)
   {
      handleGlobalActions (e);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void handleGlobalActions (MouseEvent e)
   {
      Component source = e.getComponent();
      EditableComponent component = EditableComponent.getLastEditedInstance();

      if (component != null &&
         !SwingUtilities.isDescendingFrom (component, source))
      {
         component.setDisplayMode();
      }
   }
}

/*
 * $Log: GlobalMouseHandler.java,v $
 * Revision 1.12  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
