/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.MouseEvent;

import javax.swing.*;
import javax.swing.event.MouseInputAdapter;

import de.uni_paderborn.fujaba.fsa.FSAGrab;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.11.2.1 $
 */
public class GrabMouseListener extends MouseInputAdapter implements AscendDescendMouseHandler.Descend
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static GrabMouseListener singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static GrabMouseListener get()
   {
      if (singleton == null)
      {
         singleton = new GrabMouseListener();
      }
      return singleton;
   }


   /**
    * Constructor for class GrabMouseListener
    */
   private GrabMouseListener() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void mouseDragged (MouseEvent event)
   {
      JComponent source = (JComponent) event.getSource();

      JGrab jGrab = findGrab (source);
      JComponent target = jGrab.getTarget();

      if (target != null)
      {
         Point eventPoint = SwingUtilities.convertPoint (source, event.getPoint(), target);
         Rectangle bounds = target.getBounds();
         Direction orient = jGrab.getOrientation();
         double align = 0.5;

         Direction tmpOrient = getOrientation (eventPoint.x, eventPoint.y, bounds);

         if (tmpOrient != Direction.UNDEFINED)
         {
            orient = tmpOrient;
         }

         if (orient == Direction.TOP || orient == Direction.BOTTOM)
         {
            if (bounds.width != 0)
            {
               align = eventPoint.x / (double) bounds.width;
            }
         }
         else
         {
            if (bounds.height != 0)
            {
               align = eventPoint.y / (double) bounds.height;
            }
         }

         if (align < 0)
         {
            align = 0;
         }
         else if (align > 1)
         {
            align = 1;
         }

         jGrab.setOrientation (orient);
         jGrab.setAlignment (align);

         FSAGrab grab = (FSAGrab) FSAObject.getFSAObjectFromJComponent (jGrab);
         if (grab != null)
         {
            // make shure data will be stored persistently
            grab.setTransientProperties (false);

            // data will be saved by these calls
            grab.saveOrientation();
            grab.saveAlignment();
         }

         // WHY should we do this ?????
         //jGrab.setAutoOrientation (jGrab.isAutoAlignment());

         event.consume();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param source  No description provided
    * @return        No description provided
    */
   private JGrab findGrab (JComponent source)
   {
      Container comp = source;
      while (comp != null && ! (comp instanceof JGrab))
      {
         comp = comp.getParent();
      }
      if (comp == null)
      {
         throw new RuntimeException ("No JGrab found!");
      }
      return (JGrab) comp;
   }


   /**
    * Get the orientation attribute of the GrabMouseListener class
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param bounds  No description provided
    * @return        The orientation value
    */
   public static Direction getOrientation (int x, int y, Rectangle bounds)
   {
      Direction yAlign = Direction.UNDEFINED;
      Direction xAlign = Direction.UNDEFINED;

      if (y < bounds.height / 2)
      {
         yAlign = Direction.TOP;
      }
      else if (y > bounds.height / 2)
      {
         yAlign = Direction.BOTTOM;
      }

      if (x < bounds.width / 2)
      {
         xAlign = Direction.LEFT;
      }
      else if (x > bounds.width / 2)
      {
         xAlign = Direction.RIGHT;
      }

      if (xAlign == Direction.UNDEFINED)
      {
         return yAlign;
      }
      else if (yAlign == Direction.UNDEFINED)
      {
         return xAlign;
      }
      else
      {
         int dx;
         int dy;
         if (yAlign == Direction.TOP)
         {
            dy = y;
         }
         else
         {
            dy =  (-1) *  (y - bounds.height);
         }

         if (xAlign == Direction.LEFT)
         {
            dx = x;
         }
         else
         {
            dx =  (-1) *  (x - bounds.width);
         }

         if (dy < dx)
         {
            return yAlign;
         }
         else
         {
            return xAlign;
         }
      }
   }
}

/*
 * $Log: GrabMouseListener.java,v $
 * Revision 1.11.2.1  2005/05/25 12:46:13  fklar
 * saving of orientation and alignment after drag-operation
 *
 */
