/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.MouseEvent;

import javax.swing.*;
import javax.swing.event.MouseInputAdapter;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.gui.FPopupMenu;
import de.upb.lib.userinterface.UserInterfaceManager;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.20 $
 */
public class PopupListener extends MouseInputAdapter implements AscendDescendMouseHandler.Ascend
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static PopupListener singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static PopupListener get()
   {
      if (singleton == null)
      {
         singleton = new PopupListener();
      }

      return singleton;
   }


   /**
    * Constructor for class PopupListener
    */
   private PopupListener() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void mouseReleased (MouseEvent event)
   {
      if (event.isPopupTrigger())
      {
         handlePopupRequest (event);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void mousePressed (MouseEvent event)
   {
      if (event.isPopupTrigger())
      {
         handlePopupRequest (event);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   private void handlePopupRequest (MouseEvent event)
   {
      JComponent comp;
      JComponent origin = (JComponent) event.getComponent();

      if (event instanceof AscendDescendMouseHandler.ADMouseEvent)
      {
         comp = (JComponent)  ((AscendDescendMouseHandler.ADMouseEvent) event).getRealSource();
      }
      else
      {
         comp = (JComponent) event.getComponent();
      }

      Point point = event.getPoint();
      if (comp != origin)
      {
         point = SwingUtilities.convertPoint (origin, point, comp);
      }

      boolean done = showPopup (point, comp);
      if (done)
      {
         event.consume();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param point  No description provided
    * @param comp   No description provided
    * @return       No description provided
    */
   public boolean showPopup (Point point, JComponent comp)
   {
      // UMLIncrement implements LogicUnparseInterface
      // some fsas don't have a logic object.
      // with true as parameter fsa gives back the first logic
      // object which it finds in its hierarchy.
      FSAObject fsa = FSAObject.findFSAObjectFromJComponent (comp);
      if (fsa != null)
      {
         LogicUnparseInterface umlIncr = fsa.getLogic (true);
         if (umlIncr != null)
         {
            UserInterfaceManager uiManager = UserInterfaceManager.get();
            String className = umlIncr.getClass().getName();
            JPopupMenu popupMenu = null;
            StringBuffer buffer = new StringBuffer (className).append ("::");
            int baseLength = buffer.length();
            Class tmpClass = comp.getClass();

            // set the item under the popup as popup source
            SelectionManager.get().setPopupSource (comp, umlIncr);

            while (popupMenu == null && tmpClass != Object.class)
            {
               buffer.append (tmpClass.getName());
               popupMenu = uiManager.getFromPopupMenus (buffer.toString(), umlIncr);
               if (popupMenu == null)
               {
                  tmpClass = tmpClass.getSuperclass();
                  buffer = buffer.delete (baseLength, buffer.length());
               }
            }

            if (popupMenu == null)
            {
               popupMenu = uiManager.getFromPopupMenus (className, umlIncr);
            }

            if (popupMenu != null)
            {
               uiManager.initMenu (popupMenu, comp);
               // get the point of the mouseclick and store it in uiManager
               Container parent = comp;
               while (parent.getParent() != null && ! (parent.getParent() instanceof JLayeredPane))
               {
                  parent = parent.getParent();
               }

               uiManager.setLastPointerPosition (point);

               FPopupMenu.show (popupMenu, comp, point.x, point.y);
               return true;
            }
         } // end of if ()
      }
      return false;
   }
}

/*
 * $Log: PopupListener.java,v $
 * Revision 1.20  2004/11/03 10:17:55  lowende
 * Javadoc warnings removed.
 *
 */
