/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.11 $
 */
public class SelectionPropagationListener implements SelectionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static SelectionPropagationListener parentSingleton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static SelectionPropagationListener childrenSingleton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static SelectionPropagationListener siblingsSingleton = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int PARENT = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int CHILDREN = 2;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int SIBLINGS = 3;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static SelectionPropagationListener get()
   {
      return get (CHILDREN);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type  No description provided
    * @return      No description provided
    */
   public static SelectionPropagationListener get (int type)
   {
      SelectionPropagationListener result = null;

      switch (type)
      {
         case PARENT:
            if (parentSingleton == null)
            {
               parentSingleton = new SelectionPropagationListener (PARENT);
            }
            result = parentSingleton;
            break;
         case CHILDREN:
            if (childrenSingleton == null)
            {
               childrenSingleton = new SelectionPropagationListener (CHILDREN);
            }
            result = childrenSingleton;
            break;
         case SIBLINGS:
            if (siblingsSingleton == null)
            {
               siblingsSingleton = new SelectionPropagationListener (SIBLINGS);
            }
            result = siblingsSingleton;
            break;
         default:
            throw new IllegalArgumentException ("Unknown type");
      }

      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int type;


   /**
    * The default constructor is empty.
    *
    * @param type  No description provided
    */
   private SelectionPropagationListener (int type)
   {
      this.type = type;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean inPropagation = false;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public synchronized void selectionChanged (SelectionEvent event)
   {
      if (!inPropagation)
      {
         inPropagation = true;
         try
         {
            JComponent source = (JComponent) event.getSource();
            Component[] targets = getTargets (source);

            for (int i = 0; i < targets.length; i++)
            {
               if (targets[i] instanceof JComponent)
               {
                  JComponent tmpComp = (JComponent) targets[i];
                  SelectionListenerHelper.setSelection (tmpComp, event.getSelection());
               }
            }
         }
         finally
         {
            inPropagation = false;
         }
      }
   }


   /**
    * Get the targets attribute of the SelectionPropagationListener object
    *
    * @param source  No description provided
    * @return        The targets value
    */
   private Component[] getTargets (JComponent source)
   {
      switch (this.type)
      {
         case PARENT:
            return new Component[]{source.getParent()};
         case CHILDREN:
            return source.getComponents();
         case SIBLINGS:
            Container parent = source.getParent();
            if (parent == null)
            {
               return new Component[0];
            }
            Component[] siblingsAndSource = parent.getComponents();
            Component[] siblings = new Component[siblingsAndSource.length - 1];
            int sibPos = 0;
            for (int i = 0; i < siblingsAndSource.length; i++)
            {
               if (siblingsAndSource[i] != source)
               {
                  siblings[sibPos] = siblingsAndSource[i];
                  sibPos++;
               }
            }
            return siblings;
         default:
            throw new IllegalArgumentException ("Unknown type");
      }
   }
}

/*
 * $Log: SelectionPropagationListener.java,v $
 * Revision 1.11  2005/02/14 14:28:07  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
