/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * Constraints for Decorations to Grabs in PanelGrabUI. Used for additional Components to the
 * main grab component. Defines the way the Components should be positioned according to the
 * main component
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class GrabDecoratorConstraints implements DecoratorLayout.Constraints
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte CENTERED = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte ABOVE = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte BELOW = 2;


   /**
    * Constructor for class GrabDecoratorConstraints
    *
    * @param target  No description provided
    * @param gapX    No description provided
    * @param gapY    No description provided
    * @param align   No description provided
    */
   public GrabDecoratorConstraints (JGrab target, int gapX, int gapY, byte align)
   {
      setAlignment (align);
      setGapX (gapX);
      setGapY (gapY);
      setTarget (target);
   }


   /**
    * Constructor for class GrabDecoratorConstraints
    *
    * @param target  No description provided
    * @param align   No description provided
    */
   public GrabDecoratorConstraints (JGrab target, byte align)
   {
      this (target, 0, 0, align);
   }


   /**
    * UMLAttribute: 'alignment : Double'
    */
   private byte alignment = ABOVE;

   /**
    * UMLAttribute: 'gapX : Integer'
    */
   private int gapX = 0;

   /**
    * UMLAttribute: 'gapY : Integer'
    */
   private int gapY = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Component target = null;


   /**
    * UMLMethod: 'Read access method for attribute target : Component'
    *
    * @return   The target value
    */
   public Component getTarget()
   {
      return target;
   }


   /**
    * UMLMethod: 'Write access method for attribute target : Component'
    *
    * @param target  The new target value
    * @return        No description provided
    */
   public Component setTarget (Component target)
   {
      if (this.target != target)
      {
         if (! (target instanceof JGrab))
         {
            throw new IllegalArgumentException ("Target must be a JGrab");
         }

         this.target = target;
      } // if

      return this.target;
   }


   /**
    * Get the location attribute of the GrabDecoratorConstraints object
    *
    * @param comp  No description provided
    * @return      The location value
    */
   public Point getLocation (Component comp)
   {
      JGrab grab = (JGrab) getTarget();
      if (grab == null)
      {
         return comp.getLocation();
      }

      Point pos = grab.getPoint();
      pos = SwingUtilities.convertPoint (grab.getParent(), pos, comp.getParent());

      Dimension compDim = comp.getPreferredSize();

      if (grab.getOrientation() == Direction.TOP || grab.getOrientation() == Direction.BOTTOM)
      {
         pos.y +=  ( (grab.getOrientation() == Direction.TOP) ? -1 : 1) *  (compDim.height + gapY);

         if (alignment == ABOVE)
         {
            pos.x -= gapX + compDim.width;
         }
         else if (alignment == BELOW)
         {
            pos.x += gapX;
         }
         else
         {
            pos.x -= compDim.width / 2;
         }
      }
      else
      {
         pos.x +=  ( (grab.getOrientation() == Direction.LEFT) ? -1 : 1) *  (compDim.width + gapX);

         if (alignment == ABOVE)
         {
            pos.y -= gapY + compDim.height;
         }
         else if (alignment == BELOW)
         {
            pos.y += gapY;
         }
         else
         {
            pos.y -= compDim.height / 2;
         }
      }
      return pos;
   }


   /**
    * UMLMethod: 'Read access method for attribute alignment : Byte'
    *
    * @return   The alignment value
    */
   public byte getAlignment()
   {
      return alignment;
   }


   /**
    * UMLMethod: 'Write access method for attribute alignment : Byte'
    *
    * @param alignment  The new alignment value
    * @return           No description provided
    */
   public byte setAlignment (byte alignment)
   {
      if (this.alignment != alignment)
      {
         if (alignment != CENTERED &&
            alignment != ABOVE &&
            alignment != BELOW)
         {
            throw new IllegalArgumentException ("Target alignment must be one of CENTERED, ABOVE or BELOW");
         }
         this.alignment = alignment;
      } // if

      return this.alignment;
   }


   /**
    * UMLMethod: 'Read access method for attribute gapX : Integer'
    *
    * @return   The gapX value
    */
   public int getGapX()
   {
      return gapX;
   }


   /**
    * UMLMethod: 'Write access method for attribute gapX : Integer'
    *
    * @param gap  The new gapX value
    * @return     No description provided
    */
   public int setGapX (int gap)
   {
      if (this.gapX != gap)
      {
         this.gapX = gap;
      } // if

      return this.gapX;
   }


   /**
    * UMLMethod: 'Read access method for attribute gapY : Integer'
    *
    * @return   The gapY value
    */
   public int getGapY()
   {
      return gapY;
   }


   /**
    * UMLMethod: 'Write access method for attribute gapY : Integer'
    *
    * @param gap  The new gapY value
    * @return     No description provided
    */
   public int setGapY (int gap)
   {
      if (this.gapY != gap)
      {
         this.gapY = gap;
      } // if

      return this.gapY;
   }


   /**
    * UMLMethod: '+ removeYou () : Void'
    */
   public void removeYou()
   {
      setTarget (null);
   }
}

/*
 * $Log: GrabDecoratorConstraints.java,v $
 * Revision 1.11  2004/11/03 10:17:57  lowende
 * Javadoc warnings removed.
 *
 */
