/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.6 $
 */
public class LineStyle extends BasicStroke
{
   /**
    * Basic stroke of the solid linestyle
    */
   public final static BasicStroke SOLID =
      new BasicStroke (1.0f); // Solid line 1 pixel wide

   /**
    * Basic stroke of the dashed linestyle
    */
   public final static BasicStroke DASHED =
      new BasicStroke (
      1.0f,  // Width
   BasicStroke.CAP_SQUARE,  // End cap
   BasicStroke.JOIN_MITER,  // Join style
   10.0f,  // Miter limit
   new float[]{6.0f, 6.0f},  // Dash pattern
   0.0f // Dash phase
   );
   /**
    * Basic stroke of the dotted linestyle
    */
   public final static BasicStroke DOTTED =
      new BasicStroke (
      1.0f,  // Width
   BasicStroke.CAP_SQUARE,  // End cap
   BasicStroke.JOIN_MITER,  // Join style
   10.0f,  // Miter limit
   new float[]{1.0f, 6.0f},  // Dash pattern
   0.0f // Dash phase
   );
   /**
    * Basic stroke of the dot-dashed linestyle
    */
   public final static BasicStroke DOTDASHED =
      new BasicStroke (
      1.0f,  // Width
   BasicStroke.CAP_SQUARE,  // End cap
   BasicStroke.JOIN_MITER,  // Join style
   10.0f,  // Miter limit
   new float[]{
      1.0f, 6.0f, 6.0f, 6.0f
      },  // Dash pattern
   0.0f // Dash phase
   );
   /**
    * Basic stroke of the dot-dot-dashed linestyle
    */
   public final static BasicStroke DOTDOTDASHED =
      new BasicStroke (
      1.0f,  // Width
   BasicStroke.CAP_SQUARE,  // End cap
   BasicStroke.JOIN_MITER,  // Join style
   10.0f,  // Miter limit
   new float[]{
      1.0f, 6.0f, 1.0f, 6.0f, 6.0f, 6.0f
      },  // Dash pattern
   0.0f // Dash phase
   );
}

/*
 * $Log: LineStyle.java,v $
 * Revision 1.6  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
