/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;

import de.upb.tools.fca.FLinkedList;


/**
 * The layouter for the JSeparatedComponent.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class SeparatedPanelLayout implements LayoutManager
{
   /**
    * Internal used list to store the separated components.
    */
   private FLinkedList separatedComps;

   /**
    * Specifies the distance between the panel border and its components.
    */
   protected int gap = 3;


   /**
    * initializes the internal used variables.
    */
   private SeparatedPanelLayout()
   {
      separatedComps = new FLinkedList();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static SeparatedPanelLayout layouter = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static SeparatedPanelLayout get()
   {
      if (layouter == null)
      {
         layouter = new SeparatedPanelLayout();
      } // end of if ()
      return layouter;
   }


   /**
    * Overwrites the addLayoutComponent of LayoutManager. This method is empty.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp)
   {
   }


   /**
    * Overwrites the removeLayoutComponent of LayoutManager. This method is empty.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp)
   {
   }


   /**
    * Get the separatedPreferredSize attribute of the SeparatedPanelLayout object
    *
    * @param parent  No description provided
    * @return        The separatedPreferredSize value
    */
   private Dimension getSeparatedPreferredSize (Container parent)
   {
      JExtendedSeparator lastSep = null;

      Dimension tmpPrefDim = null;
      Dimension separatedPrefDim = new Dimension();

      Component comp[] = parent.getComponents();

      separatedComps.clear();
      for (int i = 0; i < comp.length; i++)
      {
         if (!comp[i].isVisible())
         {
            continue;
         }

         if (comp[i] instanceof JExtendedSeparator)
         {
            lastSep = (JExtendedSeparator) comp[i];
            separatedPrefDim.height += lastSep.getPreferredSize().height + gap / 2;
            if ( (lastSep.getFirst() instanceof JScrollPane) &&
               !separatedComps.contains (lastSep.getFirst()) &&
               lastSep.getFirst().isVisible())
            {
               separatedComps.add (lastSep.getFirst());
               tmpPrefDim = lastSep.getFirst().getPreferredSize();
               separatedPrefDim.height += tmpPrefDim.height + gap;
            } // end of if ()
            if ( (lastSep.getSecond() instanceof JScrollPane) &&
               !separatedComps.contains (lastSep.getSecond()) &&
               lastSep.getSecond().isVisible())
            {
               separatedComps.add (lastSep.getSecond());
               tmpPrefDim = lastSep.getSecond().getPreferredSize();
               separatedPrefDim.height += tmpPrefDim.height + gap;
            } // end of if ()
         } // end of if ()
      }
      return separatedPrefDim;
   }


   /**
    * This method calculates the preferredSize of the Container. Between the objects and around
    * them is the gap.
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container parent)
   {
      JSeparatedPanel tmpParent = (JSeparatedPanel) parent;

      Dimension parentDim = new Dimension();
      Dimension tempDim;

      Component comp[] = tmpParent.getComponents();
      Insets insets = tmpParent.getInsets();

      int height = 0;
      int width = 0;

      for (int i = 0; i < comp.length; i++)
      {
         if (!comp[i].isVisible())
         {
            continue;
         }

         tempDim = comp[i].getPreferredSize();
         if (tempDim != null)
         {
            if ( (tempDim.width + 2 * gap) > width &&
               ! (comp[i] instanceof javax.swing.JSeparator))
            {
               width = tempDim.width + 2 * gap;
            }

            height = height + tempDim.height + gap;
            if ( (comp[i] instanceof javax.swing.JSeparator))
            {
               height -= gap / 2;

            }
         } // end of if ()
      }

      parentDim.width = width + insets.left + insets.right;
      parentDim.height = height + insets.top + insets.bottom + 2 * gap;

      return parentDim;
   }


   /**
    * calculates the minimum layout size of the container.
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container parent)
   {
      Dimension min = new Dimension();
      Insets insets = parent.getInsets();

      min.height = 0;
      min.width = 0;

      for (int index = 0; index < parent.getComponentCount(); index++)
      {
         Component comp = parent.getComponent (index);
         Dimension prefSize = null;

         if (!comp.isVisible())
         {
            continue;
         }

         prefSize = comp.getMinimumSize();

         if (comp instanceof JSeparator)
         {
            min.height += prefSize.height + gap / 2;
         } // end of if ()
         else
         {
            min.height += prefSize.height + gap;
         } // end of else

         if ( (min.width > prefSize.width + 2 * gap) &&
            ! (comp instanceof javax.swing.JSeparator))
         {
            min.width = prefSize.width + 2 * gap;
         } // end of if ()
      } // end of for ()

      min.width = min.width + insets.left + insets.right;
      min.height = min.height + insets.top + insets.bottom + 2 * gap;

      return min;
   }


   /**
    * Calculates the maximum layout size of the container.
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension maximumLayoutSize (Container parent)
   {
      Dimension max = new Dimension();
      Insets insets = parent.getInsets();

      max.height = 0;
      max.width = 0;
      for (int index = 0; index < parent.getComponentCount(); index++)
      {
         Component comp = parent.getComponent (index);
         Dimension prefSize = null;

         if (!comp.isVisible())
         {
            continue;
         }

         prefSize = comp.getMaximumSize();
         if (comp instanceof JSeparator)
         {
            max.height += prefSize.height + gap / 2;
         } // end of if ()
         else
         {
            max.height += prefSize.height + gap;
         } // end of else

         if (max.width <  (prefSize.width + 2 * gap) &&
            ! (comp instanceof javax.swing.JSeparator))
         {
            max.width = prefSize.width + 2 * gap;
         } // end of if ()
      } // end of for ()

      max.height += insets.top + insets.bottom + 2 * gap;
      max.width += insets.left + insets.right;

      return max;
   }


   /**
    * Overwrites the layoutContainer method of the LayoutManager interface.
    *
    * @param parent  No description provided
    */
   public void layoutContainer (Container parent)
   {
      synchronized (parent.getTreeLock())
      {
         int deltaHeight = 0;
         Dimension minDim = null;
         Dimension maxDim = null;

         Rectangle rect = parent.getBounds();
         Insets insets = parent.getInsets();

         Dimension preferredSize = preferredLayoutSize (parent);
         Dimension separatedPrefDim = getSeparatedPreferredSize (parent);
         Dimension sepDims[] = new Dimension[parent.getComponentCount()];

         Dimension tmpSize = separatedPrefDim;

         int maxHeight = rect.height - insets.top - insets.bottom;
         int maxWidth = rect.width - insets.left - insets.right - 2 * gap;
         deltaHeight = preferredSize.height - separatedPrefDim.height - 2 * gap;

         boolean changed = true;
         while (changed &&
            tmpSize.height > maxHeight - deltaHeight)
         {
            changed = false;
            int i = 0;
            Component comps[] = parent.getComponents();
            while (tmpSize.height > maxHeight - deltaHeight &&
               i < comps.length)
            {
               JComponent comp = (JComponent) comps[i];
               if (comp.isVisible() &&
                  separatedComps.contains (comp))
               {
                  if (sepDims[i] == null)
                  {
                     sepDims[i] = comp.getPreferredSize();
                  } // end of if ()

                  minDim = comp.getMinimumSize();
                  if (minDim.height < sepDims[i].height - 1)
                  {
                     sepDims[i].height -= 1;
                     tmpSize.height -= 1;
                     changed = true;
                  } // end of if ()
               }
               i = i + 1;
            } // end of while ()
         } // end of while ()

         changed = true;
         while (changed &&
            tmpSize.height < maxHeight - deltaHeight)
         {
            changed = false;
            int i = 0;
            Component comps[] = parent.getComponents();
            while (tmpSize.height < maxHeight - deltaHeight &&
               i < comps.length)
            {
               JComponent comp = (JComponent) comps[i];
               if (comp.isVisible() &&
                  separatedComps.contains (comp))
               {
                  if (sepDims[i] == null)
                  {
                     sepDims[i] = comp.getPreferredSize();
                  } // end of if ()

                  maxDim = comp.getMaximumSize();
                  if (maxDim.height >= sepDims[i].height + 1)
                  {
                     sepDims[i].height += 1;
                     tmpSize.height += 1;
                     changed = true;
                  } // end of if ()
               }
               i = i + 1;
            } // end of while ()
         } // end of while ()

         Component comp[] = parent.getComponents();

         int x = gap + insets.left;
         int y = gap + insets.top;
         int i;

         Dimension tempDim;
         for (i = 0; i < comp.length; i++)
         {
            if (!comp[i].isVisible())
            {
               continue;
            }

            if (separatedComps.contains (comp[i]) &&
               sepDims[i] != null)
            {
               tempDim = sepDims[i];
            } // end of if ()
            else
            {
               tempDim = comp[i].getPreferredSize();
            } // end of else

            if (comp[i] instanceof javax.swing.JSeparator)
            {
               comp[i].setLocation (x - gap, y - gap / 2);
               y -= gap / 2;
               tempDim.width = maxWidth + 2 * gap;
            }
            else
            {
               comp[i].setLocation (x, y);
               tempDim.width = maxWidth;

            } // end of else

            comp[i].setSize (tempDim);
            y = y + tempDim.height + gap;
         }
      }
   }
}

/*
 * $Log: SeparatedPanelLayout.java,v $
 * Revision 1.16  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
