/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: beebop $
 * @version   $Revision: 1.11.2.1 $
 */
public class ColoredTextBorder extends TextBorder
{

   /**
    * Constructor for class ColoredTextBorder
    *
    * @param aColor  No description provided
    * @param bColor  No description provided
    */
   public ColoredTextBorder (Color aColor, Color bColor)
   {
      super (aColor);
      setTextColor (bColor);
   }


   /**
    * Constructor for class ColoredTextBorder
    *
    * @param aColor  No description provided
    * @param bColor  No description provided
    * @param txt     No description provided
    */
   public ColoredTextBorder (Color aColor, Color bColor, String txt)
   {
      super (aColor, txt);
      setTextColor (bColor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Color textColor = FSAObject.COLOR_FOREGROUND;


   /**
    * Get the textColor attribute of the ColoredTextBorder object
    *
    * @return   The textColor value
    */
   public Color getTextColor()
   {
      return textColor;
   }


   /**
    * Sets the textColor attribute of the ColoredTextBorder object
    *
    * @param newColor  The new textColor value
    */
   public void setTextColor (Color newColor)
   {
      if (!textColor.equals (newColor))
      {
         textColor = newColor;
         // perhaps a repaint might be a good thing to do here JN
      }
   }


   /**
    * This method draws the Border for Set objects.
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
   {
      Color oldColor = g.getColor();
      Font oldFont = g.getFont();

      g.setColor (getBorderColor());
      g.setFont (getFont());

      g.drawString (getUpperLeftText(), x, y + 9);

      g.setColor (oldColor);
      g.setFont (oldFont);
   }
}

/*
 * $Log: ColoredTextBorder.java,v $
 * Revision 1.11.2.1  2005/05/15 11:36:20  beebop
 * text borders now can display string values at the lower left and right side and the upper left and right side, respectively, each possibly with its own color.
 *
 */
