/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * This border is used for SDL-CreateProcess.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.10 $
 */
public class ProcessBorder extends AbstractColorBorder
{
   /**
    * Constructor for class ProcessBorder
    */
   public ProcessBorder()
   {
      super();
   }


   /**
    * Constructor for class ProcessBorder
    *
    * @param aColor  No description provided
    */
   public ProcessBorder (Color aColor)
   {
      super();
      setBorderColor (aColor);
   }


   /**
    * Get the borderInsets attribute of the ProcessBorder object
    *
    * @param c  No description provided
    * @return   The borderInsets value
    */
   public Insets getBorderInsets (Component c)
   {
      return new Insets (11, 2, 11, 2);
   }


   /**
    * Get the borderInsets attribute of the ProcessBorder object
    *
    * @param c       No description provided
    * @param insets  No description provided
    * @return        The borderInsets value
    */
   public Insets getBorderInsets (Component c, Insets insets)
   {
      insets = new Insets (11, 2, 11, 2);
      return insets;
   }


   /**
    * Get the borderOpaque attribute of the ProcessBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return false;
   }


   /**
    * This method draws the Border for SDL-CreateProcess.
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
   {
      Color oldColor = g.getColor();

      int newX[] = new int[9];
      int newY[] = new int[9];

      int corner = height / 5;
      int right = x + width - 1;
      int bottom = y + height - 1;

      newX[0] = x + corner;
      newY[0] = y;

      newX[1] = right - corner;
      newY[1] = y;

      newX[2] = right;
      newY[2] = y + corner;

      newX[3] = right;
      newY[3] = bottom - corner;

      newX[4] = right - corner;
      newY[4] = bottom;

      newX[5] = x + corner;
      newY[5] = bottom;

      newX[6] = x;
      newY[6] = bottom - corner;

      newX[7] = x;
      newY[7] = y + corner;

      newX[8] = x + corner;
      newY[8] = y;

      g.setColor (FSAObject.COLOR_BACKGROUND);
      g.fillPolygon (newX, newY, 8);
      g.setColor (getBorderColor());
      g.drawPolyline (newX, newY, 9);
      g.setColor (oldColor);
   }
}

/*
 * $Log: ProcessBorder.java,v $
 * Revision 1.10  2004/11/03 10:18:00  lowende
 * Javadoc warnings removed.
 *
 */
