/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;
import java.awt.geom.Rectangle2D;

import de.uni_paderborn.fujaba.basic.FontContainer;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: beebop $
 * @version   $Revision: 1.12.2.1 $
 */
public class TextBorder extends AbstractColorBorder
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String upperLeftText;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Color upperLeftColor;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String lowerLeftText;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Color lowerLeftColor;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String upperRightText;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Color upperRightColor;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String lowerRightText;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Color lowerRightColor;


   /**
    * Constructor for class TextBorder
    *
    * @param aColor  No description provided
    */
   public TextBorder (Color aColor)
   {
      super (aColor);
      setUpperLeftColor (aColor);
      setLowerLeftColor (aColor);
      setUpperRightColor (aColor);
      setLowerRightColor (aColor);
   }


   /**
    *Constructor for class TextBorder
    *
    * @param aColor         No description provided
    * @param upperLeftText  No description provided
    */
   public TextBorder (Color aColor, String upperLeftText)
   {
      this (aColor);
      setUpperLeftText (upperLeftText);
   }


   /**
    * Get the lowerLeftText attribute of the TextBorder object
    *
    * @return   The lowerLeftText value
    */
   public String getLowerLeftText()
   {
      return lowerLeftText;
   }


   /**
    * Get the lowerLeftColor attribute of the TextBorder object
    *
    * @return   The lowerLeftColor value
    */
   public Color getLowerLeftColor()
   {
      return lowerLeftColor;
   }


   /**
    * Get the lowerRightText attribute of the TextBorder object
    *
    * @return   The lowerRightText value
    */
   public String getLowerRightText()
   {
      return lowerRightText;
   }


   /**
    * Get the lowerRightColor attribute of the TextBorder object
    *
    * @return   The lowerRightColor value
    */
   public Color getLowerRightColor()
   {
      return lowerRightColor;
   }


   /**
    * Get the upperLeftText attribute of the TextBorder object
    *
    * @return   The upperLeftText value
    */
   public String getUpperLeftText()
   {
      return upperLeftText;
   }


   /**
    * Get the upperLeftColor attribute of the TextBorder object
    *
    * @return   The upperLeftColor value
    */
   public Color getUpperLeftColor()
   {
      return upperLeftColor;
   }


   /**
    * Get the upperRightText attribute of the TextBorder object
    *
    * @return   The upperRightText value
    */
   public String getUpperRightText()
   {
      return upperRightText;
   }


   /**
    * Get the upperRightColor attribute of the TextBorder object
    *
    * @return   The upperRightColor value
    */
   public Color getUpperRightColor()
   {
      return upperRightColor;
   }


   /**
    * Sets the lowerLeftText attribute of the TextBorder object
    *
    * @param lowerLeftText  The new lowerLeftText value
    */
   public void setLowerLeftText (String lowerLeftText)
   {
      this.lowerLeftText = lowerLeftText;
   }


   /**
    * Sets the lowerLeftColor attribute of the TextBorder object
    *
    * @param lowerLeftColor  The new lowerLeftColor value
    */
   public void setLowerLeftColor (Color lowerLeftColor)
   {
      this.lowerLeftColor = lowerLeftColor;
   }


   /**
    * Sets the lowerRightText attribute of the TextBorder object
    *
    * @param lowerRightText  The new lowerRightText value
    */
   public void setLowerRightText (String lowerRightText)
   {
      this.lowerRightText = lowerRightText;
   }


   /**
    * Sets the lowerRightColor attribute of the TextBorder object
    *
    * @param lowerRightColor  The new lowerRightColor value
    */
   public void setLowerRightColor (Color lowerRightColor)
   {
      this.lowerRightColor = lowerRightColor;
   }


   /**
    * Sets the upperLeftText attribute of the TextBorder object
    *
    * @param upperLeftText  The new upperLeftText value
    */
   public void setUpperLeftText (String upperLeftText)
   {
      this.upperLeftText = upperLeftText;
   }


   /**
    * Sets the upperLeftColor attribute of the TextBorder object
    *
    * @param upperLeftColor  The new upperLeftColor value
    */
   public void setUpperLeftColor (Color upperLeftColor)
   {
      this.upperLeftColor = upperLeftColor;
   }


   /**
    * Sets the upperRightText attribute of the TextBorder object
    *
    * @param upperRightText  The new upperRightText value
    */
   public void setUpperRightText (String upperRightText)
   {
      this.upperRightText = upperRightText;
   }


   /**
    * Sets the upperRightColor attribute of the TextBorder object
    *
    * @param upperRightColor  The new upperRightColor value
    */
   public void setUpperRightColor (Color upperRightColor)
   {
      this.upperRightColor = upperRightColor;
   }


   /**
    * Get the borderInsets attribute of the TextBorder object
    *
    * @param c  No description provided
    * @return   The borderInsets value
    */
   public Insets getBorderInsets (Component c)
   {
      int top = 0;
      int bottom = 0;

      if (upperLeftText != null || upperRightText != null)
      {
         top = 13;
      }

      if (lowerLeftText != null || lowerRightText != null)
      {
         bottom = 8;
      }

      return new Insets (top, 0, bottom, 0);
   }


   /**
    * Get the borderInsets attribute of the TextBorder object
    *
    * @param c       No description provided
    * @param insets  No description provided
    * @return        The borderInsets value
    */
   public Insets getBorderInsets (Component c, Insets insets)
   {
      insets = getBorderInsets (c);
      return insets;
   }


   /**
    * Get the borderOpaque attribute of the TextBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Font font = FontContainer.getDefaultFont();


   /**
    * Get the font attribute of the TextBorder object
    *
    * @return   The font value
    */
   public Font getFont()
   {
      return font;
   }


   /**
    * Sets the font attribute of the TextBorder object
    *
    * @param f  The new font value
    */
   public void setFont (Font f)
   {
      font = f;
   }


   /**
    * This method draws the Border for Set objects.
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c, Graphics g, int x, int y, int width,
                            int height)
   {
      Color oldColor = g.getColor();
      Font oldFont = g.getFont();

      g.setFont (getFont());

      Rectangle2D textsize;
      int tx;
      int ty;

      g.setColor (getUpperLeftColor());
      upperLeftText = getUpperLeftText();
      if (upperLeftText != null)
      {
         textsize = g.getFontMetrics().getStringBounds (upperLeftText, g);
         tx = x;
         ty = y + (int) Math.ceil (textsize.getHeight());
         g.drawString (upperLeftText, tx, ty);
      }

      g.setColor (getUpperRightColor());
      upperRightText = getUpperRightText();
      if (upperRightText != null)
      {
         textsize = g.getFontMetrics().getStringBounds (upperRightText, g);
         tx = x + width - (int) Math.ceil (textsize.getWidth());
         ty = y + (int) Math.ceil (textsize.getHeight());
         g.drawString (upperRightText, tx, ty);
      }

      g.setColor (getLowerLeftColor());
      lowerLeftText = getLowerLeftText();
      if (lowerLeftText != null)
      {
         textsize = g.getFontMetrics().getStringBounds (lowerLeftText, g);
         tx = x;
         ty = y + height;
         g.drawString (lowerLeftText, tx, ty);
      }

      g.setColor (getLowerRightColor());
      lowerRightText = getLowerRightText();
      if (lowerRightText != null)
      {
         textsize = g.getFontMetrics().getStringBounds (lowerRightText, g);
         tx = x + width - (int) Math.ceil (textsize.getWidth());
         ty = y + height;
         g.drawString (lowerRightText, tx, ty);
      }

      g.setColor (oldColor);
      g.setFont (oldFont);
   }

}

/*
 * $Log: TextBorder.java,v $
 * Revision 1.12.2.1  2005/05/15 11:36:20  beebop
 * text borders now can display string values at the lower left and right side and the upper left and right side, respectively, each possibly with its own color.
 *
 */
