/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;


/**
 * add and handle listener between fsa and uml. updates from logic to fsa only
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.18 $
 */
public class LogicToFsaUpdater extends AbstractUpdater
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LogicToFsaUpdater.class);


   /**
    * Default Constructor
    */
   public LogicToFsaUpdater()
   {
      super();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private EventListener logicListener = null;


   /**
    * Sets the logicListener attribute of the LogicToFsaUpdater object
    *
    * @param listener  The new logicListener value
    * @return          No description provided
    */
   protected boolean setLogicListener (EventListener listener)
   {
      if (listener != logicListener)
      {
         boolean active = isListenerActive();

         if (active)
         {
            removeListener();
         }
         this.logicListener = listener;
         if (active)
         {
            addListener();
         }
         return true;
      }
      return false;
   }


   /**
    * Get the logicListener attribute of the LogicToFsaUpdater object
    *
    * @return   The logicListener value
    */
   public EventListener getLogicListener()
   {
      return logicListener;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (new LogicToFsaUpdatePCL (this, getFsaAttrName(),
               getFsaObject()));
         }
         ListenerHelper.get().addPropertyChangeListener (getLogicObject(), getLogicAttrName(), (PropertyChangeListener) getLogicListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
            ListenerHelper.get().removePropertyChangeListener (getLogicObject(), getLogicAttrName(), (PropertyChangeListener) getLogicListener());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void initialize()
   {
      if (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null)
      {
         return;
      }

      Method getMethod = null;
      Method setMethod = null;

      Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (getLogicAttrName(), getLogicObject());

      getMethod = methods[0];

      methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (getFsaAttrName(), getFsaObject());

      try
      {
         if (methods[1] != null)
         {
            setMethod = methods[1];
            Object value = getMethod.invoke (getLogicObject(), null);

            setMethod.invoke (getFsaObject(), new Object[]
               {
               getTranslator().translateLogicToFsa (value)
               }
               );
         }
         else
         {
            methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (getFsaAttrName(), getFsaObject().getJComponent());

            setMethod = methods[1];
            Object value = getMethod.invoke (getLogicObject(), null);
            setMethod.invoke (getFsaObject().getJComponent(), new Object[]
               {
               getTranslator().translateLogicToFsa (value)
               }
               );
         }
      }
      catch (InvocationTargetException ite)
      {
         log.error ("Exception in " + this + ".initialize: " + ite.getTargetException().getMessage());
         ite.getTargetException().printStackTrace();
      }
      catch (Exception e)
      {
         if (e instanceof RuntimeException)
         {
            throw (RuntimeException) e;
         }

         e.printStackTrace();
         throw new RuntimeException ("Exception in " + this + ".initialize: " + e.getMessage());
      }
   }
}

/*
 * $Log: LogicToFsaUpdater.java,v $
 * Revision 1.18  2004/11/03 10:18:02  lowende
 * Javadoc warnings removed.
 *
 */
