/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.Serializable;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.27 $
 */
public abstract class BasicPropertyEditor extends JDialog
{
   /**
    * thrown when the parse method fails
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.27 $ $Date: 2004/11/22 19:04:51 $
    */
   public static class ParseException extends Exception
   {
      /**
       * Constructs a new exception with the specified detail message. The cause is not initialized.
       *
       * @param message  the detail message. The detail message is saved for later retrieval
       *      by the {@link #getMessage()} method.
       */
      public ParseException (String message)
      {
         super (message);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected boolean readOnly = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PropertyEditor_Focus_Adapter focus = new PropertyEditor_Focus_Adapter (this);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Container pane;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel panel = new JPanel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEEditPanel editPanel = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel statusPanel = new JPanel();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PERow buttonRow = new PERow (this);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JLabel status = new JLabel ("");
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton buttonOK = new JButton ("OK");
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton buttonAbort = new JButton ("Cancel");

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected ASGElement asgElement = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JFrame frame = null;


   /**
    * Constructor for class BasicPropertyEditor
    *
    * @param frame  No description provided
    */
   public BasicPropertyEditor (JFrame frame)
   {
      super (frame, true);
      setFrame (frame);
      setTitle ("Basic Property Editor");
   }


   /**
    * Create an PropertyEditor with an Dialog as owner So the new PE lies always upon its owner
    *
    * @param dialog  The dialog (PE) which owns this PE
    */
   public BasicPropertyEditor (Dialog dialog)
   {
      super (dialog, true);
      setTitle ("Basic Property Editor");
   } // BasicPropertyEditor


   /**
    * The function initialize any BasicPropertyEditor with - a edit area - a status area -
    * a button area Note: each derived class have to call this function.
    */
   protected void initPE()
   {
      pane = getContentPane();
      SoftBevelBorder border = new SoftBevelBorder (BevelBorder.LOWERED);

      additionalProperties (getPanel());

      getPanel().setLayout (new PEColumnLayout());
      panel.setSize (new Dimension (500, 400));
      panel.setBorder (border);
      statusPanel.setSize (new Dimension (500, 12));
      statusPanel.add (status);
      statusPanel.setBorder (border);
      statusPanel.setLayout (new PEStatusLayout());

      buttonOK.addActionListener (new PropertyEditor_buttonOK_actionAdapter (this));
      buttonAbort.addActionListener (new PropertyEditor_buttonAbort_actionAdapter (this));

      buttonRow.add (buttonOK);
      buttonRow.add (buttonAbort);

      additionalButtons (buttonRow);

      buttonRow.setLayout (new FlowLayout (FlowLayout.RIGHT));
      panel.add (getPanel());
      panel.add (statusPanel);
      panel.add (buttonRow);
      panel.setLayout (new PropertyEditorLayout());
      pane.add (panel, null);
      getRootPane().setDefaultButton (buttonOK);
      pack();
   }


   /**
    * Sets the frame attribute of the BasicPropertyEditor object
    *
    * @param frame  The new frame value
    */
   public final void setFrame (JFrame frame)
   {
      this.frame = frame;
   }


   /**
    * Sets the readOnly attribute of the BasicPropertyEditor object
    *
    * @param b  The new readOnly value
    */
   public void setReadOnly (boolean b)
   {
      readOnly = b;
      buttonOK.setEnabled (!isReadOnly());
   }


   /**
    * Get the readOnly attribute of the BasicPropertyEditor object
    *
    * @return   The readOnly value
    */
   public boolean isReadOnly()
   {
      return readOnly;
   }


   /**
    * The function results a reference of the used frame.
    *
    * @return   The frame value
    */
   public JFrame getFrame()
   {
      return frame;
   }


   /**
    * Action Interface to signal lost or gain of the focus
    *
    * @return   a valid focus adapter
    */
   public PropertyEditor_Focus_Adapter getFocusAdapter()
   {
      return focus;
   }


   /**
    * This functions sets the context to the AST see also getIncrement () and getClassIncrement
    * ()
    *
    * @param asgElement  The new increment value
    */
   public void setIncrement (ASGElement asgElement)
   {
      if (getFrame() != null)
      {
         getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      }

      this.asgElement = asgElement;
      readOnly = false;

      unparse();
      if (getFrame() != null)
      {
         getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.DEFAULT_CURSOR));
      }
   }


   /**
    * Sets the incrementWithoutParse attribute of the BasicPropertyEditor object
    *
    * @param asgElement  The new incrementWithoutParse value
    */
   public void setIncrementWithoutParse (ASGElement asgElement)
   {
      this.asgElement = asgElement;
   }


   /**
    * This function results the context of the coresponding AST Object
    *
    * @return   a valid reference of a AST object
    */
   public ASGElement getIncrement()
   {
      return asgElement;
   }


   /**
    * getPropertyName () results the default name of the edited property
    *
    * @return   a string with the default name of the property
    */
   protected String getPropertyName()
   {
      return "";
   }


   /**
    * unparse () gets the necessary information from the corresponding AST The scann beginns
    * at the Object returned by getIncrement () Note: this function must be implemented by
    * each ancestor
    */
   protected abstract void unparse();


   /**
    * parse () sets the information to the corresponding AST Note: this function must be implemented
    * by each ancestor
    *
    * @throws ParseException  when parsing fails and the dialog should remain on screen
    */
   protected abstract void parse() throws ParseException;


   /**
    * cancel () implements the action needed to destroy the changes Note: this function must
    * be implemented by each ancestor
    */
   protected abstract void cancel();


   /**
    * Default function for Focus Events Should be override if a status text is required.
    */
   public void focusGained()
   {
      setStatus ("");
   }


   /**
    * Default function for Focus Events Should be override if a status text is required.
    */
   public void focusLost()
   {
      setStatus ("");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void centerDialog()
   {
      Dimension screenSize = this.getToolkit().getScreenSize();
      Dimension size = this.getSize();

      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;

      this.setLocation (x, y);
   }


   /**
    * shows the Dialog centered
    */
   public void showCentered()
   {
      pack();
      centerDialog();

      show();
   }


   /**
    * shows the dialog larged and centered
    */
   public void showLarge()
   {
      Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
      dim.width = Math.max (750, dim.width * 3 / 4);
      dim.height = Math.max (550, dim.height * 3 / 4);
      setSize (dim);

      centerDialog();

      show();
   }


   /**
    * Override the function additionalPropertied () to use additional Componenets like TextFields.
    * Each new Component must be added to the edit area.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel) { }


   /**
    * Override the function additionalButtons () to use additional buttons in the button area.
    * Each new button must be added to the button area.
    *
    * @param buttons  No description provided
    */
   protected void additionalButtons (PEComponentGroup buttons) { }


   /**
    * The function setPanel () sets a user specified panel for edit area. The methode must
    * be called before initPE and only as the first access to the edit panel.
    *
    * @param panel  The new panel value
    * @return       true if the panel is set
    */
   public boolean setPanel (PEEditPanel panel)
   {
      if (editPanel == null)
      {
         editPanel = panel;
         return true;
      }
      return false;
   }


   /**
    * The function getPanel () returns a reference to the current edit panel.
    *
    * @return   reference to the edit panel
    */
   private PEEditPanel getPanel()
   {
      if (editPanel == null)
      { // first access to panel

         editPanel = new PEEditPanel();
      }
      return editPanel;
   }


   /**
    * The function setStatus sets the label of the status area
    *
    * @param text  The new status value
    */
   public void setStatus (String text)
   {
      status.setText (text);
   }


   /**
    * The function buttonOK_actionPerfomed () implements the action if the ok button is pressed.
    * Normaly this function implements all steps to make the modification persistent in AST.
    *
    * @param e  No description provided
    */
   public void buttonOK_actionPerformed (ActionEvent e)
   { // public needed temporally, JW.

      if (getFrame() != null)
      {
         getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      } // if

      try
      {
         try
         {
            parse();
            setVisible (false);
            UMLProject.get().refreshDisplay();
         }
         catch (ParseException ex)
         {
            //ok, leave the dialog where it is
         }
      }
      finally
      {
         if (getFrame() != null)
         {
            getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.DEFAULT_CURSOR));
         }
      }
   }


   /**
    * The function buttonOK_actionPerfomed () implements the action if the cancel button is
    * pressed.
    *
    * @param e  No description provided
    */
   void buttonAbort_actionPerformed (ActionEvent e)
   {
      if (getFrame() != null)
      {
         getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      }

      try
      {
         setVisible (false);
         cancel();
         dispose();
      }
      finally
      {
         if (getFrame() != null)
         {
            getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.DEFAULT_CURSOR));
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param buttonIdentifier  No description provided
    * @param e                 No description provided
    * @return                  No description provided
    */
   public boolean buttonActionPerformed (String buttonIdentifier, ActionEvent e)
   {
      return PEButton.remainedUnbound;
   }
}



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.27 $
 */
class PropertyEditor_buttonOK_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   BasicPropertyEditor adaptee;


   /**
    * Constructor for class PropertyEditor_buttonOK_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PropertyEditor_buttonOK_actionAdapter (BasicPropertyEditor adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.buttonOK_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.27 $
 */
class PropertyEditor_buttonAbort_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private BasicPropertyEditor adaptee;


   /**
    * Constructor for class PropertyEditor_buttonAbort_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PropertyEditor_buttonAbort_actionAdapter (BasicPropertyEditor adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.buttonAbort_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.27 $
 */
class PropertyEditorLayout implements LayoutManager, Serializable
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int maximumWidth = 0;


   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container target)
   {
      Dimension dim = new Dimension (0, 0);
      Component item;
      Dimension itemSize;
      Insets inset = target.getInsets();
      int nmembers = target.getComponentCount();
      for (int i = 0; i < nmembers; i++)
      {
         item = target.getComponent (i);
         itemSize = item.getPreferredSize();
         item.setSize (itemSize);
         dim.width = Math.max (dim.width, itemSize.width);
         dim.height += itemSize.height;
      }

      // add the insets
      dim.width += inset.left + inset.right;
      dim.height += nmembers *  (inset.top + inset.bottom);
      maximumWidth = dim.width;
      return dim;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container target)
   {
      return preferredLayoutSize (target);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    */
   public void layoutContainer (Container target)
   {
      Component item;
      Insets inset = target.getInsets();
      int nmembers = target.getComponentCount();
      Dimension size = target.getSize();
      Dimension minimumSize = new Dimension (0, 0);
      for (int i = 0; i < nmembers; i++)
      {
         item = target.getComponent (i);
         if (! (item instanceof PEEditPanel))
         {
            minimumSize.width = Math.max (minimumSize.width, item.getPreferredSize().width);
            minimumSize.height += inset.top + item.getPreferredSize().height + inset.bottom;
         }
      }
      int y = inset.top;
      for (int i = 0; i < nmembers; i++)
      {
         item = target.getComponent (i);
         if (item instanceof PEEditPanel)
         {
            item.setSize (size.width - inset.left - inset.right,
               size.height - minimumSize.height - inset.top - inset.bottom);
         }
         else
         {
            item.setSize (size.width - inset.left - inset.right, item.getSize().height);
         }
         item.setLocation (inset.left, y);
         y += item.getSize().height + inset.bottom + inset.top;
      }
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.27 $
 */
class PEStatusLayout implements LayoutManager, Serializable
{


   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container target)
   {
      Dimension dim = new Dimension (0, 0);
      Insets inset = target.getInsets();
      int textHeight = target.getFontMetrics (target.getFont()).getHeight();
      dim.width = target.getSize().width;
      dim.height = Math.max (target.getSize().height, textHeight + inset.top + inset.bottom);
      return dim;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container target)
   {
      return preferredLayoutSize (target);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    */
   public void layoutContainer (Container target)
   {
      Component item;
      Insets inset = target.getInsets();
      Dimension size = target.getSize();
      if (target.getComponentCount() >= 0)
      {
         item = target.getComponent (0);
         item.setSize (size.width - inset.left - inset.right, size.height - inset.top - inset.bottom);
         item.setLocation (inset.left, inset.top);
      }
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.27 $
 */
class PropertyEditor_Focus_Adapter implements FocusListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private BasicPropertyEditor adaptee;


   /**
    * Constructor for class PropertyEditor_Focus_Adapter
    *
    * @param adaptee  No description provided
    */
   PropertyEditor_Focus_Adapter (BasicPropertyEditor adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void focusGained (FocusEvent e)
   {
      adaptee.focusGained();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void focusLost (FocusEvent e)
   {
      adaptee.focusLost();
   }

}

/*
 * $Log: BasicPropertyEditor.java,v $
 * Revision 1.27  2004/11/22 19:04:51  lowende
 * Some javadoc corrections.
 *
 */
