/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.util.Iterator;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.sdm.Path;


/**
 * Dialog to create a path expression
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.14.2.2 $
 */
public class EditPathExprDialog extends AbstractDialog
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (EditPathExprDialog.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField pathExprField;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField targetNameField;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JLabel startObjectLabel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLObject object;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement elem;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel panel;


   /**
    * Constructor.
    *
    * @param frame    the window this dialog belongs to
    * @param asgElem  No description provided
    */
   public EditPathExprDialog (JFrame frame, ASGElement asgElem)
   {
      super (frame, false);
      elem = asgElem;
      createUserInterface();
      initialize();
   }


   /**
    * Contains the complete user interface of the dialog, except "Ok" and "Cancel" buttons.
    * Called by createUserInterface ().
    *
    * @return   JPanel that is positioned in the middle of the dialog.
    * @see      de.uni_paderborn.fujaba.gui.AbstractDialog#createUserInterface
    */
   protected JPanel createMainPanel()
   {
      GridBagLayout gridBag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      panel = new JPanel();
      //panel.setPreferredSize(new Dimension(200,150));
      panel.setBorder (new TitledBorder ("Create Path Expression"));
      panel.setLayout (new BoxLayout (panel, BoxLayout.X_AXIS));

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.weightx = 1.0;

      JPanel pathExprPanel = new JPanel();
      pathExprPanel.setLayout (gridBag);

      JLabel startLabel = new JLabel ("Start Object");
      startObjectLabel = new JLabel();
      constraints.insets = new Insets (6, 3, 0, 3);
      gridBag.setConstraints (startLabel, constraints);
      constraints.insets = new Insets (3, 3, 0, 3);
      gridBag.setConstraints (startObjectLabel, constraints);

      JLabel pathExprLabel = new JLabel ("Path Expression");
      pathExprField = new JTextField (20);
      // KeyListener that tests whether the path expression is valid or not. [ak]
      PathExpressionKeyListener pathExpressionKeyListener = new PathExpressionKeyListener (this);
      pathExprField.addKeyListener (pathExpressionKeyListener);
      getOkButton().setEnabled (false);

      constraints.insets = new Insets (6, 3, 0, 3);
      gridBag.setConstraints (pathExprLabel, constraints);
      constraints.insets = new Insets (3, 3, 0, 3);
      gridBag.setConstraints (pathExprField, constraints);

      JLabel targetNameLabel = new JLabel ("Name of Target Set");
      targetNameField = new JTextField (20);
      constraints.insets = new Insets (6, 3, 0, 3);
      gridBag.setConstraints (targetNameLabel, constraints);
      constraints.insets = new Insets (3, 3, 0, 3);
      gridBag.setConstraints (targetNameField, constraints);

      pathExprPanel.add (startLabel);
      pathExprPanel.add (startObjectLabel);
      pathExprPanel.add (pathExprLabel);
      pathExprPanel.add (pathExprField);
      pathExprPanel.add (targetNameLabel);
      pathExprPanel.add (targetNameField);

      panel.add (pathExprPanel);

      return panel;
   } // createMainPanel



   /**
    * Read the parameters which can be modified and put all information into the dialogs user
    * interface. Called by initialize ().
    *
    * @see   de.uni_paderborn.fujaba.gui.AbstractDialog#initialize
    */
   protected void unparse()
   {
      if (elem instanceof UMLPath)
      {
         panel.setBorder (new TitledBorder ("Edit Path Expression"));
         UMLPath path = (UMLPath) elem;

         startObjectLabel.setText (path.getSource().getObjectName());
         pathExprField.setText (path.getExpression());
         targetNameField.setText (path.getTarget().getObjectName());

      }
      else if (elem instanceof UMLObject)
      {

         object = (UMLObject) elem;
         startObjectLabel.setText (object.getObjectName());
         if (log.isInfoEnabled())
         {
            log.info ("Object unparse else: " + object);
         }

      }

   } // unparse



   /**
    * Get all information from the user interface and put them back to the parameters that
    * can be modified by this dialog. Called by okPressed ().
    *
    * @see   de.uni_paderborn.fujaba.gui.AbstractDialog#okPressed
    */
   protected void parse()
   {

      UMLPath pathObject;
      String expr = pathExprField.getText();
      String targetName = targetNameField.getText();

      try
      {
         if (elem instanceof UMLObject)
         {

            //create new path

            UMLObject targetSet = new UMLObject();
            targetSet.setObjectName (targetName);
            targetSet.setType (3); //3 is the code for set

            /*
             *  FIXME:
             *  UMLClass targetClass = getTargetClass (expr);
             *  targetSet.setInstanceOf (targetClass);
             */
            pathObject = new UMLPath (object, expr, targetSet);
            UMLDiagram diagram = object.getCurrentActiveDiagram();

            try
            {

               diagram.addToElements (pathObject);
               diagram.addToElements (targetSet);

            }
            catch (Exception e)
            {
               if (log.isInfoEnabled())
               {
                  log.info ("diagram.addToItems does not work");
               }
               e.printStackTrace();
            }

         } //end if
         else
         {
            pathObject = (UMLPath) elem;
            pathObject.setExpression (expr);
            pathObject.getTarget().setObjectName (targetName);
            //fixme:rubbish?!  pathObject.getTarget().setInstanceOf (getTargetClass (expr));
         }

      }
      catch (Exception e)
      {

         if (log.isInfoEnabled())
         {
            log.info ("pathExpression could not be read");
         }
         e.printStackTrace();
      }
   } // parse


   /**
    * * Get the class of the target set
    *
    * @param e      contains the expression to parse
    * @return       String that contains the name of the target String
    * @deprecated   rubbish?!!
    */
   protected UMLClass getTargetClass (String e)
   {
      UMLClass targetClass = null;
      String[] stringArray = e.split ("\\.");
      String classString = stringArray[stringArray.length - 1];
      String className = Path.upFirstChar (classString);

      //get the class of the target set
      Iterator iter = UMLProject.get().getTypeList().iteratorOfTypes();
      while (iter.hasNext())
      {
         UMLType type = (UMLType) iter.next();
         if ( (type instanceof UMLClass) &&  ( (className.compareTo (type.getName())) == 0))
         {
            targetClass = (UMLClass) type;
            break;
         }
      }

      return targetClass;
   }

}

/*
 * $Log: EditPathExprDialog.java,v $
 * Revision 1.14.2.2  2005/09/30 18:56:51  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
