/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.fca.FLinkedList;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.60 $
 */
public class PEActAssertion extends PropertyEditor
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ASSIGN = ":=";
   /*
    *  0
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String EQUAL = "=";
   /*
    *  1
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NOTEQUAL = "!=";
   /*
    *  2
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LESS = "<";
   /*
    *  3
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GREATER = ">";
   /*
    *  4
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LESSEQUAL = "<=";
   /*
    *  5
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GREATEREQUAL = ">=";
   /*
    *  6
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String[] OPERATIONS =
      {ASSIGN, EQUAL, NOTEQUAL, LESS, GREATER, LESSEQUAL, GREATEREQUAL};

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PERadioGroup operation;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PECheck assertion;
   // May not be named "assert", because it is a keyword in Java2 1.4 [tr]

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField attrName;


   /**
    * Get the attrName attribute of the PEActAssertion object
    *
    * @return   The attrName value
    */
   public PETextField getAttrName()
   {
      return attrName;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField value;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEAttrSelection selection;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList addExpr = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList delExpr = new FLinkedList();


   /**
    * Constructor for class PEActAssertion
    *
    * @param frame  No description provided
    */
   public PEActAssertion (JFrame frame)
   {
      super (frame);
      setTitle ("Attribute Assignment and Assertion Editor");
      initPE();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      operation = new PERadioGroup (this, "Operation", OPERATIONS);
      operation.setStatus ("Select the operation.");
      operation.setLayout (new GridLayout (1, 0));
      operation.setSelectedButtonIndex (0);
      assertion = new PECheck (this, "", "JUnit Assert");
      assertion.setStatus ("Select the assign/assert behaviour");
      attrName = new PETextField (this, "Attribute Name");
      value = new PETextField (this, "Value");
      value.setStatus ("Enter the value for the attribut");
      selection = new PEAttrSelection (this);
      selection.setAddListener (new PEActAssertion_addButton_actionAdapter (this));
      selection.setRemoveListener (new PEActAssertion_removeButton_actionAdapter (this));

      selection.setModifyListener (new PEActAssertion_modifyButton_actionAdapter (this));
      PEColumn column = new PEColumn (this);
      column.add (attrName);
      PERow row = new PERow (this);
      row.add (operation);
      row.add (assertion);
      column.add (row);
      column.add (value);
      column.add (selection);

      panel.add (column);
   }


   /**
    * Get the propertyName attribute of the PEActAssertion object
    *
    * @return   The propertyName value
    */
   public String getPropertyName()
   {
      return "assertion";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void unparse()
   {
      if (getIncrement() != null && getIncrement() instanceof UMLObject)
      {
         UMLObject myObj = (UMLObject) getIncrement();
         value.addKeyListener (new CompletionKeyListener (myObj));

         selection.setIncrement (getIncrement());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      if (getIncrement() instanceof UMLObject)
      {
         // remove all assertions first
         Iterator exprsIter = delExpr.iterator();
         UMLAttrExprPair expr = null;
         while (exprsIter.hasNext())
         {
            expr = (UMLAttrExprPair) exprsIter.next();
            expr.removeYou();
         }

         // and then add the new ones
         UMLObject curObj = (UMLObject) getIncrement();
         exprsIter = addExpr.iterator();
         while (exprsIter.hasNext())
         {
            expr = (UMLAttrExprPair) exprsIter.next();
            curObj.addToAttrs (expr);
         }

      }
      addExpr.clear();
      delExpr.clear();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel()
   {
      Iterator exprs = addExpr.iterator();
      UMLAttrExprPair expr = null;
      while (exprs.hasNext())
      {
         expr = (UMLAttrExprPair) exprs.next();
         expr.removeYou();
      }
      // cancel the deletet assertions
      delExpr.clear();
      addExpr.clear();
      // getIncrement ().doCatchUp ();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void provideAttrSelection()
   {
      // ensure we have a class
      if (this.getIncrement() instanceof UMLObject)
      {
         UMLObject curObj = (UMLObject) getIncrement();

         UMLClass curClass = curObj.getInstanceOf();
         if (curClass != null)
         {
            String newAttrName = attrName.getText();
            if (newAttrName != null && !newAttrName.equals (""))
            {
               // provide the attribute
               UMLAttr newAttr = curClass.getFromAllAttrs (newAttrName);
               if (newAttr == null)
               {
                  // we need a new one
                  UMLType str = UMLProject.get().getFromBaseTypes ("String");
                  newAttr = new UMLAttr (newAttrName, false, false, FDeclaration.PUBLIC, null, str, curClass, null);
                  PEVariable.handleAccessMethods (null, true, FDeclaration.PUBLIC, newAttr);
                  selection.fillSourceList();
               }

               // now select it
               selection.setSourceSelectedIncr (newAttr);
            }
         }

      }
   }


   /**
    * Access method for an one to n association.
    */
   public void addPressed()
   {
      ASGElement incr = null;
      if (value.getText().length() == 0)
      {
         return;
      }

      provideAttrSelection();
      String name = attrName.getText();

      if (selection.getSourceSelectedIncr() != null)
      {
         incr = selection.getSourceSelectedIncr();
         if (incr instanceof UMLAttr)
         {
            name = incr.getName();
         }
      }

      if (name != null && !name.equals (""))
      {
         int operationType = operation.getSelectedButtonIndex();
         int assertionType =  (operationType == 0) ? UMLAttrExprPair.POST : UMLAttrExprPair.PRE;
         operationType =  (operationType >= 1) ? operationType - 1 : 0;

         UMLAttrExprPair expression = new UMLAttrExprPair (name,
            assertionType,
            operationType,
            value.getText(),
            (UMLAttr) incr,
            null);
         expression.setAssertInUnitTest (assertion.isSelected());

         addExpr.add (expression);
         selection.addToDest (expression);
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removePressed()
   {
      UMLAttrExprPair expr = (UMLAttrExprPair) selection.getDestSelectedIncr();
      if (expr != null)
      {
         delExpr.add (expr);
         selection.removeFromDest (expr);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void modifyPressed()
   {
      if ( (selection.getSourceSelectedIncr() != null) &&  (value.getText()
         .length() > 0))
      {
         ASGElement incr = selection.getDestSelectedIncr();
         if (incr instanceof UMLAttrExprPair)
         {
            UMLAttrExprPair expression = (UMLAttrExprPair) incr;
            incr = selection.getSourceSelectedIncr();
            if (incr instanceof UMLAttr)
            {
               UMLAttr attr = (UMLAttr) incr;

               String name = attr.getName();
               int operationType = operation.getSelectedButtonIndex();
               int assertionType =  (operationType == 0) ? UMLAttrExprPair.POST : UMLAttrExprPair.PRE;
               operationType =  (operationType >= 1) ? operationType - 1 : 0;

               expression.setName (name);
               expression.setOperation (operationType);
               expression.setQualifier (assertionType);
               expression.setExpression (value.getText());
               expression.setInstanceOf (attr);
               expression.setAssertInUnitTest (assertion.isSelected());

               PEListbox list = selection.getDest().getList();
               PEStringListModel model = (PEStringListModel) list.getModel();
               model.setElementAt (expression.getText(), list.getSelectedIndex());
            }
         }
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param attrPair  No description provided
    */
   public void selectionChanged (UMLAttrExprPair attrPair)
   {
      UMLAttr attr = attrPair.getInstanceOf();
      if (attr != null)
      {
         attrName.setText (attr.getName());
      }

      // is it a pre or post condition?
      int operationType = attrPair.getQualifier() - 1;
      // exclude UMLAttrExprPair.NONE
      if (operationType < 0)
      {
         operationType = 0;
      }

      // operationType = 0 -> pre condition
      // operationType = 1 -> post condition
      operationType =  (operationType == 0) ? attrPair.getOperation() + 1 : 0;

      operation.setSelectedButtonIndex (operationType);

      value.setText (attrPair.getExpression());

      assertion.setSelected (attrPair.isAssertInUnitTest());
   }

}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.60 $
 */
class PEAttrSelection extends PESelection
{


   /**
    * Constructor for class PEAttrSelection
    *
    * @param parent  No description provided
    */
   PEAttrSelection (PropertyEditor parent)
   {
      super (parent);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void fillSourceList()
   {
      clearSource();
      if (getIncrement() instanceof UMLObject)
      {
         UMLObject object = (UMLObject) getIncrement();
         if (object.getInstanceOf() != null)
         {
            UMLClass clazz = object.getInstanceOf();
            Iterator attrs = clazz.iteratorOfAllAttrs();
            if (attrs != null)
            {
               UMLAttr attr = null;
               while (attrs.hasNext())
               {
                  attr = (UMLAttr) attrs.next();
                  if (attr.getAttrType() instanceof UMLBaseTypes)
                  {
                     addToSource (attr);
                  }
               }
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void fillDestList()
   {
      clearDest();
      if (getIncrement() instanceof UMLObject)
      {
         UMLObject object = (UMLObject) getIncrement();
         UMLAttrExprPair attr = null;
         Iterator iter = object.iteratorOfAttrs();
         while (iter.hasNext())
         {
            attr = (UMLAttrExprPair) iter.next();
            addToDest (attr);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void sourceSelectionChanged()
   {
      super.sourceSelectionChanged();

      if (parent instanceof PEActAssertion)
      {
         PEActAssertion myActAssertion = (PEActAssertion) parent;
         UMLAttr attr = (UMLAttr) getSourceSelectedIncr();
         if (attr != null)
         {
            myActAssertion.getAttrName().setText (attr.getName());
         }
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void destSelectionChanged()
   {
      ASGElement destIncr = getDestSelectedIncr();
      if (destIncr != null && destIncr instanceof UMLAttrExprPair)
      {
         UMLAttrExprPair attrPair = (UMLAttrExprPair) destIncr;

         setSourceSelectedIncr (attrPair.getInstanceOf());

         // shit model, notify my parent
         if (parent instanceof PEActAssertion)
         {
             ((PEActAssertion) parent).selectionChanged (attrPair);
         }
      }
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.60 $
 */
class PEActAssertion_addButton_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEActAssertion adaptee;


   /**
    * Constructor for class PEActAssertion_addButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEActAssertion_addButton_actionAdapter (PEActAssertion adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.addPressed();
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.60 $
 */
class PEActAssertion_removeButton_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEActAssertion adaptee;


   /**
    * Constructor for class PEActAssertion_removeButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEActAssertion_removeButton_actionAdapter (PEActAssertion adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.removePressed();
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.60 $
 */
class PEActAssertion_modifyButton_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEActAssertion adaptee;


   /**
    * Constructor for class PEActAssertion_modifyButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEActAssertion_modifyButton_actionAdapter (PEActAssertion adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.modifyPressed();
   }
}

/*
 * $Log: PEActAssertion.java,v $
 * Revision 1.60  2004/10/20 19:51:21  schneider
 * fixed doubled constants - UMLDeclarationInterface deprecated
 *
 */
