/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14 $
 */
public abstract class PEHeaderComponent extends PEBaseComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected String title;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JLabel header = new JLabel();


   /**
    * Constructor for class PEHeaderComponent
    *
    * @param parent  No description provided
    * @param title   No description provided
    */
   public PEHeaderComponent (BasicPropertyEditor parent, String title)
   {
      super();
      setParent (parent);
      setLayout (getLayoutManager());
      setHeader (title);
      add (header);
      addComponents();
   }


   /**
    * Constructor for class PEHeaderComponent
    */
   public PEHeaderComponent()
   {
      super();
      //      add (header);
   }


   /**
    * Sets the header attribute of the PEHeaderComponent object
    *
    * @param header  The new header value
    */
   public void setHeader (String header)
   {
      title = header;
      this.header.setText (title);
   }

   // thsa : added, why disabeled to get title ?
   /**
    * Get the title attribute of the PEHeaderComponent object
    *
    * @return   The title value
    */
   public String getTitle()
   {
      return this.title;
   }
}

/*
 * $Log: PEHeaderComponent.java,v $
 * Revision 1.14  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
