/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.MouseListener;
import java.util.Enumeration;

import javax.swing.*;
import javax.swing.event.ListSelectionListener;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.36 $
 */
public class PEList extends PEHeaderComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEListbox list;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JScrollPane scroller;


   /**
    * Constructor for class PEList
    *
    * @param parent  No description provided
    * @param title   No description provided
    */
   public PEList (BasicPropertyEditor parent, String title)
   {
      super (parent, title);

      setBorder (BorderFactory.createLoweredBevelBorder());
      setSingleSelection (true);
   }


   /**
    * Get the list attribute of the PEList object
    *
    * @return   The list value
    */
   public PEListbox getList()
   {
      return list;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addComponents()
   {
      scroller = new JScrollPane();
      list = new PEListbox();
      scroller.getViewport().add (list);
      add (scroller);
   }


   /**
    * Sets the readOnly attribute of the PEList object
    *
    * @param readOnly  The new readOnly value
    */
   public void setReadOnly (boolean readOnly)
   {
   }


   /**
    * Get the preferredSize attribute of the PEList object
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      Dimension dim = super.getPreferredSize();
      // set the default width to 20 characters
      dim.width = getFontMetrics (getFont()).stringWidth ("12345678901234567890");
      return dim;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param s  No description provided
    */
   public void add (String s)
   {
      list.add (s);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Enumeration elements()
   {
      return list.elements();
   }


   /**
    * Get the selectedIndices attribute of the PEList object
    *
    * @return   The selectedIndices value
    */
   public int[] getSelectedIndices()
   {
      return list.getSelectedIndices();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAll()
   {
      list.removeAll();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param i  No description provided
    */
   public void selectByIndex (int i)
   {
      list.setSelectedIndex (i);
   }


   /**
    * Sets the singleSelection attribute of the PEList object
    *
    * @param b  The new singleSelection value
    */
   public void setSingleSelection (boolean b)
   {
      if (b)
      {
         list.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
      }
      else
      {
         list.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
      }
   }


   /**
    * Get the singleSelection attribute of the PEList object
    *
    * @return   The singleSelection value
    */
   public boolean isSingleSelection()
   {
      return  (list.getSelectionMode() == ListSelectionModel.SINGLE_SELECTION);
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addSelectionListener (ListSelectionListener listener)
   {
      list.addListSelectionListener (listener);
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addMouseListener (MouseListener listener)
   {
      list.addMouseListener (listener);
   }


   /**
    * Get the horzResizable attribute of the PEList object
    *
    * @return   The horzResizable value
    */
   public boolean isHorzResizable()
   {
      return true;
   }


   /**
    * Get the vertResizable attribute of the PEList object
    *
    * @return   The vertResizable value
    */
   public boolean isVertResizable()
   {
      return true;
   }

}

/*
 * $Log: PEList.java,v $
 * Revision 1.36  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
