/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class PERowLayout implements LayoutManager,
   java.io.Serializable
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int preferredWidth;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int resizableWidth;

   // these methods are not used for this layout
   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container target)
   {
      Dimension dim = new Dimension (0, 0);
      Dimension itemSize = null;
      Insets inset = target.getInsets();
      Component item;
      int nmembers = target.getComponentCount();
      preferredWidth = 0;
      resizableWidth = 0;
      for (int i = 0; i < nmembers; i++)
      {
         item = target.getComponent (i);
         itemSize = item.getPreferredSize();

         preferredWidth += itemSize.width;
         // calculate the resizable component size
         if (item instanceof PEResizable)
         {
            PEResizable resizableItem = (PEResizable) item;
            if (resizableItem.isVertResizable())
            {
               resizableWidth += itemSize.width;
            }
         }

         dim.height = Math.max (dim.height, inset.top + itemSize.height + inset.bottom);
         dim.width += inset.left + itemSize.width + inset.right;
      }
      return dim;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container target)
   {
      return preferredLayoutSize (target);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    */
   public void layoutContainer (Container target)
   {
      Dimension size = target.getSize();
      Dimension itemSize;
      Insets inset = target.getInsets();
      Component item;
      float offset = 0;
      int x = inset.left;

      int nmembers = target.getComponentCount();
      for (int i = 0; i < nmembers; i++)
      {
         item = target.getComponent (i);
         item.setLocation (x, inset.top);
         itemSize = item.getPreferredSize();

         if (item instanceof PEResizable)
         {
            PEResizable resizableItem = (PEResizable) item;
            if (resizableItem.isVertResizable())
            {
               // partial resize
               offset =  (size.width - (float) nmembers *  (inset.left + inset.right) - preferredWidth) *  ( (itemSize.width - (float) nmembers *  (inset.left + inset.right)) / resizableWidth);
               itemSize.width = itemSize.width + (int) offset;
            }
            if (resizableItem.isHorzResizable())
            {
               // full height, because row layout
               itemSize.height = size.height - inset.top - inset.bottom;
            }
         }

         item.setSize (itemSize);
         x += itemSize.width + inset.left + inset.right;
      }
   }
}

/*
 * $Log: PERowLayout.java,v $
 * Revision 1.16  2004/10/22 16:41:38  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
