/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;


/**
 * UMLClass builds a dialog for the ComponentEditor
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12.2.2 $
 */
public class PEThrowsDialog extends JDialog
{
   /**
    * UMLMethod : '+ PEThrowsDialog () : Constructor
    */
   public PEThrowsDialog() { } // Default constructor


   /**
    * UMLMethod : '+ PEThrowsDialog (UMLMethod) : Constructor
    *
    * @param frame        No description provided
    * @param method       No description provided
    * @param listOfTypes  No description provided
    */
   public PEThrowsDialog (JFrame frame, UMLMethod method, Enumeration listOfTypes)
   {
      // set the size of the dialog
      setSize (XSCREEN, YSCREEN);
      setResizable (false);
      setModal (true);
      setMethod (method);
      int[] selpos = new int[getMethod().sizeOfThrowsTypes()];
      int selarraypos = 0;
      int listpos = 0;
      Vector tmpData = new Vector();
      while (listOfTypes.hasMoreElements())
      {
         PEItem item = (PEItem) listOfTypes.nextElement();
         String text = item.getText();
         ASGElement incr = item.getIncrement();
         if (text.indexOf ("Exception") > -1)
         {
            tmpData.add (incr);
            Iterator iter = getMethod().iteratorOfThrowsTypes();
            while (iter.hasNext())
            {
               UMLType myType = (UMLType) iter.next();
               if (myType.equals (incr))
               {
                  selpos[selarraypos] = listpos;
                  selarraypos++;
                  break;
               }
            }
            listpos++;
         }
      }
      if (tmpData.size() > 0)
      {
         myTypes = new JList (tmpData.toArray());
         myTypes.setSelectedIndices (selpos);
      }
      else
      {
         myTypes = null;
      }
      getContentPane().setSize (XSCREEN, YSCREEN);
      getContentPane().add (createDialogPanel());
      centerDialog();
      // lets show us the dialog
      setVisible (true);
   } // Constructor


   /**
    * UMLAttribute: ' XSCREEN : int = 300'
    */
   public final static int XSCREEN = 300;

   /**
    * UMLAttribute: ' YSCREEN : int = 300'
    */
   public final static int YSCREEN = 300;

   /**
    * UMLAttribute: ' XSCREEN : int = 300'
    */
   public JList myTypes;

   /**
    * UMLAttribute: ' method : UMLMethod'
    */
   private UMLMethod method;


   /**
    * Get the method attribute of the PEThrowsDialog object
    *
    * @return   The method value
    */
   public UMLMethod getMethod()
   {
      return method;
   } // getMethod


   /**
    * Sets the method attribute of the PEThrowsDialog object
    *
    * @param method  The new method value
    * @return        No description provided
    */
   public UMLMethod setMethod (UMLMethod method)
   {
      if (this.method != method)
      {
         this.method = method;
      }

      return this.method;
   } // setMethod


   /**
    * UMLMethod : '# createDialogPanel () : JPanel
    *
    * @return   No description provided
    */
   protected JPanel createDialogPanel()
   {
      // first create the panel
      JPanel dialogPanel = new JPanel (new BorderLayout());
      // fit the size of panel to the size of the dialog
      dialogPanel.setSize (XSCREEN, YSCREEN);
      // create the dialog elements
      dialogPanel.add (createScreenFields(), BorderLayout.CENTER);
      dialogPanel.add (createButtonPanel(), BorderLayout.SOUTH);

      return dialogPanel;
   } // createDialogPanel


   /**
    * UMLMethod : '# createScreenFields () : JPanel
    *
    * @return   No description provided
    */
   protected JPanel createScreenFields()
   {
      // create an own panel
      JPanel screenPanel = new JPanel();

      // set the layout of the panel
      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      screenPanel.setLayout (gridbag);

      // make an optical border
      screenPanel.setBorder (new TitledBorder ("Select throws..."));

      // first line of dialog
      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.gridwidth = 1;
      if (myTypes != null)
      {
         JScrollPane myPane = new JScrollPane (myTypes);
         gridbag.setConstraints (myPane, c);
         screenPanel.add (myPane);
      }
      else
      {
         Label tmpLabel1 = new Label ("Sorry, no exception classes found.");
         gridbag.setConstraints (tmpLabel1, c);
         screenPanel.add (tmpLabel1);
      }

      // return the dialog-elements panel
      return screenPanel;
   } // createScreenFields


   /**
    * UMLMethod : '# createButtonPanel () : JPanel
    *
    * @return   No description provided
    */
   protected JPanel createButtonPanel()
   {
      // create the panel for the buttons
      JPanel buttonPanel = new JPanel (new FlowLayout());
      buttonPanel.setSize (240, 50);

      // creation of ok-button
      JButton ok = new JButton ("OK");
      ok.setSize (100, 30);
      ok.addActionListener (new PEThrowsOKActionListener (this));
      buttonPanel.add (ok);

      // creation of cancel-button
      JButton cancel = new JButton ("Cancel");
      cancel.setSize (100, 30);
      cancel.addActionListener (new PEThrowsCancelActionListener (this));
      buttonPanel.add (cancel);

      // the default button
      getRootPane().setDefaultButton (ok);

      // return the buttons
      return buttonPanel;
   } // createButtonPanel


   /**
    * UMLMethod : '+ okPressed () : void
    */
   public void okPressed()
   {
      setVisible (false);
      if (myTypes != null)
      {
         getMethod().removeAllFromThrowsTypes();
         Object[] listElements = myTypes.getSelectedValues();
         for (int i = 0; i < listElements.length; i++)
         {
            getMethod().addToThrowsTypes ((UMLType) listElements[i]);
         }
      }
   } // okPressed


   /**
    * UMLMethod : '+ cancelPressed () : void
    */
   public void cancelPressed()
   {
      setVisible (false);
   } // cancelPressed


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void centerDialog()
   {
      Dimension screenSize = this.getToolkit().getScreenSize();
      Dimension size = this.getSize();

      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;

      this.setLocation (x, y);
   }

} // PEThrowsDialog


/**
 * Listener for the cancel-button
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12.2.2 $
 */
class PEThrowsCancelActionListener implements ActionListener
{


   /**
    * UMLMethod : ' PEThrowsCancelActionListener (PEThrowsDialog) : Constructor
    *
    * @param tmpDia  No description provided
    */
   PEThrowsCancelActionListener (PEThrowsDialog tmpDia)
   {
      this.tmpDia = tmpDia;
   } // constructor


   /**
    * UMLAttribute: ' PEThrowsDialog : tmpDia'
    */
   PEThrowsDialog tmpDia;


   /**
    * UMLMethod : '+ actionPerformed (ActionEvent) : void
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      // cancel pressed
      tmpDia.cancelPressed();
   } // actionPerformed

} // CancelActionListener


/**
 * Listener for the ok-button
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12.2.2 $
 */
class PEThrowsOKActionListener implements ActionListener
{


   /**
    * UMLMethod : ' PEThrowsOKActionListener (PEThrowsDialog) : Constructor
    *
    * @param tmpDia  No description provided
    */
   PEThrowsOKActionListener (PEThrowsDialog tmpDia)
   {
      this.tmpDia = tmpDia;
   } // constructor


   /**
    * UMLAttribute: ' PEThrowsDialog : tmpDia'
    */
   PEThrowsDialog tmpDia;


   /**
    * UMLMethod : '+ actionPerformed (ActionEvent) : void
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      // ok pressed
      tmpDia.okPressed();
   } // actionPerformed

}

/*
 * $Log: PEThrowsDialog.java,v $
 * Revision 1.12.2.2  2005/08/23 08:24:40  lowende
 * Removed compile warnings.
 *
 */
