/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

/*
 *  The FUJABA ToolSuite project:
 *
 *  FUJABA is the acronym for 'From Uml to Java And Back Again'
 *  and originally aims to provide an environment for round-trip
 *  engineering using UML as visual programming language. During
 *  the last years, the environment has become a base for several
 *  research activities, e.g. distributed software, database
 *  systems, modelling mechanical and electrical systems and
 *  their simulation. Thus, the environment has become a project,
 *  where this source code is part of. Further details are avail-
 *  able via http://www.fujaba.de
 *
 *  Copyright (C) 1997-2004 Fujaba Development Group
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA 02111-1307, USA or download the license under
 *  http://www.gnu.org/copyleft/lesser.html
 *
 *  WARRANTY:
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  Contact adress:
 *
 *  Fujaba Management Board
 *  Software Engineering Group
 *  University of Paderborn
 *  Warburgerstr. 100
 *  D-33098 Paderborn
 *  Germany
 *
 *  URL  : http://www.fujaba.de
 *  email: info@fujaba.de
 *
 */
import javax.swing.*;


/**
 * KeyListener for the EditPathExprDialog which en- or deables the ok-button by checking whether
 * the path expression is valid or not.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.4 $
 */
public class PathExpressionKeyListener implements KeyListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField pathExpressionTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   String pathExpression;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   EditPathExprDialog editPathExprDialog;


   /**
    * FIXME: rubbish?!
    *
    * @param editPathExprDialog  No description provided
    */
   //UMLClass targetClass;


   /**
    * Constructor for class PathExpressionKeyListener
    *
    * @param editPathExprDialog  No description provided
    */
   public PathExpressionKeyListener (EditPathExprDialog editPathExprDialog)
   {
      this.editPathExprDialog = editPathExprDialog;
   }

   // Checks the current expression's validity and controls ok-button
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param keyEvent  No description provided
    */
   public void keyReleased (KeyEvent keyEvent)
   {
      pathExpressionTextField = (JTextField) keyEvent.getSource();
      pathExpression = pathExpressionTextField.getText();

      /*
       *  FIXME:
       *  targetClass = editPathExprDialog.getTargetClass (pathExpression);
       *  if (targetClass == null)
       *  {
       *  editPathExprDialog.getOkButton().setEnabled (false);
       *  }
       *  else
       *  {
       *  editPathExprDialog.getOkButton().setEnabled (true);
       *  }
       */
      editPathExprDialog.getOkButton().setEnabled (true);

   }

   // not needed
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param keyEvent  No description provided
    */
   public void keyPressed (KeyEvent keyEvent)
   {
   }

   // not needed
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param keyEvent  No description provided
    */
   public void keyTyped (KeyEvent keyEvent)
   {
   }
}

/*
 * $Log: PathExpressionKeyListener.java,v $
 * Revision 1.4  2004/10/20 17:49:55  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
