/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLClass;


/**
 * Abstract class to implements a PropertyEditor.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.72 $
 */
public abstract class PropertyEditor extends BasicPropertyEditor
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLClass umlClass = null;


   /**
    * Constructor for class PropertyEditor
    *
    * @param frame  No description provided
    */
   public PropertyEditor (JFrame frame)
   {
      super (frame);
      setTitle ("Property Editor");
   }


   /**
    * Create an PropertyEditor with an Dialog as owner So the new PE lies always upon its owner
    *
    * @param dialog  The dialog (PE) which owns this PE
    */
   public PropertyEditor (Dialog dialog)
   {
      super (dialog);
      setTitle ("Property Editor");
   } // PropertyEditor


   /**
    * This functions sets the context to the AST see also getAsgElement () and getClassIncrement
    * ()
    *
    * @param incr  The new increment value
    */
   public void setIncrement (ASGElement incr)
   {
      if (getFrame() != null)
      {
         getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      } // if

      asgElement = incr;
      readOnly = false;
      if (incr instanceof UMLClass)
      {
         umlClass = (UMLClass) incr;
         if (umlClass != null)
         {
            //setReadOnly (umlClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes(UMLStereotypeManager.REFERENCE)));
         }
      }
      unparse();
      if (getFrame() != null)
      {
         getFrame().setCursor (Cursor.getPredefinedCursor (Cursor.DEFAULT_CURSOR));
      } // if
   }


   /**
    * getClassIncrement returns a valid reference to an UMLClass object if a class Object is
    * referenced by setAsgElement
    *
    * @return   valid reference of a class Object
    */
   public UMLClass getClassIncrement()
   {
      return umlClass;
   }
}

/*
 * $Log: PropertyEditor.java,v $
 * Revision 1.72  2004/11/03 10:18:05  lowende
 * Javadoc warnings removed.
 *
 */
