/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FDiagram;
import de.uni_paderborn.fujaba.packagediagrams.DiagramUsage;
import de.uni_paderborn.fujaba.packagediagrams.PackageDiagram;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * @author    $Author: creckord $
 * @version   $Revision: 1.66.2.4 $
 */
public class SDMObjectDialog extends AbstractDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement umlIncrement;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox objectNameCombo;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox typeComboBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JCheckBox boundCheckBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JCheckBox typeCastCheckBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton negativeRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox assertCheckBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox typeCastComboBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton noConstraintRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton optionalRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton setRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton noneRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton destroyRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton createRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ViewDiagram viewDiag = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton browseButton;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton defaultButton;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField currentIcon;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLStoryPattern storyPattern;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector objectNames;


   /**
    * Constructor for class SDMObjectDialog
    *
    * @param frame         No description provided
    * @param umlIncrement  No description provided
    */
   public SDMObjectDialog (JFrame frame, ASGElement umlIncrement)
   {
      super (frame, false);

      this.umlIncrement = umlIncrement;

      createUserInterface();
      initialize();
   } // constructor


   /**
    * Constructor for class SDMObjectDialog
    *
    * @param frame         No description provided
    * @param umlIncrement  No description provided
    * @param viewDiag      No description provided
    */
   public SDMObjectDialog (JFrame frame, ASGElement umlIncrement, ViewDiagram viewDiag)
   {
      this (frame, umlIncrement);
      this.viewDiag = viewDiag;
   } // constructor


   /**
    * Contains the complete user interface of the dialog, except "Ok" and "Cancel" buttons.
    * Called by createUserInterface ().
    *
    * @return   JPanel that is positioned in the middle of the dialog.
    * @see      de.uni_paderborn.fujaba.gui.AbstractDialog#createUserInterface
    */
   protected JPanel createMainPanel()
   {
      GridBagLayout gridBag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setLayout (new BoxLayout (panel, BoxLayout.X_AXIS));

      JPanel leftPanel = new JPanel();
      leftPanel.setBorder (new TitledBorder ("Object"));
      leftPanel.setLayout (gridBag);

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.weightx = 1.0;

      JLabel objectNameLabel = new JLabel ("Name");
      constraints.insets = new Insets (3, 3, 0, 3);
      gridBag.setConstraints (objectNameLabel, constraints);
      leftPanel.add (objectNameLabel);

      objectNames = new Vector();
      objectNameCombo = new JComboBox (objectNames);
      objectNameCombo.setEditable (true);
      objectNameCombo.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               final String objectName = (String) objectNameCombo.getSelectedItem();
               final UMLClass type = (UMLClass) getObjectMap().get (objectName);
               if (type != null)
               {
                  typeComboBox.setSelectedItem (type);
               }
               boundCheckBox.setSelected (shouldObjectBeBound (objectName));
            }
         });
      enableCompletion (objectNameCombo);
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (objectNameCombo, constraints);
      leftPanel.add (objectNameCombo);

      JLabel objectTypeLabel = new JLabel ("Type");
      constraints.insets = new Insets (8, 3, 0, 3);
      gridBag.setConstraints (objectTypeLabel, constraints);
      leftPanel.add (objectTypeLabel);

      typeComboBox = new JComboBox();
      typeComboBox.setEditable (true);
      enableCompletion (typeComboBox);
      typeComboBox.setRenderer (new TypeListRenderer());
      //todo: provide completion mechanism here
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (typeComboBox, constraints);
      leftPanel.add (typeComboBox);

      JLabel typeCastLabel = new JLabel ("Direct Assignment");
      constraints.insets = new Insets (8, 3, 0, 3);
      gridBag.setConstraints (typeCastLabel, constraints);
      leftPanel.add (typeCastLabel, constraints);

      typeCastCheckBox = new JCheckBox ("Type cast");
      typeCastCheckBox.addActionListener (new TypeCastCheckBoxListener());
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (typeCastCheckBox, constraints);
      leftPanel.add (typeCastCheckBox);

      typeCastComboBox = new JComboBox (objectNames);
      typeCastComboBox.setEditable (true);
      enableCompletion (typeCastComboBox);
      gridBag.setConstraints (typeCastComboBox, constraints);
      leftPanel.add (typeCastComboBox);

      JLabel boundLabel = new JLabel ("State");
      constraints.insets = new Insets (8, 3, 0, 3);
      gridBag.setConstraints (boundLabel, constraints);
      leftPanel.add (boundLabel);

      boundCheckBox = new JCheckBox ("Bound");
      boundCheckBox.setMnemonic ('b');
      constraints.insets = new Insets (0, 3, 3, 3);
      gridBag.setConstraints (boundCheckBox, constraints);
      leftPanel.add (boundCheckBox);

      panel.add (leftPanel);

      JPanel rightPanel = new JPanel();
      rightPanel.setLayout (gridBag);
      rightPanel.setBorder (new TitledBorder ("Properties"));

      ButtonGroup constraintButtonGroup = new ButtonGroup();
      TypeModifierListener tmListener = new TypeModifierListener();

      JLabel constraintLabel = new JLabel ("Constraint");
      constraints.insets = new Insets (3, 3, 0, 3);
      gridBag.setConstraints (constraintLabel, constraints);
      rightPanel.add (constraintLabel);

      noConstraintRadioButton = new JRadioButton ("None");
      constraints.insets = new Insets (0, 9, 0, 3);
      gridBag.setConstraints (noConstraintRadioButton, constraints);
      constraintButtonGroup.add (noConstraintRadioButton);
      noConstraintRadioButton.addActionListener (tmListener);
      rightPanel.add (noConstraintRadioButton);

      negativeRadioButton = new JRadioButton ("Negative");
      negativeRadioButton.setMnemonic ('n');
      gridBag.setConstraints (negativeRadioButton, constraints);
      constraintButtonGroup.add (negativeRadioButton);
      negativeRadioButton.addActionListener (tmListener);
      rightPanel.add (negativeRadioButton);

      optionalRadioButton = new JRadioButton ("Optional");
      negativeRadioButton.setMnemonic ('o');
      gridBag.setConstraints (optionalRadioButton, constraints);
      constraintButtonGroup.add (optionalRadioButton);
      optionalRadioButton.addActionListener (tmListener);
      rightPanel.add (optionalRadioButton);

      setRadioButton = new JRadioButton ("Set");
      negativeRadioButton.setMnemonic ('s');
      gridBag.setConstraints (setRadioButton, constraints);
      constraintButtonGroup.add (setRadioButton);
      setRadioButton.addActionListener (tmListener);
      rightPanel.add (setRadioButton);

      assertCheckBox = new JCheckBox ("Assert");
      negativeRadioButton.setMnemonic ('a');
      gridBag.setConstraints (assertCheckBox, constraints);
      rightPanel.add (assertCheckBox);

      ButtonGroup modifierButtonGroup = new ButtonGroup();

      JLabel modifierLabel = new JLabel ("Modifier");
      constraints.insets = new Insets (8, 3, 0, 3);
      gridBag.setConstraints (modifierLabel, constraints);
      rightPanel.add (modifierLabel);

      noneRadioButton = new JRadioButton ("None");
      constraints.insets = new Insets (0, 9, 0, 3);
      gridBag.setConstraints (noneRadioButton, constraints);
      modifierButtonGroup.add (noneRadioButton);
      noneRadioButton.addActionListener (tmListener);
      rightPanel.add (noneRadioButton);

      createRadioButton = new JRadioButton ("Create");
      negativeRadioButton.setMnemonic ('c');
      gridBag.setConstraints (createRadioButton, constraints);
      modifierButtonGroup.add (createRadioButton);
      createRadioButton.addActionListener (tmListener);
      rightPanel.add (createRadioButton);

      destroyRadioButton = new JRadioButton ("Destroy");
      negativeRadioButton.setMnemonic ('d');
      gridBag.setConstraints (destroyRadioButton, constraints);
      modifierButtonGroup.add (destroyRadioButton);
      destroyRadioButton.addActionListener (tmListener);
      rightPanel.add (destroyRadioButton);

      // ##################################################################

      JLabel iconLabel = new JLabel ("Current Icon");
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (iconLabel, constraints);
      leftPanel.add (iconLabel);

      currentIcon = new JTextField();
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (currentIcon, constraints);
      leftPanel.add (currentIcon);

      JPanel buttonPanel = new JPanel();
      browseButton = new JButton ("Browse...");
      browseButton.addActionListener (createBrowseListener());
      defaultButton = new JButton ("Default");
      defaultButton.addActionListener (createDefaultListener());
      buttonPanel.add (browseButton);
      buttonPanel.add (defaultButton);
      leftPanel.add (buttonPanel);

      panel.add (rightPanel);

      return panel;
   } // createMainPanel


   /**
    * Map from objectName (String) to objectClass (UMLClass)
    */
   private Map objectMap;


   /**
    * Map from objectName (String) to objectClass (UMLClass)
    *
    * @return   The objectMap value
    */
   Map getObjectMap()
   {
      if (objectMap == null)
      {
         objectMap = new TreeMap();
         final UMLDiagram firstFromDiagrams = storyPattern.getRevStoryPattern().getFirstFromDiagrams();
         if (firstFromDiagrams instanceof UMLActivityDiagram)
         {
            final UMLActivityDiagram activityDiagram = (UMLActivityDiagram) firstFromDiagrams;
            for (Iterator it = activityDiagram.iteratorOfObjects(); it.hasNext(); )
            {
               UMLObject object = (UMLObject) it.next();
               objectMap.put (object.getObjectName(), object.getInstanceOf());
            }
            UMLMethod method = activityDiagram.getStartActivity() != null ? activityDiagram.getStartActivity().getSpec() : null;
            if (method != null)
            {
               objectMap.put ("this", method.getParent());
               for (Iterator it = method.iteratorOfParam(); it.hasNext(); )
               {
                  UMLParam param = (UMLParam) it.next();
                  if (param.getParamType() instanceof UMLClass)
                  {
                     objectMap.put (param.getName(), param.getParamType());
                  }
               }
            }
         }
      }
      return objectMap;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comboBox  No description provided
    */
   public static void enableCompletion (final JComboBox comboBox)
   {
      Component editorComponent = comboBox.getEditor().getEditorComponent();
      if (editorComponent instanceof JTextField)
      {
         final JTextField textField = (JTextField) editorComponent;
         final Document document = textField.getDocument();
         document.addDocumentListener (
            new DocumentListener()
            {
               public void changedUpdate (DocumentEvent e)
               {
                  SwingUtilities.invokeLater (
                     new Runnable()
                     {
                        public void run()
                        {
                           try
                           {
                              String text = document.getText (0, document.getLength());
                              int shortest = Integer.MAX_VALUE;
                              String shortestMatchingItem = null;
                              int shortestMatchingIndex = -1;
                              for (int i = 0; i < comboBox.getItemCount(); i++)
                              {
                                 String item = "" + comboBox.getItemAt (i);
                                 if (item.length() < shortest)
                                 {
                                    if (item.startsWith (text))
                                    {
                                       shortestMatchingItem = item;
                                       shortestMatchingIndex = i;
                                       shortest = item.length();
                                    }
                                 }
                              }
                              if (shortestMatchingItem != null && !text.equals (shortestMatchingItem))
                              {
                                 textField.setText (shortestMatchingItem);
                                 comboBox.setSelectedIndex (shortestMatchingIndex);
                                 textField.setCaretPosition (text.length());
                                 textField.moveCaretPosition (shortestMatchingItem.length());
                              }

                           }
                           catch (BadLocationException e1)
                           {
                           }
                        }
                     });
               }


               public void insertUpdate (DocumentEvent e)
               {
                  changedUpdate (e);
               }


               public void removeUpdate (DocumentEvent e)
               {

               }
            });
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @return            No description provided
    */
   protected boolean shouldObjectBeBound (String objectName)
   {
      if (getObject() != null)
      {
         return getObject().isBound();
      }
      if ("this".equals (objectName))
      {
         return true;
      }

      if (getObjectMap().containsKey (objectName))
      {
         final UMLDiagram firstFromDiagrams = storyPattern.getRevStoryPattern().getFirstFromDiagrams();
         if (firstFromDiagrams instanceof UMLActivityDiagram)
         {
            final UMLActivityDiagram activityDiagram = (UMLActivityDiagram) firstFromDiagrams;
            if (activityDiagram.getStartActivity() != null)
            {
               UMLMethod myMethod = activityDiagram.getStartActivity().getSpec();
               if (myMethod != null)
               {
                  Iterator params = myMethod.iteratorOfParam();
                  while (params.hasNext())
                  {
                     UMLParam param = (UMLParam) params.next();
                     if (param.getName().equals (objectName) && param.getParamType() instanceof UMLClass)
                     {
                        return true;
                     }
                  }
               }
            }
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private ActionListener createBrowseListener()
   {
      ActionListener listener =
         new ActionListener()
         {
            public void actionPerformed (ActionEvent event)
            {
               browse();
            }
         };
      return listener;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private ActionListener createDefaultListener()
   {
      ActionListener listener =
         new ActionListener()
         {
            public void actionPerformed (ActionEvent event)
            {
               currentIcon.setText (object.getInstanceOf().getDefaultIcon());
            }
         };
      return listener;
   }


   /**
    * Opens a JFileChooser so you can browse to get your favourite directory.
    */
   void browse()
   {
      JFileChooser jf = new JFileChooser (".");
      // jf.setFileSelectionMode (JFileChooser.DIRECTORIES_ONLY);
      int opt = jf.showDialog (this, "Choose an icon");

      if (opt == JFileChooser.APPROVE_OPTION)
      {
         currentIcon.setText (jf.getSelectedFile().getPath());
      }
   }


   /**
    * Read the parameters which can be modified and put all information into the dialogs user
    * interface. Called by initialize ().
    *
    * @see   de.uni_paderborn.fujaba.gui.AbstractDialog#initialize
    */
   protected void unparse()
   {
      fillTypeComboBox();

      if (umlIncrement instanceof UMLObject)
      {
         object = (UMLObject) umlIncrement;
         storyPattern = (UMLStoryPattern) object.getFirstFromDiagrams();

         objectNameCombo.getEditor().setItem (object.getObjectName());
         typeComboBox.setSelectedItem (object.getInstanceOf());

         if (object.isCheckTypeCast())
         {
            typeCastCheckBox.setSelected (true);
         }
         else
         {
            typeCastCheckBox.setSelected (false);
         }
         typeCastComboBox.setSelectedItem (object.getTypeCastSource());

         boundCheckBox.setSelected (object.isBound());

         switch (object.getType())
         {
            case UMLObject.NORM:
               noConstraintRadioButton.setSelected (true);
               break;
            case UMLObject.NEGATIVE:
               negativeRadioButton.setSelected (true);
               break;
            case UMLObject.OPTIONAL:
               optionalRadioButton.setSelected (true);
               break;
            case UMLObject.SET:
               setRadioButton.setSelected (true);
               break;
         }

         assertCheckBox.setSelected (object.isAssertInUnitTest());

         switch (object.getModifier())
         {
            case UMLObject.NONE:
               noneRadioButton.setSelected (true);
               break;
            case UMLObject.CREATE:
               createRadioButton.setSelected (true);
               break;
            case UMLObject.DELETE:
               destroyRadioButton.setSelected (true);
               break;
         }

         enableRadioButtons();
         getOkButton().setText ("Apply");
         setTitle ("Edit Object");
         currentIcon.setText (object.getCurrentIcon());
      }
      else
      {
         if (umlIncrement instanceof UMLStoryActivity)
         {
            storyPattern =  ((UMLStoryActivity) umlIncrement).getStoryPattern();
         }
         else
         {
            storyPattern = (UMLStoryPattern) umlIncrement;
         }

         typeCastCheckBox.setSelected (false);
         typeCastComboBox.setSelectedItem (null);
         //typeCastComboBox.setEnabled (false);
         boundCheckBox.setSelected (false);
         assertCheckBox.setSelected (false);
         noConstraintRadioButton.setSelected (true);
         noneRadioButton.setSelected (true);

         setTitle ("New Object");
      }
      updateObjectNames();
   } // unparse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void fillTypeComboBox()
   {
      Iterator iter = UMLProject.get().getTypeList().sortedIteratorOfTypes();
      while (iter.hasNext())
      {
         UMLType type = (UMLType) iter.next();
         if (type instanceof UMLClass)
         {
            typeComboBox.addItem (type);
         } // if
      } // while
   } // fillTypeComboBox


   /**
    * Get all information from the user interface and put them back to the parameters that
    * can be modified by this dialog. Called by okPressed ().
    *
    * @see   de.uni_paderborn.fujaba.gui.AbstractDialog#okPressed
    */
   protected void parse()
   {
      if (umlIncrement instanceof UMLObject)
      {
         UMLObject obj = (UMLObject) umlIncrement;
         writeAttributesToUMLObject (obj);
         obj.setCurrentIcon (currentIcon.getText());
      }
      else if (umlIncrement instanceof UMLStoryActivity
         || umlIncrement instanceof UMLStoryPattern)
      {
         if (storyPattern != null)
         {
            object = new UMLObject();
            writeAttributesToUMLObject (object);

            storyPattern.addToElements (object);
            if (viewDiag != null)
            {
               // Fix Me selction Dialog for ViewDefinitions needed
               Iterator viewDefIter = viewDiag.iteratorOfViewDefinitions();
               if (viewDefIter.hasNext())
               {
                  ViewDefinition viewDefinition = (ViewDefinition) viewDefIter.next();
                  viewDefinition.addToItems (object, storyPattern);
                  viewDefinition.addToStartItems (object);
               }

               viewDiag.update();
            }
         }
      }

      UMLProject.get().refreshDisplay();
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void updateObjectNames()
   {
      objectMap = null;
      objectNames.clear();
      objectNames.addAll (getObjectMap().keySet());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param object  No description provided
    */
   private void writeAttributesToUMLObject (UMLObject object)
   {
      object.setObjectName ((String) objectNameCombo.getSelectedItem());

      Object usertype = typeComboBox.getSelectedItem();
      UMLClass type = null;

      if (usertype instanceof UMLClass)
      {
         type = (UMLClass) usertype;
      }
      else if (usertype instanceof String && ! ((String) usertype).trim().equals (""))
      {
         // try to retrieve class and add it to the first available class diagram
         String userClassName = (String) usertype;
         Pattern bracketExpr = Pattern.compile ("^(.+?)\\s*\\((.*)\\)\\s*$");
         Matcher matcher = bracketExpr.matcher (userClassName);
         if (matcher.find())
         {
            String prefix = matcher.group (2).trim();
            if (!"".equals (prefix))
            {
               userClassName = matcher.group (2) + "." + matcher.group (1);
            }
            else
            {
               userClassName = matcher.group (1);
            }
         }
         {
            userClassName = userClassName.trim();
            if (!userClassName.equals (""))
            {
               type = UMLProject.get().findClass (null, userClassName, false);
               if (type == null && "".equals (UMLProject.getPackageOfFullQualifiedType (userClassName)))
               {
                  Iterator typeIter = UMLProject.get().getTypeList().iteratorOfTypes();
                  while (typeIter.hasNext() && type == null)
                  {
                     UMLType tmpType = (UMLType) typeIter.next();
                     if (tmpType instanceof UMLClass && tmpType.getName().equals (userClassName))
                     {
                        type = (UMLClass) tmpType;
                     }
                  }
                  if (type != null)
                  {
                     String[] options = {"Use this", "Create new"};
                     String message = "A class with name \"" + userClassName + "\" was found in ";
                     if (type.getDeclaredInPackage() != null)
                     {
                        message += "package " + type.getDeclaredInPackage().getFullPackageName();
                     }
                     else if (type.getDeclaredInClass() != null)
                     {
                        message += "class " + type.getDeclaredInClass().getFullClassName();
                     }
                     else
                     {
                        message += "a mysterious place";
                     }
                     message += ".\n\nDo you want to use that class or create a new one in the root package?";

                     int answer = JOptionPane.showOptionDialog (this, message,
                        "Existing class found", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE,
                        null, options, options[0]);
                     if (answer == JOptionPane.NO_OPTION)
                     {
                        type = null;
                     }
                  }
               }
               if (type == null)
               {
                  type = UMLProject.get().getOrNewClass (userClassName);

                  // add to first class diagram you find
                  Iterator iter = UMLProject.get().iteratorOfDiags();
                  boolean done = false;
                  while (iter.hasNext())
                  {
                     Object obj = iter.next();
                     if (obj instanceof UMLClassDiagram)
                     {
                        UMLClassDiagram myDiag = (UMLClassDiagram) obj;
                        myDiag.addToElements (type);
                        done = true;
                        break;
                     }
                  }
                  if (!done)
                  {
                     // there is no class diagram yet. Add one
                     UMLClassDiagram newDiag = new UMLClassDiagram ("Main", UMLProject.get());
                     newDiag.addToElements (type);

                     // if there is a design package diagram, add the new class diagram to it.
                     FDiagram designDiag = UMLProject.get().getFromDiags ("Design");
                     if (designDiag instanceof PackageDiagram)
                     {
                        PackageDiagram packageDiag = (PackageDiagram) designDiag;
                        DiagramUsage usage = new DiagramUsage();
                        usage.setDiagram (newDiag);
                        packageDiag.addToElements (usage);
                     }
                  }
               }
            }
         }
      }

      if (type != null)
      {
         object.setInstanceOf (type);
      }

      object.setCheckTypeCast (typeCastCheckBox.isSelected());

      object.setTypeCastSource ((String) typeCastComboBox.getSelectedItem());
      boolean isAssignment = object.getTypeCastSource() != null && !"".equals (object.getTypeCastSource());

      object.setBound (isAssignment || boundCheckBox.isSelected());

      object.setAssertInUnitTest (assertCheckBox.isSelected());

      if (negativeRadioButton.isSelected())
      {
         object.setType (UMLObject.NEGATIVE);
      }
      else if (optionalRadioButton.isSelected())
      {
         object.setType (UMLObject.OPTIONAL);
      }
      else if (setRadioButton.isSelected())
      {
         object.setType (UMLObject.SET);
      }
      else
      {
         object.setType (UMLObject.NORM);
      }

      if (createRadioButton.isSelected())
      {
         object.setModifier (UMLObject.CREATE);
      }
      else if (destroyRadioButton.isSelected())
      {
         object.setModifier (UMLObject.DELETE);
      }
      else
      {
         object.setModifier (UMLObject.NONE);
      }

      object.setCurrentIcon (currentIcon.getText());
   } // writeAttributesToUMLObject


   /**
    * Get the storyActivity attribute of the SDMObjectDialog object
    *
    * @return   The storyActivity value
    */
   protected UMLStoryActivity getStoryActivity()
   {
      ASGElement incr = umlIncrement;
      if (incr instanceof UMLObject)
      {
         incr =  ((UMLObject) incr).getFirstFromDiagrams();
      }
      if (incr instanceof UMLStoryPattern)
      {
         incr =  ((UMLStoryPattern) incr).getRevStoryPattern();
      }
      if (incr instanceof UMLStoryActivity)
      {
         return (UMLStoryActivity) incr;
      }
      return null;
   }


   /**
    * Put all constraint checks that have to be verified before leaving the dialog into this
    * method.
    *
    * @return   true, if all constraints are fulfilled.
    */
   protected boolean checkConstraints()
   {
      boolean result = true;

      if ( ((String) objectNameCombo.getSelectedItem()).trim().length() == 0)
      {
         result = false;
         JOptionPane.showMessageDialog (this, "Please specify a name for the object!",
            "Object has no name", JOptionPane.ERROR_MESSAGE);
      }

      return result;
   } // checkConstraints


   /**
    * Enables radio buttons such that only the following valid combinations of modifier and
    * type can be set (X=valid/O=invalid): <pre>
    * modifier\type  |  normal  |  optional  |  negative  |  set
    * -------------------------------------------------------------
    * none           |    X     |      X     |      X     |   X
    * -------------------------------------------------------------
    * create         |    X     |      X     |      O     |   O
    * -------------------------------------------------------------
    * delete         |    X     |      X     |      O     |   X
    * </pre>
    */
   public void enableRadioButtons()
   {
      if (noConstraintRadioButton.isSelected())
      {
         createRadioButton.setEnabled (true);
         destroyRadioButton.setEnabled (true);
         negativeRadioButton.setEnabled (true);
      }
      else if (negativeRadioButton.isSelected())
      {
         createRadioButton.setEnabled (false);
         destroyRadioButton.setEnabled (false);
      }
      else if (setRadioButton.isSelected())
      {
         createRadioButton.setEnabled (false);
         destroyRadioButton.setEnabled (true);
      }
      else if (optionalRadioButton.isSelected())
      {
         createRadioButton.setEnabled (true);
         destroyRadioButton.setEnabled (true);
      }

      if (noneRadioButton.isSelected())
      {
         negativeRadioButton.setEnabled (true);
         optionalRadioButton.setEnabled (true);
         setRadioButton.setEnabled (true);
      }
      else if (createRadioButton.isSelected())
      {
         negativeRadioButton.setEnabled (false);
         optionalRadioButton.setEnabled (true);
         setRadioButton.setEnabled (false);
      }
      else if (destroyRadioButton.isSelected())
      {
         negativeRadioButton.setEnabled (false);
         optionalRadioButton.setEnabled (true);
         setRadioButton.setEnabled (true);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   UMLObject object = null;


   /**
    * Get the object attribute of the SDMObjectDialog object
    *
    * @return   The object value
    */
   public UMLObject getObject()
   {
      return object;
   } // getObject


   /**
    * Sets the object attribute of the SDMObjectDialog object
    *
    * @param object  The new object value
    */
   public void setObject (UMLObject object)
   {
      if (this.object != object)
      {
         this.object = object;
      } // if
   } // setObject

   // ================================= inner classes ========================================

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.66.2.4 $ $Date: 2006/02/16 09:23:41 $
    */
   private class TypeModifierListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         enableRadioButtons();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.66.2.4 $
    */
   private class TypeCastCheckBoxListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private boolean oldBoundCheckBoxValue;


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         if (typeCastCheckBox.isSelected())
         {
            oldBoundCheckBoxValue = boundCheckBox.isSelected();
            boundCheckBox.setSelected (true);
            boundCheckBox.setEnabled (false);
         }
         else
         {
            typeCastComboBox.setSelectedItem ("");
            boundCheckBox.setSelected (oldBoundCheckBoxValue);
            boundCheckBox.setEnabled (true);
         }
      } // actionPerformed

   } // TypeCastCheckBoxListener


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.66.2.4 $ $Date: 2006/02/16 09:23:41 $
    */
   private static class TypeListRenderer extends DefaultListCellRenderer
   {

      /*
       *  (non-Javadoc)
       *  @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
       */
      /**
       * Get the listCellRendererComponent attribute of the TypeListRenderer object
       *
       * @param arg0  No description provided
       * @param arg1  No description provided
       * @param arg2  No description provided
       * @param arg3  No description provided
       * @param arg4  No description provided
       * @return      The listCellRendererComponent value
       */
      public Component getListCellRendererComponent (JList arg0, Object arg1,
                                                     int arg2, boolean arg3,
                                                     boolean arg4)
      {
         UMLClass umlClass = (UMLClass) arg1;
         String text = umlClass.getName();
         if (umlClass.getDeclaredInClass() != null)
         {
            text += " (" + umlClass.getDeclaredInClass().getFullClassName() + ")";
         }
         else if (umlClass.getDeclaredInPackage() != null &&
            UMLProject.get().getRootPackage() != umlClass.getDeclaredInPackage())
         {
            text += " (" + umlClass.getDeclaredInPackage().getFullPackageName() + ")";
         }
         return super.getListCellRendererComponent (arg0, text, arg2, arg3, arg4);
      }
   }
}

/*
 * $Log: SDMObjectDialog.java,v $
 * Revision 1.66.2.4  2006/02/16 09:23:41  creckord
 * Optional Create enabled in GUI and Unparser
 *
 */
