/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Collection;
import java.util.Vector;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ListUI;



/**
 * A dialog showing some items. It will pop down when the user selects one either by doubleclicking
 * on it or by selecting it and clicking Ok. getSelectedObject() will then, surprise, return
 * the selected object.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class SelectFromListDialog extends AbstractDialog
{
   /**
    * Constructor for class SelectFromListDialog
    *
    * @param frame  No description provided
    */
   public SelectFromListDialog (JFrame frame)
   {
      super (frame, true);
      this.selectedObject = null;
      createUserInterface();
      initialize();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Collection objects;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JList objectList; // GUI-item showing the objects

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Object selectedObject; // the selected object (maybe null)

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JLabel heading;


   /**
    * Sets the heading attribute of the SelectFromListDialog object
    *
    * @param heading  The new heading value
    */
   public void setHeading (String heading)
   {
      this.heading.setText (heading);
   }


   /**
    * Sets the objects attribute of the SelectFromListDialog object
    *
    * @param objects  The new objects value
    */
   public void setObjects (Collection objects)
   {
      this.objects = objects;

      if (objects != null)
      {
         Vector objectsVector = new Vector (objects);
         objectList.setListData (objectsVector);
      }
   }


   /**
    * Get the selectedObject attribute of the SelectFromListDialog object
    *
    * @return   The selectedObject value
    */
   public Object getSelectedObject()
   {
      return selectedObject;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JPanel createMainPanel()
   {
      JPanel panel = new JPanel();
      panel.setLayout (new BorderLayout());
      panel.setBorder (new EmptyBorder (8, 8, 8, 8));

      heading = new JLabel();
      panel.add (heading, BorderLayout.NORTH);

      // scrollable JList to display the objects
      objectList = new JList();
      objectList.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
      objectList.addMouseListener (new DoubleClickListener());
      JScrollPane scrollPane = new JScrollPane (objectList);
      panel.add (scrollPane, BorderLayout.CENTER);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void unparse()
   {
      // empty
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      // called on Ok, so save selected object
      selectedObject = objectList.getSelectedValue();
   }


   /**
    * Convenience class so the user can doubleclick on an object to select it.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.12 $
    */
   private class DoubleClickListener extends MouseAdapter
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e)
      {
         // only accept a double click with button 1 (the leftmost one)
         // on a list-item
         if ( ( (e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) && e.getClickCount() == 2)
         {
            ListUI ui = objectList.getUI();
            boolean clickedAnItem
                = ui.locationToIndex (objectList, e.getPoint()) != -1;
            if (objectList.getSelectedValue() != null && clickedAnItem)
            {
               okPressed();
            }
         }
      }
   }
}

/*
 * $Log: SelectFromListDialog.java,v $
 * Revision 1.12  2004/11/03 10:18:05  lowende
 * Javadoc warnings removed.
 *
 */
