/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

import javax.swing.*;

import de.uni_paderborn.fujaba.texteditor.TextEditor;


/**
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.4 $ $Date: 2004/11/03 10:18:06 $
 */
public class TextEditAction implements ActionListener, TextEditor.BufferOwner
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.4 $ $Date: 2004/11/03 10:18:06 $
    */
   public interface ClosableDialog
   {
      /**
       * called when sourceEditor content is shown in the TextEditor
       */
      void hideWhileEditing();


      /**
       * called when the user wants to save the content of the TextEditor
       */
      void okPressed();
   }


   /**
    * where to get the text
    */
   JTextArea sourceEditor;

   /**
    * where to put the text for the editor
    */
   TextEditor.Buffer sourceBuffer;

   /**
    * dialog to be closed after editing
    */
   ClosableDialog dialog;


   /**
    * create a TextEditAction that will edit the text found in the sourceEditor
    *
    * @param dialog        which dialog to attach (closed upon edit)
    * @param sourceEditor  what to edit
    */
   public TextEditAction (ClosableDialog dialog, JTextArea sourceEditor)
   {
      this.sourceEditor = sourceEditor;
      setDialog (dialog);
   }


   /**
    * @param e  event that caused the action to be invoked
    */
   public void actionPerformed (ActionEvent e)
   {
      boolean lastWasDelimiter = false;

      String text = sourceEditor.getText();
      if (dialog != null)
      {
         dialog.hideWhileEditing();
      }

      sourceBuffer = TextEditor.get().createBuffer (this);
      sourceBuffer.setSyntaxHighlightingEnabled (false);

      if (text != null)
      {
         StringTokenizer tokenizer = new StringTokenizer (text, "\n", true);
         while (tokenizer.hasMoreElements())
         {
            String temp = (String) tokenizer.nextElement();
            if (temp.equals ("\n"))
            {
               if (lastWasDelimiter)
               {
                  sourceBuffer.addLine ("");
               }
               else
               {
                  lastWasDelimiter = true;
               }
            }
            else
            {
               sourceBuffer.addLine (temp);
               lastWasDelimiter = false;
            }

         }
         sourceBuffer.setDirty (false);
      }
      sourceBuffer.setFilename ("Fujaba");
   }


   /**
    * @param buffer  what has been saved
    */
   public void bufferSaved (TextEditor.Buffer buffer)
   {
      sourceEditor.setText (buffer.getText());
      if (dialog != null)
      {
         dialog.okPressed();
      }
   }


   /**
    * @param dialog  which dialog to attach (closed upon edit)
    */
   public void setDialog (ClosableDialog dialog)
   {
      this.dialog = dialog;
   }
}

/*
 * $Log: TextEditAction.java,v $
 * Revision 1.4  2004/11/03 10:18:06  lowende
 * Javadoc warnings removed.
 *
 */
