/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui.comp;

import java.awt.*;
import java.awt.event.*;
import java.util.HashMap;

import javax.swing.*;

import org.apache.log4j.Logger;


/**
 * The FujabaDialog-class should be the main class for all dialogs, which are used in the fujaba-project.
 * This class provides some usefull functions like unparseTo, parseTo, and so on.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.24.2.2 $
 */
public class FujabaDialog extends JDialog implements ComponentListener
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FujabaDialog.class);

   /**
    * the dialog was closed by a not known button
    */
   public final static int NO = 0;

   /**
    * the dialog was closed by the OK-button
    */
   public final static int OK = NO + 1;

   /**
    * the dialog was closed by the Cancel-button
    */
   public final static int CANCEL = OK + 1;

   /**
    * the dialog was closed by the Close-button
    */
   public final static int CLOSE = CANCEL + 1;

   /**
    * the variable contains the button, which closes the dialog
    */
   private int pressedButton = NO;


   /**
    * use this function to get the button which closed the dialog
    *
    * @return   the button number from the button which closes the dialog
    * @see      #NO
    * @see      #OK
    * @see      #CANCEL
    * @see      #pressedButton
    */
   public int getPressedButton()
   {
      return this.pressedButton;
   }


   /**
    * the parent frame the the current dialog
    */
   private JFrame parentFrame;


   /**
    * @return   The parentFrame value
    * @see      #parentFrame
    */
   public JFrame getParentFrame()
   {
      return this.parentFrame;
   }

   // ######################################################################

   /**
    * @param frame  the frame of the parent window
    */
   public FujabaDialog (JFrame frame)
   {
      this (frame, "", true);
   }

   // ######################################################################

   /**
    * @param frame  the frame of the parent window
    * @param title  a string which should be the title of the dialog
    * @param modal  true for a modal dialog, false for one that allows others windows to be
    *      active at the same time
    */
   public FujabaDialog (JFrame frame, String title, boolean modal)
   {
      super (frame, title, modal);
      this.parentFrame = frame;
      addComponentListener (this);
   }


   /**
    * @param dialog  the parent dialog
    * @param title   a string which should be the title of the dialog
    * @param modal   true for a modal dialog, false for one that allows others windows to be
    *      active at the same time
    */
   public FujabaDialog (Dialog dialog, String title, boolean modal)
   {
      super (dialog, title, modal);
      this.parentFrame = null;
      addComponentListener (this);
   }

   // ######################################################################

   /**
    * this function builds the gui and should be called from the constructor
    */
   public void guiBuild() { }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton buttonOk = null;


   /**
    * Get the buttonOk attribute of the FujabaDialog object
    *
    * @return   The buttonOk value
    */
   public JButton getButtonOk()
   {
      return this.buttonOk;
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton buttonCancel = null;


   /**
    * Get the buttonCancel attribute of the FujabaDialog object
    *
    * @return   The buttonCancel value
    */
   public JButton getButtonCancel()
   {
      return this.buttonCancel;
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton buttonHelp = null;


   /**
    * Get the buttonHelp attribute of the FujabaDialog object
    *
    * @return   The buttonHelp value
    */
   public JButton getButtonHelp()
   {
      return this.buttonHelp;
   }

   // ######################################################################

   /**
    * this function returns a JPanel with the buttons Ok, Cancel and Help.
    *
    * @return   No description provided
    */
   public final JPanel guiPanelOkCancelHelp()
   {
      this.buttonOk = new JButton ("OK");
      this.buttonCancel = new JButton ("Cancel");
      this.buttonHelp = new JButton ("Help");

      buttonOk.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               actionOkButton();
            }
         }
         );

      getRootPane().setDefaultButton (buttonOk);

      buttonCancel.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               actionCancelButton();
            }
         }
         );

      buttonHelp.setEnabled (false);
      buttonHelp.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               actionHelpButton();
            }
         }
         );

      JPanel myPanel = new JPanel (new FlowLayout (FlowLayout.RIGHT));
      myPanel.add (buttonOk);
      myPanel.add (buttonCancel);
      myPanel.add (buttonHelp);
      return myPanel;
   }

   // ######################################################################

   /**
    * this function is called if the Ok-button is pressed
    */
   public void actionOkButton()
   {
      this.parse();
      this.pressedButton = OK;
      this.setVisible (false);
      this.dispose();
   }

   // ######################################################################

   /**
    * this function is called if the cancel-button is pressed
    */
   public void actionCancelButton()
   {
      this.pressedButton = CANCEL;
      this.setVisible (false);
      this.dispose();
   }

   // ######################################################################

   /**
    * this function is called if the help-button is pressed
    */
   public void actionHelpButton()
   {
      if (log.isInfoEnabled())
      {
         log.info ("pressed Help-Button");
      }
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton buttonClose = null;


   /**
    * Get the buttonClose attribute of the FujabaDialog object
    *
    * @return   The buttonClose value
    */
   public JButton getButtonClose()
   {
      return this.buttonClose;
   }


   /**
    * this function returns a JPanel with the buttons close and help
    *
    * @return   No description provided
    */
   public final JPanel guiPanelCloseHelp()
   {
      this.buttonHelp = new JButton ("Help");
      this.buttonClose = new JButton ("Close");

      buttonClose.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               actionCloseButton();
            }
         }
         );
      getRootPane().setDefaultButton (buttonClose);

      buttonHelp.setEnabled (false);
      buttonHelp.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               actionHelpButton();
            }
         }
         );

      JPanel myPanel = new JPanel (new FlowLayout (FlowLayout.RIGHT));
      myPanel.add (buttonClose);
      myPanel.add (buttonHelp);
      return myPanel;
   }

   // ######################################################################

   /**
    * this function is called if the close-button is pressed
    */
   public void actionCloseButton()
   {
      this.parse();
      this.pressedButton = CLOSE;
      this.setVisible (false);
      this.dispose();
   }

   // ######################################################################

   /**
    * call this function to show the dialog in the center of the current screen
    */
   public void showCentered()
   {
      this.pack();

      String className = getClass().getName();
      Dimension size = (Dimension) lastDimension.get (className);

      //----- check size
      if (size != null)
      {
         setSize (size);
      }
      else
      {
         size = this.getSize();
      }

      Dimension screenSize = this.getToolkit().getScreenSize();
      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;
      this.setLocation (x, y);

      // NOTE:
      // If the dialog is modal and is not already visible,
      // this call will not return until the dialog is hidden
      // by calling hide or dispose.
      this.show();
   }

   // ######################################################################

   /**
    * parse the UML-AST-Data and filles this dialog
    */
   public void unparse() { }

   // ######################################################################

   /**
    * parse the dialog data and update the UML-AST-Data
    */
   public void parse()
   {
      if (log.isInfoEnabled())
      {
         log.info ("data: Dialog --> UML-AST");
      }
   }


   // ######################################################################
   // ----- begin ComponentListener section
   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static HashMap lastDimension = new HashMap();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentHidden (ComponentEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentMoved (ComponentEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentResized (ComponentEvent e)
   {
      if (e.getSource() == this)
      {
         lastDimension.put (getClass().getName(), getSize());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void componentShown (ComponentEvent e) { }


   // ######################################################################
   // ----- help-functions to handle swing-components
   // ######################################################################

   /**
    * @param text       the text of the label
    * @param component  the compenete which should be labeled
    * @param alignment  where to put the label: <tt>SwingConstants.LEFT</tt> , <tt>SwingConstants.CENTER
    *      </tt> or <tt>SwingConstants.RIGHT</tt>
    * @return           a labeled JPanel
    */
   public JPanel makeLabeledPanel (String text, JComponent component,
                                   int alignment)
   {
      JPanel panel = new JPanel();
      JLabel label = new JLabel (text, alignment);

      float fAlignment = LEFT_ALIGNMENT;
      switch (alignment)
      {
         case SwingConstants.CENTER:
            fAlignment = CENTER_ALIGNMENT;
            break;
         case SwingConstants.RIGHT:
            fAlignment = RIGHT_ALIGNMENT;
            break;
      }
      panel.setLayout (new BoxLayout (panel, BoxLayout.Y_AXIS));
      label.setAlignmentX (fAlignment);
      panel.add (label);
      component.setAlignmentX (fAlignment);
      panel.add (component);
      return panel;
   }

}

/*
 * $Log: FujabaDialog.java,v $
 * Revision 1.24.2.2  2006/02/22 20:35:58  fklar
 * added comment to method 'showCentered'
 *
 */
