/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui.comp;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;


/**
 * cellrenderer which changes the text depending on the given value
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class StringCellRenderer extends JLabel implements ListCellRenderer
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static Border noFocusBorder = new EmptyBorder (1, 1, 1, 1);


   /**
    * Constructor for class StringCellRenderer
    */
   public StringCellRenderer()
   {
      super();
      setOpaque (true);
      setBorder (noFocusBorder);
   }


   /**
    * Get the listCellRendererComponent attribute of the StringCellRenderer object
    *
    * @param list          No description provided
    * @param value         No description provided
    * @param index         No description provided
    * @param isSelected    No description provided
    * @param cellHasFocus  No description provided
    * @return              The listCellRendererComponent value
    */
   public Component getListCellRendererComponent (JList list, Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
   {
      if (isSelected)
      {
         setBackground (list.getSelectionBackground());
         setForeground (list.getSelectionForeground());
      }
      else
      {
         setBackground (list.getBackground());
         setForeground (list.getForeground());
      }

      setComponentOrientation (list.getComponentOrientation());

      //----- set the text depend on the given value
      setValue (value);

      setEnabled (list.isEnabled());
      setFont (list.getFont());

      if (cellHasFocus)
      {
         setBorder (UIManager.getBorder ("List.focusCellHighlightBorder"));
      }
      else
      {
         setBorder (noFocusBorder);
      }
      return this;
   }


   /**
    * Overwrite this function to get always the right text displayed. e.g.: <tt>setText( value.toString()
    * );</tt>
    *
    * @param value  the value for which this function should setup this component
    */
   public void setValue (Object value)
   {
      if (value != null)
      {
         setText (value.toString());
      }
      else
      {
         setText ("");
      }
   }
}

/*
 * $Log: StringCellRenderer.java,v $
 * Revision 1.12  2004/10/20 17:49:56  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
