/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.io.*;
import java.util.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.basic.ClassMap;
import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.31.2.1 $
 */
public class FileSaver
{
   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    */
   private final static transient Logger log = Logger.getLogger (FileSaver.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Iterator iter;
   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    */
   private File dest;
   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    */
   private File[] stylesheets;
   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    */
   public final static String SEPARATOR = "\uFFFA"; // instead of ; in the fpr-file

   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    */
   private boolean addExport;


   /**
    * Constructor for class FileSaver
    *
    * @param iter         No description provided
    * @param dest         No description provided
    * @param stylesheets  No description provided
    * @param addExport    No description provided
    */
   public FileSaver (Iterator iter, File dest, File[] stylesheets, boolean addExport)
   {
      this.iter = iter;
      this.dest = dest;
      this.stylesheets = stylesheets;
      this.addExport = addExport;
   }


   /**
    * Constructor for class FileSaver
    *
    * @param iter       No description provided
    * @param dest       No description provided
    * @param addExport  No description provided
    */
   public FileSaver (Iterator iter, File dest, boolean addExport)
   {
      this.iter = iter;
      this.dest = dest;
      this.addExport = addExport;
      this.stylesheets = null;
   }


   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    */
   public void save()
   {
      StringBuffer outputData = new StringBuffer (131072);

      try
      {
         if (this.iter.hasNext())
         {

            GXLFilter excludedXML = new GXLFilter (iter, addExport, outputData);

            // Remove excluded Elements
            outputData = excludedXML.removeExcludedObjects (outputData);

            if (stylesheets != null && stylesheets.length > 0)
            {
               // transforming fpr to xml
               Document doc = fpr2xml (new BufferedReader (new StringReader (outputData.toString())));

               for (int idx = 0; idx < stylesheets.length - 1; idx++)
               {
                  doc = XSLTransformer.transform (doc, stylesheets[idx]);
               }
               // writing to file
               XSLTransformer.transform (doc, dest, stylesheets[stylesheets.length - 1]);

            }
            else
            {
               //no stylesheet specified
               Document doc = fpr2xml (new BufferedReader (new StringReader (outputData.toString())));
               XSLTransformer.transformWithoutStylesheet (doc, dest);
            }
         }
      }
      catch (Exception e)
      {
         if (log.isInfoEnabled())
         {
            log.info (e.getMessage());
         }
         e.printStackTrace();
         throw new RuntimeException ("An error occured while writing the file " +
            dest.getName() +
            "\nMessage : " + e.getMessage());
      }
      finally
      {
         BasicIncrement.resetClassInfos();
      }
   }


   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    *
    * @param input  No description provided
    * @return       No description provided
    */
   private Document fpr2xml (BufferedReader input)
   {
      boolean firstElement = true;
      Hashtable allPlugins = new Hashtable();

      BufferedReader in = input;
      String line;
      StringTokenizer lineToken;
      StringWriter out = new StringWriter (1000000);
      try
      {
         //out.write("<project>\n<header>\n");

         out.write ("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n" +
            "<!DOCTYPE fujaba_export SYSTEM \"http://www.upb.de/cs/fujaba/DTDs/fujaba.dtd\">\n" +
            "<fujaba_export xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n" +
            "<diagram>\n");

         while (in.ready())
         {
            line = in.readLine();

            if (line == null)
            {
               break;
            }

            line = substitute (";", FileSaver.SEPARATOR, line); // ; as a seperator(in fpr-file) must differ from ; as part of entity reference below

            // replace the five evil xml-characters
            // instead od hiding them in CDATA-sections
            // order of substitutions is important; & must be replaced first

            line = substitute ("&", "&amp;", line);
            line = substitute ("<", "&lt;", line);
            line = substitute (">", "&gt;", line);
            line = substitute ("\"", "&quot;", line);
            line = substitute ("'", "&apos;", line);

            // \1 and \2 are used for replacing charaters inside Fujaba

            line = substitute ("\1", "\n", line); // \1(\n within sourcecode) is not a valid XML-character

            line = substitute ("\2", ";", line); // \2(;  within sourcecode) is not a valid XML-character

            lineToken = createLineTokenizer (line); // now uses � for seperation , is this save ??

            switch (line.charAt (0))
            {
               case '*':
               {
                  if (firstElement)
                  {
                     firstElement = false;
                  }
                  else
                  {
                     out.write ("</object>\n");
                  }

                  String id = lineToken.nextToken();
                  String className = lineToken.nextToken();
                  String pluginId = lineToken.nextToken();

                  UPBClassLoader pluginClassLoader = null;
                  try
                  {
                     pluginClassLoader = UPBClassLoader.get (pluginId);
                  }
                  catch (Exception e)
                  {
                     //the plugin classLoader could not find the class --> loading of the class with the default loader
                     ClassMap.get().forName (className).newInstance();
                  }

                  out.write ("<object id=\"" + id + "\">\n");
                  out.write ("<class>" + className + "</class>\n");

                  out.write ("<pluginId>" + pluginId + "</pluginId>\n");
                  out.write ("<classLoader>" + pluginClassLoader + "</classLoader>\n");

                  break;
               }
               case '~':
               {
                  lineToken = createLineTokenizer (line);

                  String attrName = lineToken.nextToken();

                  out.write ("<attribute name=\"" + attrName + "\">\n");

                  if (lineToken.countTokens() == 0)
                  {
                     out.write ("<value/>\n");
                  }
                  else if (lineToken.countTokens() == 1)
                  {
                     out.write ("<value>" + lineToken.nextToken() + "</value>\n");
                  }
                  else if (lineToken.countTokens() == 2)
                  {
                     out.write ("<reference>" + lineToken.nextToken() + "</reference>\n");
                     out.write ("<value>" + lineToken.nextToken() + "</value>\n");
                  }
                  else
                  {
                     log.error ("line has " + lineToken.countTokens() + " parts");
                  }

                  out.write ("</attribute>\n");
                  out.flush();
                  break;
               }
               case '@':
               {
                  out.write ("</object>\n</diagram>\n<diagram>\n");
                  firstElement = true;
                  break;
               }
               case '$':
               {
                  //used plugins
                  lineToken = createLineTokenizer (line);
                  String pluginName = lineToken.nextToken();
                  String internalPluginId = lineToken.nextToken();
                  allPlugins.put (internalPluginId, pluginName);
                  String pluginMajor = lineToken.nextToken();
                  String pluginMinor = lineToken.nextToken();
                  String pluginBuildNumber = lineToken.nextToken();
                  out.write ("<plugin>\n");
                  out.write ("<name>" + pluginName + "</name>\n");
                  out.write ("<id>" + internalPluginId + "</id>\n");
                  out.write ("<majorVersion>" + pluginMajor + "</majorVersion>\n");
                  out.write ("<minorVersion>" + pluginMinor + "</minorVersion>\n");
                  out.write ("<buildNumber>" + pluginBuildNumber + "</buildNumber>\n");
                  out.write ("</plugin>\n");
                  break;
               }

            } // switch

         } // while

         out.write ("</object>\n</diagram>\n</fujaba_export>");
         out.flush();

         // string to dom
         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
         factory.setValidating (true);
         factory.setNamespaceAware (true);
         DocumentBuilder builder = factory.newDocumentBuilder();
         if (log.isInfoEnabled())
         {
            log.info (builder.getClass().getName());
         }
         GXLHandler handler = new GXLHandler();
         builder.setEntityResolver (handler);
         builder.setErrorHandler (handler);
         Document doc = builder.parse (new InputSource (new StringReader (out.toString())));
         out.close();

         return doc;
      }
      catch (Exception e)
      {
         log.error ("Error while transforming fpr to xml.");
         e.printStackTrace();
         return null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    *
    * @param line  No description provided
    * @return      No description provided
    */
   private final StringTokenizer createLineTokenizer (String line)
   {
      StringTokenizer st = new StringTokenizer (line, FileSaver.SEPARATOR);
      st.nextToken();
      return st;
   }


   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    *
    * @param oldValue  No description provided
    * @param newValue  No description provided
    * @param context   No description provided
    * @return          No description provided
    */
   private static String substitute (String oldValue, String newValue, String context)
   {
      int idx = 0;
      int len = oldValue.length();
      idx = context.indexOf (oldValue, 1);
      while (idx > -1)
      {
         if (idx > 0)
         {
            context = context.substring (0, idx) + newValue + context.substring (idx + len);
         }
         idx = context.indexOf (oldValue, idx + 1);
      }
      return context;
   }



   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static String reReplace (String value)
   {
      String line = value;

      // re-replace the five evil xml-characters
      // order of substitutions is important; & must be replaced last
      line = substitute ("&lt;", "<", line);
      line = substitute ("&gt;", ">", line);
      line = substitute ("&quot;", "\"", line);
      line = substitute ("&apos;", "'", line);
      line = substitute ("&amp;", "&", line);

      return line;
   }

}

/*
 * $Log: FileSaver.java,v $
 * Revision 1.31.2.1  2005/09/30 18:57:22  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
