/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.util.Iterator;

import de.upb.tools.fca.FHashMap;


/**
 * In the GXLFilterMap are the special Filters of the diagrams saved
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.6 $
 */
public class GXLFilterMap
{
   /**
    * GXLFilterMap is a singleton
    */
   private static GXLFilterMap gxlFilterMap;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FHashMap gxlHashMap;


   /**
    * Get the gXLFilterMap attribute of the GXLFilterMap class
    *
    * @return       The gXLFilterMap value
    * @deprecated   Obsolete
    */
   public static FHashMap getGXLFilterMap()
   {
      if (gxlFilterMap == null)
      {
         gxlFilterMap = new GXLFilterMap();
      }
      return gxlHashMap;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static GXLFilterMap get()
   {
      if (gxlFilterMap == null)
      {
         gxlFilterMap = new GXLFilterMap();
      }
      return gxlFilterMap;
   }


   /**
    * Constructor for class GXLFilterMap
    */
   private GXLFilterMap()
   {
      gxlHashMap = new FHashMap();
   }


   /**
    * Access method for an one to n association.
    *
    * @param key    The object added.
    * @param value  The object added.
    */
   public void addToFilter (Class key, Filter value)
   {
      gxlHashMap.put (key, value);
   }


   /**
    * Get the fromFilter attribute of the GXLFilterMap object
    *
    * @param key  No description provided
    * @return     The fromFilter value
    */
   public Filter getFromFilter (Class key)
   {
      return (Filter) gxlHashMap.get (key);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param keyIter  No description provided
    */
   public void removeFromFilter (Iterator keyIter)
   {
      while (keyIter.hasNext())
      {
         Object key = keyIter.next();
         gxlHashMap.remove (key);
      }
   }

}

/*
 * $Log: GXLFilterMap.java,v $
 * Revision 1.6  2004/10/20 17:49:57  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
