/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.lang.reflect.*;
import java.util.*;

import org.apache.log4j.Logger;
import org.w3c.dom.Element;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.*;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.upb.tools.fca.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mtt $
 * @version   $Revision: 1.42.2.2 $
 */
public class GXLImport
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (GXLImport.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FXMLTree gxlInput;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   ASGDiagram importPoint;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FHashMap nodes = new FHashMap();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FHashMap obj = new FHashMap();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FHashSet mergePoints;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Vector objects = new Vector();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Vector increments = new Vector();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Vector mergeObjects = new Vector();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   AbstractMerger myMerger;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FHashMap setableAttributes;


   //normally used for loading UMLDiagrams or pieces of UMLDiagrams
   /**
    * Constructor for class GXLImport
    *
    * @param tree   No description provided
    * @param point  No description provided
    */
   public GXLImport (FXMLTree tree, ASGDiagram point)
   {
      this.gxlInput = tree;
      this.importPoint = point;
         if (loadObjects())
         {
            parse();
            myMerger.postprocessing (point);
            
         }
   }


   /**
    * Get the merger attribute of the GXLImport object
    *
    * @param diag  No description provided
    */
   private void getMerger (ASGDiagram diag)
   {
      this.myMerger = Creator.getMerger (diag);
      if (myMerger == null)
      {
         throw new RuntimeException ("No merger found for : " + diag.getClass());
      }
      GXLExcludedLoader tmpLoader = new GXLExcludedLoader();

      if (tmpLoader.isReady())
      {
         this.mergePoints = tmpLoader.getMergePoints (diag.getClass().getName());
      }
   }

   //only used for loading Patterns

   /**
    * Constructor for class GXLImport
    *
    * @param tree            No description provided
    * @param point           No description provided
    * @param presentObjects  No description provided
    */
   public GXLImport (FXMLTree tree, ASGDiagram point, HashMap presentObjects)
   {

      this.nodes.putAll (presentObjects);
      this.gxlInput = tree;
      this.importPoint = point;

      initSetableAttributes();
      try
      {
         UnparseManager.get().pausePropertyProcessing();
         if (loadObjects())
         {
            parsePattern (presentObjects);
            FrameMain.get().createNewTreeItems();
         }
      }
      finally
      {
         UnparseManager.get().resumePropertyProcessing();
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param tmp          No description provided
    * @param firstObject  No description provided
    */
   private void removeObject (Object firstObject, String tmp)
   {
      Enumeration enumeration = objects.elements();

      while (enumeration.hasMoreElements())
      {
         Object tmpObject = enumeration.nextElement();

         if (tmpObject.getClass().getName().equals (firstObject.getClass().getName()))
         {
            objects.remove (tmpObject);
            nodes.remove (tmp);
            obj.remove (tmpObject);
            break;
         }

      }
      nodes.put (tmp, firstObject);
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param tmpObject  No description provided
    * @return           No description provided
    */
   private boolean verifyContext (FXMLNode tmpObject)
   {
      if (tmpObject != null)
      {
         this.removeObject (importPoint, tmpObject.getId());
         return true;
      }
      else
      {
         return false;
      }
   }


   /**
    * Get the nodes attribute of the GXLImport object
    *
    * @return   The nodes value
    */
   public FHashMap getNodes()
   {
      return this.nodes;
   }


   /**
    * Get the objects attribute of the GXLImport object
    *
    * @return   The objects value
    */
   public Vector getObjects()
   {
      return this.objects;
   }


   /**
    * Get the obj attribute of the GXLImport object
    *
    * @return   The obj value
    */
   public FHashMap getObj()
   {
      return this.obj;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private boolean loadObjects()
   {
      try
      {
         Element actualDiagram = gxlInput.getNextDiagram();
         FXMLNode fxmlObject = gxlInput.getFirstObject (actualDiagram);

         if (verifyContext (fxmlObject))
         {

            while (actualDiagram != null)
            {
               FXMLNode actualNode = gxlInput.getFirstObject (actualDiagram);

               if (actualNode != null)
               {

                  Object firstObject = null;
                  try
                  {
                     firstObject = Class.forName (actualNode.getType()).newInstance();
                  }
                  catch (Exception e)
                  {
                     //Class must be load with a special classLoader
                     UPBClassLoader pluginClassLoader = UPBClassLoader.get (actualNode.getPluginId());
                     firstObject = pluginClassLoader.loadClass (actualNode.getType()).newInstance();
                  }

                  if (firstObject instanceof ASGDiagram)
                  {
                     getMerger ((ASGDiagram) firstObject);
                  }
                  else
                  {
                     getMerger (importPoint);
                  }

                  if (!myMerger.preventImport (firstObject, actualNode, this))
                  {
                     mergeObjects = new Vector();
                     Object actualObject = null;

                     while (actualNode != null)
                     {

                        if (! (actualNode.getType()).equals ("de.uni_paderborn.fujaba.uml.UMLProject"))
                        {
                           if (mergePoints.contains (actualNode.getType()))
                           {
                              this.mergeObjects.add (actualNode);
                           }

                           else
                           {

                              if (!nodes.containsKey (actualNode.getId()))
                              {
                                 try
                                 {
                                    actualObject = ClassMap.get().forName (actualNode.getType()).newInstance();
                                 }
                                 catch (Exception e)
                                 {
                                    try
                                    {
                                       //Class must be load with a special classLoader
                                       UPBClassLoader pluginClassLoader = UPBClassLoader.get (actualNode.getPluginId());
                                       actualObject = pluginClassLoader.loadClass (actualNode.getType()).newInstance();
                                    }
                                    catch (Exception ex)
                                    {
                                       ex.printStackTrace();
                                    }
                                 }

                                 objects.add (actualObject);
                                 nodes.put (actualNode.getId(), actualObject);
                                 obj.put (actualObject, actualNode);

                                 if (actualObject instanceof ASGDiagram)
                                 {
                                    if (!actualObject.getClass().getName().equals (this.importPoint.getClass().getName()))
                                    {
                                       UMLProject proj = UMLProject.get();
                                       proj.addToDiags ((ASGDiagram) actualObject);
                                    }
                                 }
                              }
                              else
                              {
                                 Object tmpObject = nodes.get (actualNode.getId());
                                 objects.add (tmpObject);
                                 obj.put (tmpObject, actualNode);
                              }
                           }
                        }
                        else
                        {
                           if (!nodes.containsKey (actualNode.getId()))
                           {
                              nodes.put (actualNode.getId(), UMLProject.get());
                           }
                        }
                        actualNode = gxlInput.getNextObject();
                     }
                     // Overwrite checkInput in your merger and return false if you want to cancel
                     // the import process without importing anything.
                     if (!myMerger.checkInput ((ASGDiagram) firstObject, mergeObjects, this))
                     {
                        return false;
                     }
                     myMerger.merge ((ASGDiagram) firstObject, mergeObjects, this);
                  }
                  actualDiagram = gxlInput.getNextDiagram();
               }
            }
            return true;
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }

      return false;
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void initSetableAttributes()
   {
      setableAttributes = new FHashMap();
      HashSet classes = new HashSet();
      HashSet methods = new HashSet();
      HashSet attribs = new HashSet();
      HashSet assocs = new HashSet();

      classes.add ("methods");
      classes.add ("attrs");
      classes.add ("stereotypes");
      classes.add ("revImportedClasses");
      classes.add ("revAttrType");
      classes.add ("attrmethodsort");
      classes.add ("roles");
      classes.add ("instances");
      classes.add ("declares");
      classes.add ("revSubclass");
      classes.add ("revSuperclass");
      classes.add ("revResultType");
      classes.add ("revParamType");
      methods.add ("declares");
      methods.add ("throwsTypes");
      attribs.add ("revQualifiedAttr");
      attribs.add ("instances");
      assocs.add ("instances");
      setableAttributes.put ("de.uni_paderborn.fujaba.uml.UMLClass", classes);
      setableAttributes.put ("de.uni_paderborn.fujaba.uml.UMLMethod", methods);
      setableAttributes.put ("de.uni_paderborn.fujaba.uml.UMLAttr", attribs);
      setableAttributes.put ("de.uni_paderborn.fujaba.uml.UMLAssoc", assocs);
   }



   /**
    * Get the setableAttribute attribute of the GXLImport object
    *
    * @param obj   No description provided
    * @param attr  No description provided
    * @return      The setableAttribute value
    */
   private boolean isSetableAttribute (String obj, String attr)
   {
      if (setableAttributes == null)
      {
         return false;
      }
      else
      {
         HashSet result = (HashSet) setableAttributes.get (obj);
         if (result == null)
         {
            return false;
         }
         else
         {
            return result.contains (attr);
         }
      }
   }

   //only used for parsing Pattern

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param presentObjects  No description provided
    * @return                No description provided
    */
   public boolean parsePattern (HashMap presentObjects)
   {
      try
      {
         Enumeration enumeration = objects.elements();
         while (enumeration.hasMoreElements())
         {
            Object actualObject = enumeration.nextElement();
            FXMLNode actualNode = (FXMLNode) obj.get (actualObject);
            boolean mappedObject = presentObjects.containsKey (actualNode.getId());
            String type = actualNode.getType();
            Vector infos = getClassFromCache (actualObject.getClass());
            Vector attributes = (Vector) infos.get (0);
            Enumeration enumeration2 = attributes.elements();
            FHashMap nodeAttributes = actualNode.getAttributesAndValues();
            while (enumeration2.hasMoreElements())
            {
               Field actualField = (Field) enumeration2.nextElement();
               boolean setableAttr = mappedObject ? isSetableAttribute (type, actualField.getName()) : false;
               if ( (!mappedObject ||  (mappedObject & setableAttr)) & nodeAttributes.containsKey (actualField.getName()))
               {
                  // let`s take care of what type of Object we have got.
                  if (Collection.class.isAssignableFrom (actualField.getType()) ||
                      (actualField.get (actualObject)) instanceof Collection ||
                      (actualField.get (actualObject)) instanceof Hashtable || Map.class.isAssignableFrom (actualField.getType()) ||  (actualField.get (actualObject)) instanceof FPropLinkedList)
                  {
                     if (actualField.getName().equals ("diagrams"))
                     {
                        this.addIncrementToDiagrams ((ASGElement) actualObject);
                     }
                     else
                     {
                        putElements (actualObject, actualField,  ((Vector) nodeAttributes.get (actualField.getName())), (FHashMap) infos.get (1));
                     }
                  }
                  else
                  {
                     try
                     {
                        Object mistObject = actualField.get (actualObject);
                        setValue (mistObject, actualObject, actualField,  ((Vector) nodeAttributes.get (actualField.getName())), (FHashMap) infos.get (1));
                     }
                     catch (Exception e)
                     {
                     }
                  }
               }
            }

            if (actualObject instanceof UMLAttr)
            {
               UMLAttr tmpAttr =  ((UMLAttr) actualObject);
               String text = "attrType";
               if (nodeAttributes.containsKey (text))
               {
                  Vector tmpVector = (Vector) nodeAttributes.get (text);
                  Object attrType = nodes.get (tmpVector.firstElement());
                  if (attrType instanceof UMLBaseTypes)
                  {
                     tmpAttr.setAttrType ( ((UMLBaseTypes) attrType));
                  }
                  else if (attrType instanceof UMLClass)
                  {
                     tmpAttr.setAttrType ((UMLClass) attrType);
                  }
                  else
                  {
                     tmpAttr.setAttrType ((UMLType) attrType);
                  }
               }
            }
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
         return false;
      }

      return true;
   }



   //normally used parse-algorithm

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean parse()
   {
      try
      {
         Enumeration enumeration = objects.elements();
         while (enumeration.hasMoreElements())
         {
            Object actualObject = enumeration.nextElement();
            FXMLNode actualNode = (FXMLNode) obj.get (actualObject);
            Vector infos = getClassFromCache (actualObject.getClass());
            Vector attributes = (Vector) infos.get (0);
            Enumeration enumeration2 = attributes.elements();
            FHashMap nodeAttributes = actualNode.getAttributesAndValues();
            while (enumeration2.hasMoreElements())
            {
               Field actualField = (Field) enumeration2.nextElement();
               if (nodeAttributes.containsKey (actualField.getName()))
               {
                  // let`s take care of what type of Object we have got.
                  if (Collection.class.isAssignableFrom (actualField.getType()) ||
                      (actualField.get (actualObject)) instanceof Collection ||
                      (actualField.get (actualObject)) instanceof Hashtable || Map.class.isAssignableFrom (actualField.getType()) ||  (actualField.get (actualObject)) instanceof FPropLinkedList)
                  {
                     putElements (actualObject, actualField,  ((Vector) nodeAttributes.get (actualField.getName())), (FHashMap) infos.get (1));
                  }
                  else
                  {
                     try
                     {
                        Object mistObject = actualField.get (actualObject);
                        setValue (mistObject, actualObject, actualField,  ((Vector) nodeAttributes.get (actualField.getName())), (FHashMap) infos.get (1));
                     }
                     catch (Exception e)
                     {
                        e.printStackTrace();
                     }
                  }
               }
            }
            if (actualObject instanceof UMLAttr)
            {
               UMLAttr tmpAttr =  ((UMLAttr) actualObject);
               String text = "attrType";
               if (nodeAttributes.containsKey (text))
               {
                  Vector tmpVector = (Vector) nodeAttributes.get (text);
                  Object attrType = nodes.get (tmpVector.firstElement());
                  if (attrType instanceof UMLBaseTypes)
                  {
                     tmpAttr.setAttrType ( ((UMLBaseTypes) attrType));
                  }
                  else if (attrType instanceof UMLClass)
                  {
                     tmpAttr.setAttrType ((UMLClass) attrType);
                  }
                  else
                  {
                     tmpAttr.setAttrType ((UMLType) attrType);
                  }
               }
            }
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
         return false;
      }

      return true;
   }


   /**
    * Access method for an one to n association.
    *
    * @param tmp  The object added.
    */
   private void addIncrementToDiagrams (ASGElement tmp)
   {
      this.increments.add (tmp);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param currentField  No description provided
    * @return              No description provided
    */
   private boolean checkStaticTransient (Field currentField)
   {
      int fieldModi = currentField.getModifiers();
      return  (Modifier.isTransient (fieldModi) || Modifier.isStatic (fieldModi));
   }



   /**
    * Access method for an one to n association.
    *
    * @param newMethod  The object added.
    * @param map        The object added.
    */
   private final void addToAddSetMethods (Method newMethod, FHashMap map)
   {
      Vector newSet = (Vector) map.get (newMethod.getName());
      if (newSet == null)
      {
         newSet = new Vector (2);
         newSet.add (newMethod);
         map.put (newMethod.getName(), newSet);
      }
      else
      {
         newSet.add (newMethod);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static transient FHashMap classInfos = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static void resetClassInfos()
   {
      if (classInfos != null)
      {
         classInfos.clear();
         classInfos = null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FHashMap fieldWriteMethods = new FHashMap();


   /**
    * Access method for an one to n association.
    *
    * @param c  The object added.
    * @param f  The object added.
    * @param m  The object added.
    */
   private void addToFieldWriteMethods (Class c, Field f, Method m)
   {
      FHashMap entry = (FHashMap) fieldWriteMethods.get (c);
      if (entry == null)
      {
         entry = new FHashMap();
         fieldWriteMethods.put (c, entry);
      }
      entry.put (f, m);
   }


   /**
    * Get the fromFieldWriteMethods attribute of the GXLImport object
    *
    * @param c  No description provided
    * @param f  No description provided
    * @return   The fromFieldWriteMethods value
    */
   private Method getFromFieldWriteMethods (Class c, Field f)
   {
      if (fieldWriteMethods != null)
      {
         FHashMap entry = (FHashMap) fieldWriteMethods.get (c);
         if (entry != null)
         {
            return (Method) entry.get (f);
         }
      }

      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static void resetFieldWriteMethods()
   {
      Iterator iter = fieldWriteMethods.keySet().iterator();
      while (iter.hasNext())
      {
         fieldWriteMethods.remove (iter.next());
      }
   }


   /**
    * Get the addSetMethods attribute of the GXLImport object
    *
    * @param addMethod  No description provided
    * @param methodMap  No description provided
    * @return           The addSetMethods value
    */
   private final Enumeration getAddSetMethods (String addMethod,
                                               FHashMap methodMap)
   {

      Vector methods = (Vector) methodMap.get (addMethod);
      if (methods == null)
      {
         return null;
      }
      else
      {
         return  (methods.elements());
      }
   }



   /**
    * Get the methodName attribute of the GXLImport object
    *
    * @param prefix      No description provided
    * @param attribName  No description provided
    * @return            The methodName value
    */
   private final String getMethodName (String prefix, String attribName)
   {
      StringBuffer buf = new StringBuffer();
      buf.append (prefix);
      buf.append (Character.toUpperCase (attribName.charAt (0)));
      buf.append (attribName.substring (1));
      return new String (buf);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param addMethods  No description provided
    * @return            No description provided
    */
   private final Method nextAddMethod (Enumeration addMethods)
   {
      if ( (addMethods != null) &&  (addMethods.hasMoreElements()))
      {
         return  ((Method) addMethods.nextElement());
      }
      else
      {
         return  (null);
      }
   }


   /**
    * Get the classFromCache attribute of the GXLImport object
    *
    * @param clazz  No description provided
    * @return       The classFromCache value
    */
   private Vector getClassFromCache (Class clazz)
   {
      if (classInfos == null)
      {
         classInfos = new FHashMap();
      }
      // lookup cache hashmap
      Vector cacheEntry = (Vector) classInfos.get (clazz);
      if (cacheEntry == null)
      {
         // get fields of this class and its superclasses
         // and all access methods
         Field[] tmpClassFields;
         Method[] tmpClassMethods;
         String name;
         Vector classFields = new Vector();
         FHashMap methodHashMap = new FHashMap();
         Class javaClass = clazz;
         while (javaClass != null)
         {
            // store all fields
            tmpClassFields = javaClass.getDeclaredFields();

            for (int i = 0; i < tmpClassFields.length; i++)
            {
               if (!checkStaticTransient (tmpClassFields[i]))
               {
                  tmpClassFields[i].setAccessible (true);
                  classFields.addElement (tmpClassFields[i]);
               }
            }

            // store all methods
            tmpClassMethods = javaClass.getDeclaredMethods();
            for (int i = 0; i < tmpClassMethods.length; i++)
            {
               name = tmpClassMethods[i].getName();
               if (name.startsWith ("set") || name.startsWith ("add"))
               {
                  tmpClassMethods[i].setAccessible (true);
                  addToAddSetMethods (tmpClassMethods[i], methodHashMap);
               }
            }
            javaClass = javaClass.getSuperclass();
         }

         // add to cache classInfo
         cacheEntry = new Vector (2);
         cacheEntry.add (classFields);
         cacheEntry.add (methodHashMap);
         classInfos.put (clazz, cacheEntry);
      }

      return  (cacheEntry);
   }



   /**
    * Access method for an one to n association.
    *
    * @param fieldObject   The object added.
    * @param arg           The object added.
    * @param currentField  The object added.
    */
   private void addElem (Object fieldObject, Object arg, Field currentField)
   {
      if (Map.class.isAssignableFrom (currentField.getType()))
      {
         if (fieldObject != null)
         {
             ((Map) fieldObject).put ( ((KeyValuePair) arg).getKey(),
                ((KeyValuePair) arg).getValue());
         }
      }
      else if (Collection.class.isAssignableFrom (currentField.getType()))
      {
         if (fieldObject == null)
         {
            log.error ("error2");
         }
         else
         {
             ((Collection) fieldObject).add (arg);
         }
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param fieldObject              No description provided
    * @param currentField             No description provided
    * @param values                   No description provided
    * @param methodMap                No description provided
    * @throws IllegalAccessException  Exception description not provided
    */
   private final void putElements (Object fieldObject, Field currentField, Vector values, FHashMap methodMap) throws IllegalAccessException
   {
      boolean methodIsInCache = true;
      Method addMethod = getFromFieldWriteMethods (fieldObject.getClass(), currentField);
      Enumeration addMethods = null;
      boolean retry = false;
      Object[] test = new Object[1];
      if (addMethod == null)
      { // if (1 == 1)
         // not yet known method, search for it.
         methodIsInCache = false;
         addMethods = getAddSetMethods (getMethodName ("addTo", currentField.getName()), methodMap);
         if (addMethods == null)
         {
            FujabaDebug.println ("OhOh, putElements did not find an addMethods iterator for "
               + currentField.getName());
         }

         // lets take the first possible access method
         addMethod = nextAddMethod (addMethods);
      }
      else
      {
         if (!addMethod.getDeclaringClass().isAssignableFrom (this.getClass()))
         {
            FujabaDebug.println ("RED ALERT::::::::: " + currentField.getName()
               + " " + addMethod.getName());
         }
      }
      Enumeration iter = values.elements();
      while ( (iter.hasMoreElements() || retry) &&  (addMethod != null))
      {
         try
         {
            while (iter.hasMoreElements() || retry)
            {
               if (!retry)
               {
                  String value =  ((String) iter.nextElement());
                  int nPoint = value.lastIndexOf (FileSaver.SEPARATOR);
                  if (nPoint == -1 || nPoint ==  (value.length() - 1))
                  {
                     test[0] = nodes.get (value);
                  }
                  else
                  {
                     if ( (nPoint > 0) &  (nPoint <  (value.length() - 1)))
                     {
                        String key = value.substring (0, nPoint).trim();
                        String tmpValue = value.substring (nPoint + 1).trim();
                        BasicIncrement entry = (BasicIncrement) nodes.get (tmpValue);

                        if (isKey (key) &&  (nodes.get (key) != null))
                        {
                           BasicIncrement keyIncr = (BasicIncrement) nodes.get (key);
                           test[0] = new KeyValuePair (keyIncr, entry);
                        }
                        else
                        {
                           test[0] = new KeyValuePair (key, entry);
                        }
                     }
                  }
               }
               retry = false;
               if (!addMethod.isAccessible())
               {
                  addMethod.setAccessible (true);
               }
               if (test[0] != null)
               {
                  addMethod.invoke (fieldObject, test);
               }
            }
            if (!methodIsInCache)
            {
               // that one worked, cache it
               addToFieldWriteMethods (this.getClass(), currentField, addMethod);
            }
         }
         catch (IllegalArgumentException argExcept)
         {
            // lets ignore this method and flip to next, until we are out of
            // methods
            retry = true;
            addMethod = nextAddMethod (addMethods);
         }
         catch (InvocationTargetException invExcept)
         {
            retry = true;
            addMethod = nextAddMethod (addMethods);
         }
      }

      // if this attrib has no access-method, lets do it the direct way
      // first don`t forget the current element!
      if (retry)
      {
         if (log.isDebugEnabled())
         {
            log.debug ("Error6");
         }
         addElem (currentField.get (fieldObject), test[0], currentField);
      }
   }


   /**
    * Get the key attribute of the GXLImport object
    *
    * @param s  No description provided
    * @return   The key value
    */
   private boolean isKey (String s)
   {
      boolean result = true;
      String prefix = s.substring (0, 2);
      if (!prefix.equals ("id"))
      {
         result = false;
      }
      else
      {
         String number = s.substring (2, s.length());
         try
         {
            Integer.parseInt (number);
         }
         catch (NumberFormatException e)
         {
            result = false;
         }
      }
      return result;
   }


   /**
    * Sets the value attribute of the GXLImport object
    *
    * @param tmpObject     The new value value
    * @param fieldObject   The new value value
    * @param currentField  The new value value
    * @param values        The new value value
    * @param methodMap     The new value value
    */
   private final void setValue (Object tmpObject, Object fieldObject, Field currentField, Vector values, FHashMap methodMap)
   {
      Object[] args = new Object[1];
      boolean foundSet = false;
      boolean methodIsInCache = true; // be optimistic
      String value =  ((String) values.firstElement());

      Enumeration setMethods = null;
      Method setMethod = getFromFieldWriteMethods (fieldObject.getClass(), currentField);

      if (setMethod == null)
      { // if (1 == 1)
         // not yet cached
         methodIsInCache = false;

         // Catch the set method for the non-container attribs.
         setMethods = getAddSetMethods (getMethodName ("set", currentField.getName()), methodMap);
      }

      // retrieve the data which is to be set, we need the isAssignableFrom
      // to take care of the null-Fields and the instanceof to take
      // care of the interface-fields.

      if (BasicIncrement.class.isAssignableFrom (currentField.getType()) ||
          (tmpObject instanceof BasicIncrement) ||
         UMLType.class.isAssignableFrom (currentField.getType()))
      {
         args[0] = nodes.get (value);
      }
      else if (String.class.isAssignableFrom (currentField.getType()) ||
         tmpObject instanceof String)
      {
         args[0] = value;
      }
      else if (tmpObject instanceof Boolean)
      {
         args[0] = Boolean.valueOf (value);
      }
      else if (tmpObject instanceof Float)
      {
         args[0] = new Float (value);
      }
      else if (tmpObject instanceof Short)
      {
         args[0] = new Short (value);
      }
      else if (tmpObject instanceof Double)
      {
         args[0] = new Double (value);
      }
      else if (tmpObject instanceof Integer)
      {
         args[0] = new Integer (value);
      }
      else if (tmpObject instanceof Long)
      {
         args[0] = new Long (value);
      }
      else if (tmpObject instanceof Byte)
      {
         args[0] = new Byte (value);
      }
      else
      {
         // another data type
         log.error ("Unsupported data type in GXLImport!");
      }
      foundSet = false;

      while (!foundSet &&  (methodIsInCache ||
          ( (setMethods != null)
         && setMethods.hasMoreElements()
         )))
      {

         try
         {
            if (!methodIsInCache)
            {
               setMethod = (Method) setMethods.nextElement();
            }
            if (!setMethod.isAccessible())
            {
               setMethod.setAccessible (true);
            }

            setMethod.invoke (fieldObject, args);
            foundSet = true;

            if (!methodIsInCache)
            {
               addToFieldWriteMethods (this.getClass(), currentField, setMethod);
            }
         }
         catch (IllegalArgumentException argExcept)
         {
            if (setMethods == null || !setMethods.hasMoreElements())
            {
               if (log.isInfoEnabled())
               {
                  log.info ("IEA");
               }
            }
         }
         catch (IllegalAccessException accExcept)
         {
            if (setMethods == null || !setMethods.hasMoreElements())
            {
               if (log.isInfoEnabled())
               {
                  log.info ("IAE");
               }
            }
         }
         catch (InvocationTargetException invExcept)
         {
            if (setMethods == null || !setMethods.hasMoreElements())
            {
               invExcept.printStackTrace();
               if (log.isInfoEnabled())
               {
                  log.info ("ITE");
               }
            }
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
      }

      // we only have to do something, if we are out of set-methods
      if (foundSet == false)
      {
         // this attrib has no setMethod, so we must do it the direct
         // way
         try
         {
            currentField.set (fieldObject, args[0]);
         }
         catch (IllegalAccessException accExcept)
         {
            if (log.isInfoEnabled())
            {
               log.info ("ohoh");
            }
         }
      }
   }


   /**
    * Get the importPoint attribute of the GXLImport object
    *
    * @return   The importPoint value
    */
   public ASGDiagram getImportPoint()
   {
      return importPoint;
   }
}

/*
 * $Log: GXLImport.java,v $
 * Revision 1.42.2.2  2006/04/04 08:45:09  mtt
 * moved gui-code to Dialog
 *
 * Revision 1.42.2.1  2005/09/30 18:57:22  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
