/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.util.Iterator;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.uml.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.10 $
 */
public class UMLClassDiagramFilter extends Filter
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLClassDiagramFilter.class);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   public boolean verifyObject (BasicIncrement vObject)
   {
      if (vObject instanceof UMLClassDiagram)
      {
         return verifyUMLClassDiagram ((UMLClassDiagram) vObject);
      }
      else
      {
         if (vObject instanceof UMLTypeList)
         {
            return verifyUMLTypeList ((UMLTypeList) vObject);
         }
         else
         {
            if (vObject instanceof UMLAttr)
            {
               return verifyUMLAttr ((UMLAttr) vObject);
            }
            else
            {
               if (vObject instanceof UMLCardinality)
               {
                  return verifyUMLCardinality ((UMLCardinality) vObject);
               }
               else
               {
                  if (vObject instanceof UMLMethod)
                  {
                     return verifyUMLMethod ((UMLMethod) vObject);
                  }
                  else
                  {
                     if (vObject instanceof UMLFile)
                     {
                        return verifyUMLFile ((UMLFile) vObject);
                     }
                     else
                     {
                        if (vObject instanceof UMLDiagramItem)
                        {
                           return verifyUMLDiagramItem ((UMLDiagramItem) vObject);
                        }
                        else
                        {
                           if (vObject instanceof UMLPackage)
                           {
                              return verifyUMLPackage ((UMLPackage) vObject);
                           }
                           else
                           {
                              if (vObject instanceof UMLParam)
                              {
                                 return verifyUMLParam ((UMLParam) vObject);
                              }
                              else
                              {
                                 if (vObject instanceof UMLProject)
                                 {
                                    return verifyUMLProject ((UMLProject) vObject);
                                 }
                                 else
                                 {
                                    if (vObject instanceof UMLQualifier)
                                    {
                                       return verifyUMLQualifier ((UMLQualifier) vObject);
                                    }
                                    else
                                    {
                                       if (vObject instanceof UMLRole)
                                       {
                                          return verifyUMLRole ((UMLRole) vObject);
                                       }
                                       else
                                       {
                                          if (vObject instanceof UMLStereotype)
                                          {
                                             return verifyUMLStereotype ((UMLStereotype) vObject);
                                          }
                                          else
                                          {
                                             if (vObject instanceof UMLType)
                                             {
                                                return verifyUMLType ((UMLType) vObject);
                                             }

                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLClassDiagram (UMLClassDiagram vObject)
   {
      if (vObject.equals (GXLFilter.getRoot()))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLTypeList (UMLTypeList vObject)
   {
      if (UMLProject.get().equals (vObject.getProject()))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLProject (UMLProject vObject)
   {
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLDiagramItem (UMLDiagramItem vObject)
   {
      if (GXLFilter.hasInItems (vObject))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLParam (UMLParam vObject)
   {
      UMLClass tmpClass = vObject.getRevParam().getParent();

      if (GXLFilter.hasInItems (tmpClass))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLAttr (UMLAttr vObject)
   {
      UMLClass tmpClass = vObject.getParent();

      if (GXLFilter.hasInItems (tmpClass))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLMethod (UMLMethod vObject)
   {
      UMLClass tmpClass = vObject.getParent();

      if (GXLFilter.hasInItems (tmpClass))
      {
         UMLDiagram activityDiag = vObject.getStoryDiagram();
         if (activityDiag != null & GXLFilter.getInclude())
         {
            if (GXLFilter.getInclude() && GXLFilter.getFirstSelected() && !GXLFilter.hasInSavedDiagrams (activityDiag) && !GXLFilter.hasInAddDiagrams (activityDiag))
            {
               GXLFilter.addToAddDiagrams (activityDiag);
               log.error ("ADDED DIAGRAM: " + activityDiag);
            }
         }
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLType (UMLType vObject)
   {
      Iterator iter = vObject.iteratorOfRevAttrType();

      while (iter.hasNext())
      {
         UMLAttr tmpAttr = (UMLAttr) iter.next();
         UMLClass tmpClass = tmpAttr.getParent();

         if (GXLFilter.hasInItems (tmpClass))
         {
            return true;
         }
      }

      Iterator iter2 = vObject.iteratorOfRevParamType();

      while (iter2.hasNext())
      {
         UMLParam tmpParam = (UMLParam) iter2.next();
         UMLClass tmpClass = tmpParam.getRevParam().getParent();

         if (GXLFilter.hasInItems (tmpClass))
         {
            return true;
         }
      }

      Iterator iter3 = vObject.iteratorOfRevResultType();

      while (iter3.hasNext())
      {
         UMLMethod tmpMethod = (UMLMethod) iter3.next();
         UMLClass tmpClass = tmpMethod.getParent();

         if (GXLFilter.hasInItems (tmpClass))
         {
            return true;
         }
      }

      if (vObject instanceof UMLBaseTypes)
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLStereotype (UMLStereotype vObject)
   {
      Iterator iter = vObject.iteratorOfIncrements();

      while (iter.hasNext())
      {
         final Object next = iter.next();
         if (next instanceof UMLClass)
         {
            UMLClass tmpClass = (UMLClass) next;
            if (GXLFilter.hasInItems (tmpClass))
            {
               return true;
            }
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLFile (UMLFile vObject)
   {
      Iterator iter = vObject.iteratorOfContains();
      while (iter.hasNext())
      {
         UMLClass tmpClass = (UMLClass) iter.next();
         if (GXLFilter.hasInItems (tmpClass))
         {
            if (GXLFilter.getInclude() & GXLFilter.hasInRemoved (vObject.getID()))
            {
               GXLFilter.removeFromRemoved (vObject.getID());
            }
            return true;
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLPackage (UMLPackage vObject)
   {
      Iterator iter = vObject.iteratorOfDeclares();

      while (iter.hasNext())
      {
         UMLClass tmpClass = (UMLClass) iter.next();
         if (GXLFilter.hasInItems (tmpClass))
         {
            return true;
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLRole (UMLRole vObject)
   {
      UMLDiagramItem tmpAssoc = vObject.getRevLeftRole();
      UMLDiagramItem tmpClass = vObject.getRevRoles();

      if (GXLFilter.hasInItems (tmpAssoc) | GXLFilter.hasInItems (tmpClass))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLQualifier (UMLQualifier vObject)
   {
      UMLRole tmpRole = vObject.getRevQualifier();
      UMLDiagramItem tmpAssoc = tmpRole.getRevLeftRole();
      UMLDiagramItem tmpClass = tmpRole.getRevRoles();

      if (GXLFilter.hasInItems (tmpAssoc) | GXLFilter.hasInItems (tmpClass))
      {
         return true;
      }

      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLCardinality (UMLCardinality vObject)
   {
      UMLRole tmpRole = vObject.getRevCard();
      UMLDiagramItem tmpAssoc = tmpRole.getRevLeftRole();
      UMLDiagramItem tmpClass = tmpRole.getRevRoles();

      if (GXLFilter.hasInItems (tmpAssoc) | GXLFilter.hasInItems (tmpClass))
      {
         return true;
      }
      return false;
   }

}

/*
 * $Log: UMLClassDiagramFilter.java,v $
 * Revision 1.10  2004/10/22 16:41:39  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
