/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.util.*;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.fca.FHashMap;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.19 $
 */
public class UMLClassDiagramMerger extends AbstractMerger
{

   /**
    * Constructor for class UMLClassDiagramMerger
    */
   public UMLClassDiagramMerger() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param point        No description provided
    * @param actualNodes  No description provided
    * @param imp          No description provided
    */
   public void merge (ASGDiagram point, Vector actualNodes, GXLImport imp)
   {

      FHashMap objects = imp.getNodes();
      Enumeration enumeration = actualNodes.elements();
      Object[][] toSet = new Object[actualNodes.size()][2];
      int counter = 0;

      while (enumeration.hasMoreElements())
      {
         FXMLNode actualNode = (FXMLNode) enumeration.nextElement();

         String nodeName = actualNode.getType();

         if (nodeName.equals ("de.uni_paderborn.fujaba.uml.UMLBaseTypes"))
         {
            FHashMap nodeAttributes = actualNode.getAttributesAndValues();
            Vector nameVector = (Vector) nodeAttributes.get ("name");
            Iterator iter = UMLProject.get().getTypeList().iteratorOfTypes();

            while (iter.hasNext())
            {
               UMLType curType = (UMLType) iter.next();
               if (curType instanceof UMLBaseTypes)
               {
                  UMLBaseTypes tmpType = (UMLBaseTypes) curType;
                  String valueName = (String) nameVector.firstElement();

                  if (valueName.equals (tmpType.getName()))
                  {
                     objects.put (actualNode.getId(), tmpType);
                     toSet[counter][0] = tmpType;
                     toSet[counter][1] = nodeAttributes;
                     counter = counter + 1;
                     break;
                  }
               }
            }
         }
         else if (nodeName.equals ("de.uni_paderborn.fujaba.uml.UMLTypeList"))
         {
            FHashMap nodeAttributes = actualNode.getAttributesAndValues();
            Vector nameVector = (Vector) nodeAttributes.get ("types");
            Enumeration values = nameVector.elements();
            Vector def = new Vector();
            def.add ("Boolean");
            def.add ("BooleanArray");

            def.add ("Byte");
            def.add ("ByteArray");
            def.add ("Character");
            def.add ("CharacterArray");
            def.add ("Constructor");
            def.add ("Double");
            def.add ("DoubleArray");
            def.add ("Float");
            def.add ("FloatArray");
            def.add ("Initializer");
            def.add ("InitializerArray");
            def.add ("Integer");
            def.add ("IntegerArray");
            def.add ("LongInteger");
            def.add ("LongIntegerArray");
            def.add ("Object");
            def.add ("ObjectArray");
            def.add ("ShortInteger");
            def.add ("ShortIntegerArray");
            def.add ("String");
            def.add ("StringArray");
            def.add ("Void");

            while (values.hasMoreElements())
            {

               String test = (String) values.nextElement();
               int cut = test.indexOf (FileSaver.SEPARATOR);
               String name = test.substring (0, cut);
               String val = test.substring (cut + 1);

               if (!def.contains (name))
               {
                  UMLType tmpType = (UMLType) imp.getNodes().get (val);
                  if (tmpType != null)
                  {
                     UMLProject.get().getTypeList().addToTypes (tmpType);
                  }
               }

            }

            objects.put (actualNode.getId(),  (UMLProject.get()).getTypeList());
         }

      }

      for (int u = 0; u < toSet.length; u++)
      {
         if (toSet[u][0] != null)
         {
            setContainer ((FHashMap) toSet[u][1], objects, (UMLBaseTypes) toSet[u][0]);
         }
      }

   }


   /**
    * Sets the container attribute of the UMLClassDiagramMerger object
    *
    * @param nodeAttributes  The new container value
    * @param objects         The new container value
    * @param tmpType         The new container value
    */
   private void setContainer (FHashMap nodeAttributes, FHashMap objects, UMLBaseTypes tmpType)
   {
      Vector resultVector = (Vector) nodeAttributes.get ("revResultType");
      Vector paramVector = (Vector) nodeAttributes.get ("revParamType");
      Vector attrVector = (Vector) nodeAttributes.get ("revAttrType");

      if (resultVector != null)
      {
         Enumeration resultEnum = resultVector.elements();

         while (resultEnum.hasMoreElements())
         {
            String resultID = (String) resultEnum.nextElement();
            tmpType.addToRevResultType ((UMLMethod) objects.get (resultID));
         }
      }

      if (paramVector != null)
      {
         Enumeration paramEnum = paramVector.elements();

         while (paramEnum.hasMoreElements())
         {
            String paramID = (String) paramEnum.nextElement();
            tmpType.addToRevParamType ((UMLParam) objects.get (paramID));
         }
      }

      if (attrVector != null)
      {
         Enumeration attrEnum = attrVector.elements();

         while (attrEnum.hasMoreElements())
         {
            String attrID = (String) attrEnum.nextElement();
            tmpType.addToRevAttrType ((UMLAttr) objects.get (attrID));

         }
      }

   }
}

/*
 * $Log: UMLClassDiagramMerger.java,v $
 * Revision 1.19  2004/11/08 19:16:16  trinet
 * changed saving of FSAProperties, added String support for Maps in BasicIncrement, some cleanup
 *
 */
