/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.io.*;
import java.util.zip.GZIPInputStream;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;



/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.22 $
 */
public class Validator
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (Validator.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private File gxlFile = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private File[] stylesheets;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private BufferedReader input = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private StringBuffer output = null;


   /**
    * Constructor for class Validator
    *
    * @param myFile  No description provided
    */
   public Validator (File myFile)
   {
      this.gxlFile = myFile;
      //this.stylesheets = new File[1];
      //stylesheets[0] = new File (System.getProperty ("user.dir") + "/stylesheets/gxl2xml.xsl");
      //log.error ("de.uni_paderborn.fujaba.gxl.Validator::deprecated constructor was used");
   }


   /**
    * Constructor for class Validator
    *
    * @param myFile       No description provided
    * @param stylesheets  No description provided
    */
   public Validator (File myFile, File[] stylesheets)
   {
      this.gxlFile = myFile;
      this.stylesheets = stylesheets;
   }


   /**
    * UMLMethod: '+ valid (): Boolean'.
    *
    * @return   No description provided
    */
   public boolean valid()
   { //throws FileNotFoundException

      if (this.gxlFile != null)
      {
         return this.valid (gxlFile);
      }
      //throw new FileNotFoundException("No file specified.");
      return false;
   }


   /**
    * UMLMethod: '+ valid (candidate: File): Boolean'.
    *
    * @param candidate  No description provided
    * @return           No description provided
    */
   public boolean valid (File candidate)
   {
      try
      {
         // we assume that file is gziped
         try
         {
            input = new BufferedReader (new InputStreamReader (new GZIPInputStream (new FileInputStream (candidate))));
         }
         catch (Exception gz)
         { // or not

            input = new BufferedReader (new InputStreamReader (new FileInputStream (candidate)));
         }
         output = new StringBuffer();

         // check, weather candidate contains a valid gxl file or not
         SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
         parser.parse (new InputSource (input), new GXLHandler());
         input.close();

         log.error (output.substring (0));

         if (output.capacity() > 16)
         {
            throw new Exception (output.capacity() + " " + output.substring (0));
         }
         else
         {
            return true;
         }
      }
      catch (Exception e)
      {
         log.error (e);
         e.printStackTrace();
         return false;
      }
   }


   /**
    * UMLMethod: '+ getDOMTree (): FXMLTree'.
    *
    * @return   The dOMTree value
    */
   public FXMLTree getDOMTree()
   { //throws FileNotFoundException

      if (this.gxlFile != null)
      {
         return this.getDOMTree (gxlFile);
      }
      return null;
      //throw new FileNotFoundException("No file specified.");
   }


   /**
    * UMLMethod: '+ getDOMTree (candidate: File): FXMLTree'.
    *
    * @param candidate  No description provided
    * @return           The dOMTree value
    */
   public FXMLTree getDOMTree (File candidate)
   {
      try
      {
         Document xmlFormat = null;
         if (stylesheets != null && stylesheets.length > 1)
         {
            xmlFormat = XSLTransformer.transform (candidate, stylesheets[0]);

            for (int idx = 1; idx < stylesheets.length; idx++)
            {
               xmlFormat = XSLTransformer.transform (xmlFormat, stylesheets[idx]);
            }
         }
         else
         { //no stylesheet specified

            xmlFormat = XSLTransformer.transform (candidate);
         }

         FXMLTree root = new FXMLTree (xmlFormat.getDocumentElement());
         return root;
      }
      catch (Exception e)
      {
         log.error (e);
         e.printStackTrace();
         return null;
      }
   } // getDOMTree
}

/*
 * $Log: Validator.java,v $
 * Revision 1.22  2004/10/20 17:49:58  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
