/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.io.*;
import java.util.*;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;

import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.*;
import org.xml.sax.InputSource;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.21.2.1 $
 */
public class XSLTransformer
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (XSLTransformer.class);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static TransformerFactory tFactory = TransformerFactory.newInstance();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static Transformer transformer;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static BufferedReader in;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static BufferedWriter out;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param from                                No description provided
    * @param how                                 No description provided
    * @return                                    No description provided
    * @throws TransformerException               Exception description not provided
    * @throws TransformerConfigurationException  Exception description not provided
    * @throws FileNotFoundException              Exception description not provided
    * @throws IOException                        Exception description not provided
    */
   public static Document transform (File from, File how) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException
   {
      transformer = tFactory.newTransformer (new StreamSource (how));

      try
      {
         in = new BufferedReader (new InputStreamReader (new GZIPInputStream (new FileInputStream (from))));
      }
      catch (IOException e)
      {
         in = new BufferedReader (new FileReader (from));
      }

      try
      {
         String s;
         String out = "";

         while (in.ready())
         {
            s = in.readLine();

            if (s.startsWith ("<XMI "))
            {
               s = "<XMI xmi.version = '1.1' xmlns:UML='http://www.omg.org/uml/1.3'>\n";
            }
            out += s + "\n";
         }

         // InputSource src = new InputSource (in);
         InputSource src = new InputSource (new StringReader (out));

         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
         factory.setValidating (true);
         factory.setNamespaceAware (true);

         DocumentBuilder builder = factory.newDocumentBuilder();

         GXLHandler handler = new GXLHandler();
         builder.setEntityResolver (handler);
         builder.setErrorHandler (handler);

         Document doc = builder.parse (src);
         Source source = new DOMSource (doc);
         DOMResult result = new DOMResult();
         transformer.transform (source, result);
         Document resultDoc = (Document) result.getNode();

         checkDocType (resultDoc,
            transformer.getOutputProperty (OutputKeys.DOCTYPE_PUBLIC),
            transformer.getOutputProperty (OutputKeys.DOCTYPE_SYSTEM));

         return resultDoc;
      }
      catch (Exception e)
      {
         e.printStackTrace();
         return null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param from                                No description provided
    * @return                                    No description provided
    * @throws TransformerException               Exception description not provided
    * @throws TransformerConfigurationException  Exception description not provided
    * @throws FileNotFoundException              Exception description not provided
    * @throws IOException                        Exception description not provided
    */
   public static Document transform (File from) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException
   {
      //if no stylesheet is specified
      transformer = tFactory.newTransformer();

      try
      {
         in = new BufferedReader (new InputStreamReader (new GZIPInputStream (new FileInputStream (from))));
      }
      catch (IOException e)
      {
         in = new BufferedReader (new FileReader (from));
      }

      try
      {
         // InputSource src = new InputSource (in);
         InputSource src = new InputSource (in);

         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
         factory.setValidating (true);
         factory.setNamespaceAware (true);

         DocumentBuilder builder = factory.newDocumentBuilder();

         GXLHandler handler = new GXLHandler();
         builder.setEntityResolver (handler);
         builder.setErrorHandler (handler);

         Document doc = builder.parse (src);

         Source source = new DOMSource (doc);
         DOMResult result = new DOMResult();
         transformer.transform (source, result);
         Document resultDoc = (Document) result.getNode();

         checkDocType (resultDoc,
            transformer.getOutputProperty (OutputKeys.DOCTYPE_PUBLIC),
            transformer.getOutputProperty (OutputKeys.DOCTYPE_SYSTEM));

         return resultDoc;
      }
      catch (Exception e)
      {
         e.printStackTrace();
         return null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param from                                No description provided
    * @param to                                  No description provided
    * @param how                                 No description provided
    * @throws TransformerException               Exception description not provided
    * @throws TransformerConfigurationException  Exception description not provided
    * @throws FileNotFoundException              Exception description not provided
    * @throws IOException                        Exception description not provided
    */
   public static void transform (File from, File to, File how) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException
   {
      transformer = tFactory.newTransformer (new StreamSource (how));

      if (to.getName().endsWith (".gz"))
      {
         out = new BufferedWriter (new OutputStreamWriter (new GZIPOutputStream (new FileOutputStream (to))));
      }
      else
      {
         out = new BufferedWriter (new OutputStreamWriter (new FileOutputStream (to)));
      }

      try
      {
         in = new BufferedReader (new InputStreamReader (new GZIPInputStream (new FileInputStream (from))));
      }
      catch (IOException e)
      {
         in = new BufferedReader (new FileReader (from));
      }

      try
      {
         InputSource src = new InputSource (in);

         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
         factory.setValidating (true);
         factory.setNamespaceAware (true);

         DocumentBuilder builder = factory.newDocumentBuilder();
         GXLHandler handler = new GXLHandler();
         builder.setEntityResolver (handler);
         builder.setErrorHandler (handler);

         Document doc = builder.parse (src);

         Source source = new DOMSource (doc);

         DOMResult result = new DOMResult();

         transformer.transform (source, result);

         Document outDoc = (Document) result.getNode();

         checkDocType (outDoc,
            transformer.getOutputProperty (OutputKeys.DOCTYPE_PUBLIC),
            transformer.getOutputProperty (OutputKeys.DOCTYPE_SYSTEM));

         OutputFormat format = new OutputFormat (outDoc, null, true);

         XMLSerializer serializer = new XMLSerializer (out, format);

         serializer.serialize (outDoc);

         out.close();
      }
      catch (Exception e)
      {
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param from                                No description provided
    * @param how                                 No description provided
    * @return                                    No description provided
    * @throws TransformerException               Exception description not provided
    * @throws TransformerConfigurationException  Exception description not provided
    */
   public static Document transform (Document from, File how) throws TransformerException, TransformerConfigurationException
   {
      transformer = tFactory.newTransformer (new StreamSource (how));

      Properties prop = transformer.getOutputProperties();

      Iterator iter = prop.entrySet().iterator();

      if (!iter.hasNext())
      {
         if (log.isInfoEnabled())
         {
            log.info ("No properties!");
         }
      }

      while (iter.hasNext())
      {
         Map.Entry entry = (Map.Entry) iter.next();
         if (log.isInfoEnabled())
         {
            log.info ("Property: '" + entry.getKey() + "'(" + entry.getKey().getClass().getName() + "):='" + entry.getValue() + "'(" + entry.getValue().getClass().getName() + ")");
         }
      }

      try
      {
         DOMSource source = new DOMSource (from);
         DOMResult result = new DOMResult();
         transformer.transform (source, result);
         Document resultDoc = (Document) result.getNode();

         checkDocType (resultDoc,
            transformer.getOutputProperty (OutputKeys.DOCTYPE_PUBLIC),
            transformer.getOutputProperty (OutputKeys.DOCTYPE_SYSTEM));

         return resultDoc;
      }
      catch (Exception e)
      {
         return null;
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param from                                No description provided
    * @param to                                  No description provided
    * @param how                                 No description provided
    * @throws TransformerException               Exception description not provided
    * @throws TransformerConfigurationException  Exception description not provided
    * @throws FileNotFoundException              Exception description not provided
    * @throws IOException                        Exception description not provided
    */
   public static void transform (Document from, File to, File how) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException
   {
      transformer = tFactory.newTransformer (new StreamSource (how));

      if (to.getName().endsWith (".gz"))
      {
         out = new BufferedWriter (new OutputStreamWriter (new GZIPOutputStream (new FileOutputStream (to))));
      }
      else
      {
         out = new BufferedWriter (new OutputStreamWriter (new FileOutputStream (to)));
      }

      try
      {
         Source source = new DOMSource (from);
         DOMResult result = new DOMResult();

         transformer.transform (source, result);

         Document doc = (Document) result.getNode();

         checkDocType (doc,
            transformer.getOutputProperty (OutputKeys.DOCTYPE_PUBLIC),
            transformer.getOutputProperty (OutputKeys.DOCTYPE_SYSTEM));

         OutputFormat format = new OutputFormat (doc, null, true);

         XMLSerializer serializer = new XMLSerializer (out, format);

         serializer.serialize (doc);
         out.close();
      }
      catch (Exception e)
      {
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param from                                No description provided
    * @param to                                  No description provided
    * @throws TransformerException               Exception description not provided
    * @throws TransformerConfigurationException  Exception description not provided
    * @throws FileNotFoundException              Exception description not provided
    * @throws IOException                        Exception description not provided
    */
   public static void transformWithoutStylesheet (Document from, File to) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException
   {
      transformer = tFactory.newTransformer();

      if (to.getName().endsWith (".gz"))
      {
         out = new BufferedWriter (new OutputStreamWriter (new GZIPOutputStream (new FileOutputStream (to))));
      }
      else
      {
         out = new BufferedWriter (new OutputStreamWriter (new FileOutputStream (to)));
      }
      try
      {

         Source source = new DOMSource (from);
         DOMResult result = new DOMResult();
         transformer.transform (source, result);
         Document doc = (Document) result.getNode();
         checkDocType (doc,
            transformer.getOutputProperty (OutputKeys.DOCTYPE_PUBLIC),
            transformer.getOutputProperty (OutputKeys.DOCTYPE_SYSTEM));
         OutputFormat format = new OutputFormat (doc, null, true);
         XMLSerializer serializer = new XMLSerializer (out, format);
         serializer.serialize (doc);
         out.close();
      }
      catch (Exception e)
      {
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param doc            No description provided
    * @param publicId       No description provided
    * @param systemId       No description provided
    * @throws DOMException  Exception description not provided
    */
   public static void checkDocType (Document doc, String publicId, String systemId) throws DOMException
   {

      if (doc.getDoctype() == null &&  (publicId != null || systemId != null))
      {

         if (doc instanceof DocumentImpl)
         {
            if (log.isInfoEnabled())
            {
               log.info ("Change Doc type to " + publicId + ":" + systemId);
            }
            DocumentImpl docImpl = (DocumentImpl) doc;
            Element root = docImpl.getDocumentElement();
            DocumentType docType = docImpl.createDocumentType (root.getTagName(), publicId, systemId);
            docImpl.appendChild (docType);
         }
         else
         {
            throw new DOMException ((short) 0, "Not an instance of DocumentImpl");
         }
      }
   }
}

/*
 * $Log: XSLTransformer.java,v $
 * Revision 1.21.2.1  2005/09/30 18:57:22  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
