/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.layout.classdiag;

import java.awt.Point;
import java.util.Iterator;

//import com.sun.rsasign.o;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.actions.AddBendAction;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.layout.classdiag.internalmodel.LayoutedEdge;


/**
 * This class is an abstract implementation of all edges which are layoutable in
 * the classdiagram. The class has been taken from Argo UML source code.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.3 $ $Date: 2005/01/28 11:36:28 $
 */
public abstract class ClassdiagramEdge implements LayoutedEdge
{

   /**
    * the layout is oriented on a grid. These are our grid spaces.
    */
   private static int vGap;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static int hGap;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FSABendLine currentEdge = null;

   /**
    * the underlying fig of the edge we want to layout
    */
   private FSAPolyLine underlyingFig = null;

   /**
    * each fig has a source and a destination port
    */
   private FSAObject destFigNode;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FSAObject sourceFigNode;


   /**
    * Constructor.
    *
    * @param edge  the Edge to layout
    */
   public ClassdiagramEdge (FSABendLine edge)
   {
      currentEdge = edge;
      underlyingFig = (FSAPolyLine) edge;

      destFigNode =  ((FSAGrab) edge.getStartBend()).getTarget();
      sourceFigNode =  ((FSAGrab) edge.getEndBend()).getTarget();

      // remove all bends, but the start and end grab

      FSABend start = edge.getStartBend();
      FSABend end = edge.getEndBend();

      LogicUnparseInterface lui = edge.getLogic();

      Iterator bendIter = lui.getFSAInterface().iteratorOfFsaObjects();
      while (bendIter.hasNext())
      {
         Object obj = bendIter.next();

         if (obj instanceof FSABend)
         {
            FSABend bend = (FSABend) obj;
            if (bend != start && bend != end)
            {
               bend.removeYou();
            }
         }
      }
   }


   /**
    * Abstract method to layout the edge.
    */
   public abstract void layout();


   /**
    * @param h  the horizontal gap
    */
   public static void setHGap (int h)
   {
      hGap = h;
   }


   /**
    * @param v  the vertical gap
    */
   public static void setVGap (int v)
   {
      vGap = v;
   }


   /**
    * @return   the horizontal gap
    */
   public static int getHGap()
   {
      return hGap;
   }


   /**
    * @return   the vertical gap
    */
   public static int getVGap()
   {
      return vGap;
   }


   /**
    * @return   Returns the destFigNode.
    */
   FSAObject getDestFigNode()
   {
      return destFigNode;
   }


   /**
    * @return   Returns the sourceFigNode.
    */
   FSAObject getSourceFigNode()
   {
      return sourceFigNode;
   }


   /**
    * @return   Returns the currentEdge.
    */
   protected FSABendLine getCurrentEdge()
   {
      return currentEdge;
   }


   /**
    * @return   Returns the underlyingFig.
    */
   protected FSAPolyLine getUnderlyingFig()
   {
      return underlyingFig;
   }


   /**
    * Adds a bend to the line.
    *
    * @param x  location
    * @param y
    */
   protected void addPoint (int x, int y)
   {
      FSAPolyLine selectedLine = getUnderlyingFig();
      JPolyLine polyLine = (JPolyLine) selectedLine.getJComponent();

      Point cursorPosition = new Point (x, y);
      //cursorPosition.translate (polyLine.getX(), polyLine.getY());
      FSABend bend = AddBendAction.newBend (selectedLine, cursorPosition);
      // TODO: check if the new bend has to be selected
      //		if it doesn't, remove this call!
      SelectionManager.get().setSelected (bend, true, true);

      // always insert the point as last bend
      polyLine.insertInBends (1
      /*
       *  polyLine.sizeOfBends() - 1
       */
         , (JBend) bend.getJComponent());

   }

}

/*
 * $Log: ClassdiagramEdge.java,v $
 * Revision 1.3  2005/01/28 11:36:28  lowende
 * Removed some compile warnings.
 *
 */
