/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.layout.classdiag.internalmodel;

import java.awt.*;


/**
 * LayoutHelper is a utility class which mainly returns various types of routing
 * polygons for different kind of connection lines between two nodes. Specific
 * layouters might use these methods to reuse certain kinds of diagram lines.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $ $Date: 2005/03/23 15:57:40 $
 *
 * The class has been taken from Argo UML source code.
 */
public class LayoutHelper
{

   /**
    * A constant bitmask for a direction.
    */
   public final static int NORTH = 0;

   /**
    * A constant bitmask for a direction.
    */
   public final static int NORTHEAST = 1;

   /**
    * A constant bitmask for a direction.
    */
   public final static int EAST = 2;

   /**
    * A constant bitmask for a direction.
    */
   public final static int SOUTHEAST = 4;

   /**
    * A constant bitmask for a direction.
    */
   public final static int SOUTH = 8;

   /**
    * A constant bitmask for a direction.
    */
   public final static int SOUTHWEST = 16;

   /**
    * A constant bitmask for a direction.
    */
   public final static int WEST = 32;

   /**
    * A constant bitmask for a direction.
    */
   public final static int NORTHWEST = 64;


   /**
    * @param rect       the rectangle
    * @param direction  the direction
    * @return           the point on the perimeter
    */
   public static Point getPointOnPerimeter (Rectangle rect, int direction)
   {
      return getPointOnPerimeter (rect, direction, 0, 0);
   }


   /**
    * @param rect       the rectangle
    * @param direction  the direction
    * @param xOff       the x offset
    * @param yOff       the y offset
    * @return           the point on the perimeter
    */
   public static Point getPointOnPerimeter (Rectangle rect, int direction, double xOff, double yOff)
   {
      double x = 0;
      double y = 0;
      if (direction == NORTH || direction == NORTHEAST || direction == NORTHWEST)
      {
         y = rect.getY();
      }
      if (direction == SOUTH || direction == SOUTHWEST || direction == SOUTHEAST)
      {
         y = rect.getY() + rect.getHeight();
      }
      if (direction == EAST || direction == WEST)
      {
         y = rect.getY() + rect.getHeight() / 2.0;
      }
      if (direction == NORTHWEST || direction == WEST || direction == SOUTHWEST)
      {
         x = rect.getX();
      }
      if (direction == NORTHEAST || direction == EAST || direction == SOUTHEAST)
      {
         x = rect.getX() + rect.getWidth();
      }
      if (direction == NORTH || direction == SOUTH)
      {
         x = rect.getX() + rect.getWidth() / 2.0;
      }

      x += xOff;
      y += yOff;
      return new Point ((int) x, (int) y);
   }


   /**
    * Get a routing polygon for a straightline between two points.
    *
    * @param start  start of the line
    * @param end    end of the line
    * @return       the routing polygon between start and end
    */
   public static Polygon getRoutingPolygonStraightLine (Point start, Point end)
   {
      return getRoutingPolygonStraightLineWithOffset (start, end, 0);
   }


   /**
    * Get a routing polygon with a horizontal offset from the two points.
    *
    * @param start   start of the line
    * @param end     end of the line
    * @param offset  the given offset
    * @return        the routing polygon between start and end
    */
   public static Polygon getRoutingPolygonStraightLineWithOffset (Point start, Point end, int offset)
   {
      Polygon newPoly = new Polygon();

      newPoly.addPoint ((int) start.getX(), (int) start.getY());
      if (offset != 0)
      {
         double newY = 0.0;
         if (offset < 0)
         {
            newY = Math.min (start.getY() + offset, end.getY() + offset);
         }
         if (offset > 0)
         {
            newY = Math.max (start.getY() + offset, end.getY() + offset);
         }
         newPoly.addPoint ((int) start.getX(), (int) newY);
         newPoly.addPoint ((int) end.getX(), (int) newY);

      }
      newPoly.addPoint ((int) end.getX(), (int) end.getY());
      return newPoly;
   }

}

/*
 * $Log: LayoutHelper.java,v $
 * Revision 1.2  2005/03/23 15:57:40  lowende
 * Javadoc warnings removed.
 *
 */
