/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.messages;

import java.awt.Component;
import java.awt.event.*;
import java.text.DateFormat;
import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.upb.tools.fca.*;


/**
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.2.2.2 $ $Date: 2005/12/20 13:25:21 $
 */
public class MessageView
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int COLUMN_ICON = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int COLUMN_TEXT = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int COLUMN_PACKAGE = 2;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int COLUMN_CATEGORY = 3;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int COLUMN_TIME = 4;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   final static String[] COLUMN_NAMES = new String[]{"", "Message", "Path", "Category", "Time"};
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   final static Class[] COLUMN_CLASSES = new Class[]{Icon.class, String.class, String.class, String.class, String.class};
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int[] CLOUMN_WIDTHS = new int[]{25, -1, 120, 80, 40};

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int IMAGE_SIZE = 16;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Runnable notifyRunnable;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int MAX_PREFERRED_WIDTH = 1000;


   /**
    *Constructor for class MessageView
    *
    * @param title  No description provided
    */
   public MessageView (String title)
   {
      init();
      this.title = title;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String title;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTable table;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   MessageModel model;


   /**
    * Get the title attribute of the MessageView object
    *
    * @return   The title value
    */
   public String getTitle()
   {
      return title;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Set tableModelListeners;


   /**
    * Access method for a To N-association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   boolean addToTableModelListeners (TableModelListener value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.tableModelListeners == null)
         {
            this.tableModelListeners = new FHashSet();
         }
         changed = this.tableModelListeners.add (value);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   Iterator iteratorOfTableModelListeners()
   {
      if (this.tableModelListeners == null)
      {
         return FEmptyIterator.get();
      }
      else
      {
         return this.tableModelListeners.iterator();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   boolean removeFromTableModelListeners (TableModelListener value)
   {
      boolean changed = false;
      if ( (this.tableModelListeners != null) &&  (value != null))
      {
         changed = this.tableModelListeners.remove (value);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private List messages;


   /**
    * Access method for a To N-association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToMessages (Message value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.messages == null)
         {
            this.messages = new FLinkedList();
         }
         this.messages.add (0, value);

         if (messageListeners != null)
         {
            for (Iterator it = messageListeners.iterator(); it.hasNext(); )
            {
               MessageListener ml = (MessageListener) it.next();
               ml.handle (value);
            }
         }

         value.setMessageView (this);
         notifyModelChange();
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private List messageListeners;


   /**
    * Access method for a To N-association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToMessageListeners (MessageListener value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.messageListeners == null)
         {
            this.messageListeners = new FLinkedList();
         }
         this.messageListeners.add (0, value);
      }
      return changed;
   }


   /**
    * removes a messagelistener from the list of messagelisteners
    *
    * @param value  messagelistener to remove
    * @return       true if removed
    */
   public boolean removeFromMessageListeners (MessageListener value)
   {
      boolean changed = false;
      if ( (this.messageListeners != null) &&  (value != null))
      {
         changed = this.messageListeners.remove (value);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void notifyModelChange()
   {
      if (notifyRunnable == null)
      {
         notifyRunnable =
            new Runnable()
            {
               public void run()
               {
                  notifyRunnable = null;
                  for (Iterator it = iteratorOfTableModelListeners(); it.hasNext(); )
                  {
                     TableModelListener listener = (TableModelListener) it.next();
                     listener.tableChanged (new TableModelEvent (model));
                  }
                  getComponent().repaint();
               }
            };
         SwingUtilities.invokeLater (notifyRunnable);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInMessages (Message value)
   {
      return  ( (this.messages != null) &&
          (value != null) &&
         this.messages.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfMessages()
   {
      if (this.messages == null)
      {
         return FEmptyIterator.get();
      }
      else
      {
         return this.messages.iterator();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromMessages()
   {
      Message tmpValue;
      Iterator iter = this.iteratorOfMessages();
      while (iter.hasNext())
      {
         tmpValue = (Message) iter.next();
         this.removeFromMessages (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param messageClass  No description provided
    */
   public void deleteMessages (String messageClass)
   {
      Message tmpValue;
      Iterator iter = this.iteratorOfMessages();
      while (iter.hasNext())
      {
         tmpValue = (Message) iter.next();
         if ( (messageClass == null && tmpValue.getMessageCategory() == null) ||
             (messageClass != null && messageClass.equals (tmpValue.getMessageCategory())))
         {
            tmpValue.removeYou();
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromMessages (Message value)
   {
      boolean changed = false;
      if ( (this.messages != null) &&  (value != null))
      {
         changed = this.messages.remove (value);
         if (changed)
         {
            value.setMessageView (null);
            notifyModelChange();
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfMessages()
   {
      return  ( (this.messages == null)
         ? 0
         : this.messages.size());
   }


   /**
    * Get the fromMessages attribute of the MessageView object
    *
    * @param index  No description provided
    * @return       The fromMessages value
    */
   public Message getFromMessages (int index)
   {
      if (messages == null || index < 0 || index >= messages.size())
      {
         return null;
      }
      else
      {
         return (Message) messages.get (index);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.2.2.2 $ $Date: 2005/12/20 13:25:21 $
    */
   private class MessageModel implements TableModel
   {
      /**
       * Returns the most specific superclass for all the cell values
       * in the column.  This is used by the <code>JTable</code> to set up a
       * default renderer and editor for the column.
       *
       * @param columnIndex  the index of the column
       * @return             the common ancestor class of the object values in the model.
       */
      public Class getColumnClass (int columnIndex)
      {
         return COLUMN_CLASSES[columnIndex];
      }


      /**
       * Returns the number of columns in the model. A
       * <code>JTable</code> uses this method to determine how many columns it
       * should create and display by default.
       *
       * @return   the number of columns in the model
       * @see      #getRowCount
       */
      public int getColumnCount()
      {
         return COLUMN_NAMES.length;
      }


      /**
       * Returns the name of the column at <code>columnIndex</code>.  This is used
       * to initialize the table's column header name.  Note: this name does
       * not need to be unique; two columns in a table can have the same name.
       *
       * @param columnIndex  the index of the column
       * @return             the name of the column
       */
      public String getColumnName (int columnIndex)
      {
         return COLUMN_NAMES[columnIndex];
      }


      /**
       * Returns the number of rows in the model. A
       * <code>JTable</code> uses this method to determine how many rows it
       * should display.  This method should be quick, as it
       * is called frequently during rendering.
       *
       * @return   the number of rows in the model
       * @see      #getColumnCount
       */
      public int getRowCount()
      {
         return sizeOfMessages();
      }


      /**
       * Returns the value for the cell at <code>columnIndex</code> and
       * <code>rowIndex</code>.
       *
       * @param rowIndex     the row whose value is to be queried
       * @param columnIndex  the column whose value is to be queried
       * @return             the value Object at the specified cell
       */
      public Object getValueAt (int rowIndex, int columnIndex)
      {
         Message message = getFromMessages (rowIndex);
         switch (columnIndex)
         {
            case COLUMN_ICON:
               return message.getIcon();
            case COLUMN_TEXT:
               return message.getText();
            case COLUMN_PACKAGE:
               return message.getPath();
            case COLUMN_CATEGORY:
               return message.getMessageCategory();
            case COLUMN_TIME:
               return DateFormat.getTimeInstance (DateFormat.SHORT).format (new Date (message.getTime()));
            default:
               return "";
         }
      }


      /**
       * Returns true if the cell at <code>rowIndex</code> and
       * <code>columnIndex</code>
       * is editable.  Otherwise, <code>setValueAt</code> on the cell will not
       * change the value of that cell.
       *
       * @param rowIndex     the row whose value to be queried
       * @param columnIndex  the column whose value to be queried
       * @return             true if the cell is editable
       * @see                #setValueAt
       */
      public boolean isCellEditable (int rowIndex, int columnIndex)
      {
         return false;
      }


      /**
       * Adds a listener to the list that is notified each time a change
       * to the data model occurs.
       *
       * @param l  the TableModelListener
       */
      public void addTableModelListener (TableModelListener l)
      {
         addToTableModelListeners (l);
      }


      /**
       * Removes a listener from the list that is notified each time a
       * change to the data model occurs.
       *
       * @param l  the TableModelListener
       */
      public void removeTableModelListener (TableModelListener l)
      {
         removeFromTableModelListeners (l);
      }


      /**
       * Sets the value in the cell at <code>columnIndex</code> and
       * <code>rowIndex</code> to <code>aValue</code>.
       *
       * @param aValue       the new value
       * @param rowIndex     the row whose value is to be changed
       * @param columnIndex  the column whose value is to be changed
       * @see                #getValueAt
       * @see                #isCellEditable
       */
      public void setValueAt (Object aValue, int rowIndex, int columnIndex)
      {
         throw new UnsupportedOperationException();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void init()
   {
      model = new MessageModel();
      table =
         new JTable (model)
         {
            /**
             * Returns the cell renderer to be used when no renderer has been set in
             * a <code>TableColumn</code>.
             *
             * @param columnClass  No description provided
             * @return             The defaultRenderer value
             */
            public TableCellRenderer getDefaultRenderer (Class columnClass)
            {
               if (Icon.class.equals (columnClass))
               {
                  return
                     new TableCellRenderer()
                     {
                        private JLabel label = new JLabel();


                        public Component getTableCellRendererComponent (JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
                        {
                           if (value instanceof Icon)
                           {
                              label.setIcon ((Icon) value);
                           }
                           else
                           {
                              label.setText (String.valueOf (value));
                           }
                           return label;
                        }
                     };
               }
               else
               {
                  return super.getDefaultRenderer (columnClass);
               }
            }
         };
      component = new JScrollPane (table);
      table.getSelectionModel().addListSelectionListener (
         new ListSelectionListener()
         {
            public void valueChanged (ListSelectionEvent e)
            {
               Message message = getFromMessages (table.getSelectedRow());
               if (message != null)
               {
                  Action defaultAction = message.getDefaultAction();
                  if (defaultAction != null)
                  {
                     defaultAction.actionPerformed (new ActionEvent (table, 0, null));
                  }
               }
            }
         });
      table.doLayout();
      for (int i = 0; i < CLOUMN_WIDTHS.length; i++)
      {
         int columnWidth = CLOUMN_WIDTHS[i];
         if (columnWidth >= 0)
         {
            table.getColumnModel().getColumn (i).setPreferredWidth (columnWidth);
         }
         else
         {
            table.getColumnModel().getColumn (i).setPreferredWidth (MAX_PREFERRED_WIDTH);
         }
      }
      table.doLayout();
      table.setAutoResizeMode (JTable.AUTO_RESIZE_NEXT_COLUMN);

      if (table.getRowHeight() < IMAGE_SIZE + 2)
      {
         table.setRowHeight (IMAGE_SIZE + 2);
      }
      table.setGridColor (table.getBackground());

      table.getTableHeader().addMouseListener (mouseListener);
      table.addMouseListener (mouseListener);
      table.getSelectionModel().setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
      table.addKeyListener (keyListener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private KeyAdapter keyListener =
      new KeyAdapter()
      {
         /**
          * Invoked when a key has been released.
          *
          * @param e  No description provided
          */
         public void keyReleased (KeyEvent e)
         {
            if (e.getKeyCode() == KeyEvent.VK_DELETE)
            {
               for (Iterator it = iteratorOfSelectedMessages(); it.hasNext(); )
               {
                  Message message = (Message) it.next();
                  message.removeYou();
               }
            }
         }
      };


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfSelectedMessages()
   {
      int index = 0;
      List selectedMessages = new Vector();
      for (Iterator it = iteratorOfMessages(); it.hasNext(); )
      {
         Message message = (Message) it.next();
         if (table.isRowSelected (index++))
         {
            selectedMessages.add (message);
         }
      }
      return selectedMessages.iterator();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int lastClickedColumn = -1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int lastClickedRow = -1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private MouseListener mouseListener =
      new MouseAdapter()
      {
         int lastSortedColumn = -1;


         private void updateLastClicked (MouseEvent e)
         {
            if (e.getSource() instanceof JTableHeader)
            {
               JTableHeader header = (JTableHeader) e.getSource();
               lastClickedRow = -1;
               lastClickedColumn = header.columnAtPoint (e.getPoint());
            }
            else if (e.getSource() instanceof JTable)
            {
               JTable table = (JTable) e.getSource();
               lastClickedRow = table.rowAtPoint (e.getPoint());
               lastClickedColumn = table.columnAtPoint (e.getPoint());
            }
         }


         public void mouseClicked (MouseEvent e)
         {
            updateLastClicked (e);
            if (!e.isPopupTrigger())
            {
               if (e.getSource() instanceof JTableHeader)
               {
                  if (lastSortedColumn == lastClickedColumn)
                  {
                     sortBy (lastClickedColumn, true);
                     lastSortedColumn = -1;
                  }
                  else
                  {
                     sortBy (lastClickedColumn, false);
                     lastSortedColumn = lastClickedColumn;
                  }
               }
            }
            else
            {
               showPopup (e);
            }
         }


         /**
          * Invoked when a mouse button has been pressed on a component.
          *
          * @param e  No description provided
          */
         public void mousePressed (MouseEvent e)
         {
            updateLastClicked (e);
            if (e.isPopupTrigger())
            {
               showPopup (e);
            }
         }


         /**
          * Invoked when a mouse button has been released on a component.
          *
          * @param e  No description provided
          */
         public void mouseReleased (MouseEvent e)
         {
            updateLastClicked (e);
            if (e.isPopupTrigger())
            {
               showPopup (e);
            }
         }
      };

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JPopupMenu headerPopupMenu;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private AbstractAction hideMessageViewAction =
      new AbstractAction ("Hide message view")
      {
         /**
          * Invoked when an action occurs.
          *
          * @param e  No description provided
          */
         public void actionPerformed (ActionEvent e)
         {
            FrameMain.get().hideMessageView();
         }
      };

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private AbstractAction deleteMessageAction =
      new AbstractAction ("Delete message")
      {
         /**
          * Invoked when an action occurs.
          *
          * @param e  No description provided
          */
         public void actionPerformed (ActionEvent e)
         {
            Message message = getFromMessages (lastClickedRow);
            if (message != null)
            {
               message.removeYou();
            }
         }
      };

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private AbstractAction deleteMessageCategoryAction =
      new AbstractAction ("Delete all from message category")
      {
         /**
          * Invoked when an action occurs.
          *
          * @param e  No description provided
          */
         public void actionPerformed (ActionEvent e)
         {
            Message message = getFromMessages (lastClickedRow);
            if (message != null)
            {
               deleteMessages (message.getMessageCategory());
            }
         }
      };


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void showPopup (MouseEvent e)
   {
      if (headerPopupMenu == null)
      {
         //todo: get this popup menus from xml
         headerPopupMenu = new JPopupMenu();
         headerPopupMenu.add (new JMenuItem (hideMessageViewAction));
      }

      Component component = (Component) e.getSource();
      if (component instanceof JTableHeader)
      {
         headerPopupMenu.show (component, e.getX(), e.getY());
      }
      else
      {
         JPopupMenu popupMenu = new JPopupMenu();

         popupMenu.add (new JMenuItem (hideMessageViewAction));

         popupMenu.add (new JSeparator());

         popupMenu.add (new JMenuItem (deleteMessageAction));
         popupMenu.add (new JMenuItem (deleteMessageCategoryAction));

         Message message = getFromMessages (lastClickedRow);
         if (message != null)
         {
            Iterator actionIterator = message.iteratorOfActions();
            if (actionIterator.hasNext())
            {
               popupMenu.add (new JSeparator());
            }
            while (actionIterator.hasNext())
            {
               Action action = (Action) actionIterator.next();
               popupMenu.add (new JMenuItem (action));
            }
         }

         popupMenu.show (component, e.getX(), e.getY());
      }
   }


   /**
    * Sort messages by a specified column.
    *
    * @param column     which column to be sorted by
    * @param ascending  true to sort in ascending order, false for descending
    */
   public void sortBy (int column, final boolean ascending)
   {
      //todo: this is only neccessary because the stupid FLinkedList does not support sort!
      //FIX ME: use ConcurrentLinkedList from util when Java 1.5 may be used
      Vector messages = new Vector (this.messages);
      switch (column)
      {
         case COLUMN_ICON:
            Collections.sort (messages,
               new Comparator()
               {
                  public int compare (Object o1, Object o2)
                  {
                     Message msg1 = (Message) o1;
                     Message msg2 = (Message) o2;
                     return compareStrings (msg1.getClass().getName(), msg2.getClass().getName(), ascending);
                  }
               });
            break;
         case COLUMN_TEXT:
            Collections.sort (messages,
               new Comparator()
               {
                  public int compare (Object o1, Object o2)
                  {
                     Message msg1 = (Message) o1;
                     Message msg2 = (Message) o2;
                     return compareStrings (msg1.getText(), msg2.getText(), ascending);
                  }
               });
            break;
         case COLUMN_PACKAGE:
            Collections.sort (messages,
               new Comparator()
               {
                  public int compare (Object o1, Object o2)
                  {
                     Message msg1 = (Message) o1;
                     Message msg2 = (Message) o2;
                     return compareStrings (msg1.getPath(), msg2.getPath(), ascending);
                  }
               });
            break;
         case COLUMN_CATEGORY:
            Collections.sort (messages,
               new Comparator()
               {
                  public int compare (Object o1, Object o2)
                  {
                     Message msg1 = (Message) o1;
                     Message msg2 = (Message) o2;
                     return compareStrings (msg1.getMessageCategory(), msg2.getMessageCategory(), ascending);
                  }
               });
            break;
         case COLUMN_TIME:
            Collections.sort (messages,
               new Comparator()
               {
                  public int compare (Object o1, Object o2)
                  {
                     Message msg1 = (Message) o1;
                     Message msg2 = (Message) o2;
                     return ascending ? (int)  (msg1.getTime() - msg2.getTime()) : (int)  (msg2.getTime() - msg1.getTime());
                  }
               });
            break;
         default:
            JOptionPane.showMessageDialog (getComponent(), "Sorting by this column is not supported.");
      }
      this.messages = new FLinkedList (messages);
      notifyModelChange();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param text1      No description provided
    * @param text2      No description provided
    * @param ascending  No description provided
    * @return           No description provided
    */
   int compareStrings (String text1, String text2, boolean ascending)
   {
      int cmp;
      if (text1 != null)
      {
         if (text2 != null)
         {
            cmp = text1.compareTo (text2);
         }
         else
         {
            cmp = -1;
         }
      }
      else
      {
         if (text2 != null)
         {
            cmp = 1;
         }
         else
         {
            cmp = 0;
         }
      }
      return ascending ? cmp : -cmp;
   }


   /**
    * getter for field component
    *
    * @return   current value of field component
    */
   public JComponent getComponent()
   {
      return this.component;
   }


   /**
    * store the value for field component
    */
   private JComponent component;

}

/*
 * $Log: MessageView.java,v $
 * Revision 1.2.2.2  2005/12/20 13:25:21  cschneid
 * fixed NPE
 *
 */
