/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.messages;



/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.1.2.1 $ $Date: 2005/12/20 13:16:52 $
 */
public class MessageWithThrowable extends Message
{
   /**
    *Constructor for class MessageWithThrowable
    */
   public MessageWithThrowable() { }


   /**
    *Constructor for class MessageWithThrowable
    *
    * @param text  No description provided
    */
   public MessageWithThrowable (String text)
   {
      super (text);
   }


   /**
    * the thrown exception that resulted in this error
    * null if n/A
    */
   private Throwable throwable;


   /**
    * @return   the thrown exception that resulted in this error
    * null if n/A
    */
   public Throwable getThrowable()
   {
      return throwable;
   }


   /**
    * @param throwable  The thrown exception that resulted in this error
    */
   public void setThrowable (Throwable throwable)
   {
      this.throwable = throwable;
   }
}

/*
 * $Log: MessageWithThrowable.java,v $
 * Revision 1.1.2.1  2005/12/20 13:16:52  cschneid
 * More warning/error info, some copy/paste fixes from erik, message listener for JEM (andreas/manuel), new libs
 *
 */
