/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.2.4.1 $ $Date: 2006/06/07 09:13:32 $
 */
public interface FAssoc extends FConnection
{

   // --- Property direction ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DIRECTION_PROPERTY = "direction";


   /**
    * Get the direction attribute of the FAssoc object
    *
    * @return   The direction value
    */
   public abstract int getDirection();


   /**
    * Sets the direction attribute of the FAssoc object
    *
    * @param direction  The new direction value
    */
   public abstract void setDirection (int direction);

   // --- Property leftRole ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LEFT_ROLE_PROPERTY = "leftRole";


   /**
    * Get the leftRole attribute of the FAssoc object
    *
    * @return   The leftRole value
    */
   public abstract FRole getFLeftRole();


   /**
    * Sets the leftRole attribute of the FAssoc object
    *
    * @param leftRole  The new leftRole value
    * @return          No description provided
    */
   public abstract boolean setLeftRole (FRole leftRole);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @deprecated   Use setLeftRole (null)
    */
   public abstract void removeLeftRole();

   // --- Property rightRole
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String RIGHT_ROLE_PROPERTY = "rightRole";


   /**
    * Get the rightRole attribute of the FAssoc object
    *
    * @return   The rightRole value
    */
   public abstract FRole getFRightRole();


   /**
    * Sets the rightRole attribute of the FAssoc object
    *
    * @param rightRole  The new rightRole value
    * @return           No description provided
    */
   public abstract boolean setRightRole (FRole rightRole);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @deprecated   Use setRightRole (null)
    */
   public abstract void removeRightRole();

   // --- Property stereotype ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STEREOTYPE_PROPERTY = "stereotype";

   // --- Deprecated methods ---
   /**
    * @return       The virtualPath value
    * @deprecated   codegen
    */
   public abstract boolean isVirtualPath();


   /**
    * @return       The rolesTransient value
    * @deprecated   codegen
    */
   public abstract boolean isRolesTransient();


   /**
    * @deprecated   codegen
    */
   public abstract void removeAttrs();


   /**
    * @return       The alreadyRemoved value
    * @deprecated   codegen
    */
   public abstract boolean isAlreadyRemoved();

}

/*
 * $Log: FAssoc.java,v $
 * Revision 1.2.4.1  2006/06/07 09:13:32  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
