/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Enumeration;
import java.util.Iterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.3 $ $Date: 2004/11/19 09:11:53 $
 */
public interface FFile extends FIncrement
{

   // --- Property package ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PACKAGE_PROPERTY = "package";


   /**
    * the package to which this file belongs <pre>
    *          0,1          n            n          0,1
    * UMLFile <--------------> UMLClass <--------------> UMLPackage
    * </pre>
    *
    * @return   The package value
    */
   public abstract FPackage getFPackage();

   // --- Property contains ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CONTAINS_PROPERTY = "contains";


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInContains (FClass value);


   /**
    * @return   No description provided
    */
   public abstract Iterator iteratorOfContains();


   /**
    * @return   No description provided
    */
   public abstract int sizeOfContains();


   /**
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToContains (FClass value);


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromContains (FClass value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromContains();


   /**
    * @param index  No description provided
    * @return       The containsAt value
    */
   public abstract FClass getFContainsAt (int index);


   /**
    * @param elem  No description provided
    * @return      No description provided
    */
   public abstract int indexOfContains (FClass elem);


   /**
    * @param elem  No description provided
    * @return      No description provided
    */
   public abstract int lastIndexOfContains (FClass elem);


   /**
    * @param lowerBound  No description provided
    * @return            No description provided
    */
   public abstract Iterator iteratorOfContains (FClass lowerBound);


   /**
    * @param leftObject   No description provided
    * @param rightObject  No description provided
    * @return             The beforeOfContains value
    */
   public abstract boolean isBeforeOfContains (FClass leftObject, FClass rightObject);


   /**
    * @param leftObject   No description provided
    * @param rightObject  No description provided
    * @return             The afterOfContains value
    */
   public abstract boolean isAfterOfContains (FClass leftObject, FClass rightObject);


   /**
    * @return   The firstOfContains value
    */
   public abstract FClass getFirstOfFContains();


   /**
    * @return   The lastOfContains value
    */
   public abstract FClass getLastOfFContains();


   /**
    * @param object  No description provided
    * @return        The nextOfContains value
    */
   public abstract FClass getNextOfFContains (FClass object);


   /**
    * @param object  No description provided
    * @param index   No description provided
    * @return        The nextIndexOfContains value
    */
   public abstract FClass getNextIndexOfFContains (FClass object, int index);


   /**
    * @param object  No description provided
    * @return        The previousOfContains value
    */
   public abstract FClass getPreviousOfFContains (FClass object);


   /**
    * @param object  No description provided
    * @param index   No description provided
    * @return        The previousIndexOfContains value
    */
   public abstract FClass getPreviousIndexOfFContains (FClass object, int index);

   // --- Property importedClass ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String IMPORTED_CLASS_PROPERTY = "importedClasses";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public abstract boolean hasInImportedClasses (FClass elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Enumeration elementsOfImportedClasses();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfImportedClasses();


   /**
    * Access method for an one to n association.
    *
    * @param elem  The object added.
    */
   public abstract void addToImportedClasses (FClass elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    */
   public abstract void removeFromImportedClasses (FClass elem);

   // --- Property importedPackages ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String IMPORTED_PACKAGES_PROPERTY = "importedPackages";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public abstract boolean hasInImportedPackages (FPackage elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Enumeration elementsOfImportedPackages();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfImportedPackages();


   /**
    * Access method for an one to n association.
    *
    * @param elem  The object added.
    */
   public abstract void addToImportedPackages (FPackage elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    */
   public abstract void removeFromImportedPackages (FPackage elem);


   /**
    * @return   The footer value
    */
   public abstract StringBuffer getFooter();


   /**
    * @return       The codeGenDenied value
    * @deprecated
    */
   public abstract boolean isCodeGenDenied();


   /**
    * @return       No description provided
    * @deprecated
    */
   public abstract boolean necessaryToCreateFile();

}

/*
 * $Log: FFile.java,v $
 * Revision 1.3  2004/11/19 09:11:53  lowende
 * Deprecated warnings removed.
 * Compile warnings removed.
 *
 */
