/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $ $Date: 2004/10/22 16:41:45 $
 */
public interface FIncrement extends FElement
{

   // --- Property constraints ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CONSTRAINTS_PROPERTY = "constraints";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInConstraints (FConstraint value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfConstraints();


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToConstraints (FConstraint value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromConstraints (FConstraint value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromConstraints();

   // --- Property comment ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String COMMENT_PROPERTY = "comment";


   /**
    * Get the comment attribute of the FIncrement object
    *
    * @return   The comment value
    */
   public abstract FCommentary getFComment();


   /**
    * Sets the comment attribute of the FIncrement object
    *
    * @param comment  The new comment value
    */
   public abstract void setComment (FCommentary comment);

   // --- Property assertInUnitTest ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ASSERT_IN_UNIT_TEST_PROPERTY = "assertInUnitTest";


   /**
    * Sets the assertInUnitTest attribute of the FIncrement object
    *
    * @param value  The new assertInUnitTest value
    */
   public abstract void setAssertInUnitTest (boolean value);


   /**
    * Get the assertInUnitTest attribute of the FIncrement object
    *
    * @return   The assertInUnitTest value
    */
   public abstract boolean isAssertInUnitTest();


   // --- Property stereotypes
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STEREOTYPES_PROPERTY = "stereotypes";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean hasInStereotypes (FStereotype obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean hasKeyInStereotypes (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfStereotypes();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator keysOfStereotypes();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator entriesOfStereotypes();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfStereotypes();


   /**
    * Get the fromStereotypes attribute of the FClass object
    *
    * @param key  No description provided
    * @return     The fromStereotypes value
    */
   public abstract FStereotype getFromFStereotypes (String key);


   /**
    * Access method for an one to n association.
    *
    * @param obj  The object added.
    * @return     No description provided
    */
   public abstract boolean addToStereotypes (FStereotype obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean removeFromStereotypes (FStereotype obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean removeKeyFromStereotypes (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromStereotypes();
}

/*
 * $Log: FIncrement.java,v $
 * Revision 1.2  2004/10/22 16:41:45  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
