/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $ $Date: 2004/10/22 16:41:45 $
 */
public interface FPackage extends FIncrement
{

   // --- Property declares ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DECLARES_PROPERTY = "declares";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean hasInDeclares (FClass obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean hasKeyInDeclares (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfDeclares();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator keysOfDeclares();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator entriesOfDeclares();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfDeclares();


   /**
    * Get the fromDeclares attribute of the FPackage object
    *
    * @param key  No description provided
    * @return     The fromDeclares value
    */
   public abstract FClass getFromFDeclares (String key);


   /**
    * Access method for an one to n association.
    *
    * @param obj  The object added.
    * @return     No description provided
    */
   public abstract boolean addToDeclares (FClass obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean removeFromDeclares (FClass obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean removeKeyFromDeclares (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromDeclares();

   // --- Property packages ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PACKAGES_PROPERTY = "packages";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean hasInPackages (FPackage obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean hasKeyInPackages (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfPackages();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator keysOfPackages();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator entriesOfPackages();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfPackages();


   /**
    * Get the fromPackages attribute of the FPackage object
    *
    * @param key  No description provided
    * @return     The fromPackages value
    */
   public abstract FPackage getFromFPackages (String key);


   /**
    * Access method for an one to n association.
    *
    * @param obj  The object added.
    * @return     No description provided
    */
   public abstract boolean addToPackages (FPackage obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean removeFromPackages (FPackage obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean removeKeyFromPackages (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromPackages();

   // --- Property parent ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PARENT_PROPERTY = "parent";


   /**
    * Sets the parent attribute of the FPackage object
    *
    * @param obj  The new parent value
    * @return     No description provided
    */
   public abstract boolean setParent (FPackage obj);


   /**
    * Get the parent attribute of the FPackage object
    *
    * @return   The parent value
    */
   public abstract FPackage getFParent();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract boolean hasParent();

   // --- Derived properties ---
   /**
    * @return   the full packagename of the this package, returns an empty string if this package
    *      is the default- or the rootpackage
    */
   public abstract String getFullPackageName();


   /**
    * Get the packagePath attribute of the FPackage object
    *
    * @return   The packagePath value
    */
   public abstract String getPackagePath();
}

/*
 * $Log: FPackage.java,v $
 * Revision 1.2  2004/10/22 16:41:45  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
