/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.4 $ $Date: 2005/03/14 13:49:49 $
 */
public interface FRole extends FIncrement
{
   // Adornment = {None, Aggregation, Composition, Reference, Qualified}
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int NONE = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int AGGREGATION = NONE + 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int COMPOSITION = AGGREGATION + 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int REFERENCE = COMPOSITION + 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int QUALIFIED = REFERENCE + 1;

   // --- Property adornment ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ADORNMENT_PROPERTY = "adornment";


   /**
    * Get the adornment attribute of the UMLRole object, one of {None, Aggregation, Composition,
    * Reference, Qualified}
    *
    * @return   The adornment value
    */
   public abstract int getAdornment();


   /**
    * Sets the adornment attribute of the UMLRole object, one of {None, Aggregation, Composition,
    * Reference, Qualified}
    *
    * @param adornment  The new adornment value
    */
   public abstract void setAdornment (int adornment);


   // --- Property parsed ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PARSED_PROPERTY = "parsed";


   /**
    * Indicate that the role was generated from parsed source code.
    * If it is set to true, there will be no code generated for the role,
    * since access methods already exist in the parsed code.
    *
    * @param parsed  true, if the role was generated from parsed source code
    */
   public void setParsed (boolean parsed);


   /**
    * Indicates if the role was generated from parsed source code.
    * If it is true, there will be no code generated for the role,
    * since access methods already exist in the parsed code.
    *
    * @return   true, if the role was generated from parsed source code
    */
   public boolean isParsed();


   // --- Property target ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String TARGET_PROPERTY = "target";


   /**
    * Get the target attribute of the UMLRole object
    *
    * @return   The target value
    */
   public abstract FClass getFTarget();


   /**
    * Sets the target attribute of the UMLRole object
    *
    * @param target  The new target value
    */
   public abstract void setTarget (FClass target);

   // --- Property revRoles ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_ROLES_PROPERTY = "revRoles";


   /**
    * Sets the revRoles attribute of the UMLRole object
    *
    * @param target  The new revRoles value
    */
   public abstract void setRevRoles (FClass target);


   /**
    * Get the revRoles attribute of the UMLRole object
    *
    * @return   The revRoles value
    */
   public abstract FClass getFRevRoles();

   // --- Property card ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CARD_PROPERTY = "card";


   /**
    * Get the card attribute of the UMLRole object
    *
    * @return   The card value
    */
   public abstract FCardinality getFCard();


   /**
    * Sets the card attribute of the UMLRole object
    *
    * @param card  The new card value
    */
   public abstract void setCard (FCardinality card);

   // --- Property qualifier ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String QUALIFIER_PROPERTY = "qualifier";


   /**
    * Get the qualifier attribute of the UMLRole object
    *
    * @return   The qualifier value
    */
   public abstract FQualifier getFQualifier();


   /**
    * Sets the qualifier attribute of the UMLRole object
    *
    * @param qualifier  The new qualifier value
    */
   public abstract void setQualifier (FQualifier qualifier);

   // --- Property revQualifiedRole ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_QUALIFIED_ROLE = "revQualifiedRole";


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInRevQualifiedRole (FQualifier value);


   /**
    * @return   No description provided
    */
   public abstract Iterator iteratorOfRevQualifiedRole();


   /**
    * @return   No description provided
    */
   public abstract int sizeOfRevQualifiedRole();


   /**
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToRevQualifiedRole (FQualifier value);


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromRevQualifiedRole (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromRevQualifiedRole();

   // --- Property assoc ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ASSOC_PROPERTY = "assoc";


   /**
    * Get the assoc attribute of the UMLRole object
    *
    * @return   The assoc value
    */
   public abstract FAssoc getFAssoc();

   // --- Property partnerRole ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PARTNER_ROLE_PROPERTY = "partnerRole";


   /**
    * Get the partnerRole attribute of the UMLRole object
    *
    * @return   The partnerRole value
    */
   public abstract FRole getFPartnerRole();

   // --- Property attrName ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ATTR_NAME_PROPERTY = "attrName";


   /**
    * Returns an attribute name which represents this role. If this role has already a name,
    * this name will be returned. If this role does not have a name but has a target class,
    * a default name will be created. If this role does not have a name and no target class,
    * the return value is null.
    *
    * @return   The attribute name as a string.
    */
   public abstract String getAttrName();

   // --- Deprecated methods ---

   /**
    * Get the sortedComparator attribute of the UMLAssoc object
    *
    * @return       The sortedComparator value
    * @deprecated
    */
   public abstract String getSortedComparator();


   /**
    * UMLMethod: '+ getAssociatedAttribute (): UMLAttr'.
    *
    * @return       The associatedAttribute value
    * @deprecated
    */

   public abstract FAttr getFAssociatedAttribute();


   /**
    * Get the umlVisibility attribute of the UMLRole object
    *
    * @return       The umlVisibility value
    * @deprecated
    */
   public abstract int getUmlVisibility();


   /**
    * @param value  The new umlVisibility value
    * @deprecated
    */
   public abstract void setUmlVisibility (int value);

}

/*
 * $Log: FRole.java,v $
 * Revision 1.4  2005/03/14 13:49:49  lowende
 * Roles can now be set to parsed.
 * Code will not be generated for parsed roles,
 * since code already exists in reverse engineered models.
 *
 */
