/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import de.uni_paderborn.fujaba.basic.UniqueIdentifier;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.upb.tools.pcs.PropertyChangeClient;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.3 $ $Date: 2005/02/14 14:28:11 $
 */
public interface FType extends LogicUnparseInterface, PropertyChangeClient, UniqueIdentifier, FElement
{

   // --- Property name ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NAME_PROPERTY = "name";


   /**
    * Get the name attribute of the FType object
    *
    * @return   The name value
    */
   public abstract String getName();


   /**
    * Sets the name attribute of the FType object
    *
    * @param name  The new name value
    */
   public abstract void setName (String name);

   // --- Deprecated methods ---
   /**
    * Get the progLangType attribute of the FType object
    *
    * @return       The progLangType value
    * @deprecated
    */
   public String getProgLangType();

   // ######################################################################

   /**
    * Use this function to get the real type of the associatet FType.
    *
    * @return       the real FType, if the current object is a array this function returns
    *      the real FType of this array
    * @deprecated
    */
   public FType getFRealType();


   /**
    * Get the fRevArrayType attribute of the FType object
    *
    * @return   The fRevArrayType value
    */
   public FArray getFRevArrayType();

}

/*
 * $Log: FType.java,v $
 * Revision 1.3  2005/02/14 14:28:11  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
